/*
 * Decompiled with CFR 0.152.
 */
package climateControl.customGenLayer;

import climateControl.utils.Acceptor;
import climateControl.utils.PlaneLocated;
import climateControl.utils.PlaneLocation;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashSet;

class PlaneLocatedRecorder
extends Acceptor<PlaneLocated<Integer>> {
    final DataOutputStream recording;
    final HashSet<PlaneLocation> alreadyRecorded = new HashSet();

    public PlaneLocatedRecorder(DataOutputStream target) {
        this.recording = target;
    }

    public void writeSeed(long seed) {
        try {
            this.recording.writeUTF("seed " + seed + '\r');
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public void accept(PlaneLocated<Integer> accepted) {
        for (PlaneLocation location : accepted.locations()) {
            if (this.alreadyRecorded.contains(location)) continue;
            this.alreadyRecorded.add(location);
            String toWrite = "" + location.x() + '\t' + location.z() + '\t' + accepted.get(location) + '\r';
            try {
                this.recording.writeUTF(toWrite);
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
    }
}

