/*
 * Decompiled with CFR 0.152.
 */
package climateControl.customGenLayer;

import climateControl.genLayerPack.GenLayerPack;
import climateControl.utils.PlaneLocated;
import climateControl.utils.PlaneLocation;
import climateControl.utils.Zeno410Logger;
import java.util.HashMap;
import java.util.logging.Logger;
import net.minecraft.world.gen.layer.GenLayer;
import net.minecraft.world.gen.layer.IntCache;

public class GenLayerLock
extends GenLayerPack {
    public static Logger logger = new Zeno410Logger("GenLayerLock").logger();
    private boolean watching = false;
    private PlaneLocated<Integer> storedVals;
    private int excludeEdge = 3;

    public GenLayerLock(GenLayer parent, PlaneLocated<Integer> storedVals, int excludeEdge) {
        super(0L);
        this.field_75909_a = parent;
        this.storedVals = storedVals;
        this.excludeEdge = excludeEdge;
    }

    public void setWatch(boolean newWatching) {
        this.watching = newWatching;
    }

    @Override
    public int[] func_75904_a(int x0, int z0, int xSize, int zSize) {
        if (this.watching) {
            logger.info("location " + x0 + " " + z0 + " " + xSize + " " + zSize);
        }
        HashMap<PlaneLocation, Integer> addedVals = null;
        PlaneLocation.Probe probe = new PlaneLocation.Probe(x0, z0);
        int[] parentInts = null;
        int[] result = IntCache.func_76445_a((int)(xSize * zSize));
        for (int x = 0; x < xSize; ++x) {
            probe.setX(x + x0);
            for (int z = 0; z < zSize; ++z) {
                probe.setZ(z + z0);
                Integer locked = this.storedVals.get(probe);
                if (locked == null) {
                    if (parentInts == null) {
                        parentInts = this.field_75909_a.func_75904_a(x0, z0, xSize, zSize);
                        addedVals = new HashMap<PlaneLocation, Integer>();
                    }
                    locked = (int)parentInts[z * xSize + x];
                    result[z * xSize + x] = locked;
                    PlaneLocation location = new PlaneLocation(probe.x(), probe.z());
                    if (!this.shouldStore(location, x0, z0, xSize, zSize)) continue;
                    if (this.watching) {
                        logger.info("locking " + location.toString() + " to " + locked + " " + this.field_75909_a.toString());
                    }
                    addedVals.put(location, locked);
                    continue;
                }
                result[z * xSize + x] = locked;
            }
        }
        if (addedVals != null && addedVals.size() > 0) {
            this.storedVals.putAll(addedVals);
            if (this.watching) {
                logger.info("lock size " + this.storedVals.size());
            }
        }
        return result;
    }

    private final boolean shouldStore(PlaneLocation location, int x0, int z0, int xSize, int zSize) {
        int thisExclusion = Math.min(this.excludeEdge, xSize / 2 - 1);
        if (location.x() - x0 < thisExclusion) {
            return false;
        }
        if (location.z() - z0 < thisExclusion) {
            return false;
        }
        if (x0 + xSize - location.x() < thisExclusion) {
            return false;
        }
        return z0 + zSize - location.z() >= thisExclusion;
    }
}

