/*
 * Decompiled with CFR 0.152.
 */
package climateControl.biomeSettings;

import biomesoplenty.api.content.BOPCBiomes;
import climateControl.api.BiomeSettings;
import climateControl.api.Climate;
import climateControl.api.ClimateControlRules;
import climateControl.api.ClimateControlSettings;
import climateControl.api.ClimateDistribution;
import climateControl.biomeSettings.BiomeReplacer;
import climateControl.biomeSettings.OceanBiomeSettings;
import climateControl.utils.Acceptor;
import climateControl.utils.Mutable;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.world.biome.BiomeGenBase;

public class BoPSettings
extends BiomeSettings {
    public final BiomeSettings.Element alpsForest;
    public final BiomeSettings.Element alps;
    public final BiomeSettings.Element arctic;
    public final BiomeSettings.Element bambooForest;
    public final BiomeSettings.Element bayou;
    public final BiomeSettings.Element bog;
    public final BiomeSettings.ID boneyard;
    public final BiomeSettings.Element borealForest;
    public final BiomeSettings.ID brushland;
    public final BiomeSettings.Element canyon;
    public final BiomeSettings.ID canyonRavineSubBiome;
    public final BiomeSettings.ID canyonRavine;
    public final BiomeSettings.Element chaparral;
    public final BiomeSettings.Element cherryBlossomGrove;
    public final BiomeSettings.ID coniferousForestSnow;
    public final BiomeSettings.Element coniferousForest;
    public final BiomeSettings.Element coralReef;
    public final BiomeSettings.ID corruptedSandsNether;
    public final BiomeSettings.ID corruptedSands;
    public final BiomeSettings.Element crag;
    public final BiomeSettings.Element deadForest;
    public final BiomeSettings.Element deadSwamp;
    public final BiomeSettings.Element deciduousForest;
    public final BiomeSettings.ID dryRiver;
    public final BiomeSettings.Element fen;
    public final BiomeSettings.Element flowerField;
    public final BiomeSettings.Element frostForest;
    public final BiomeSettings.Element fungiForest;
    public final BiomeSettings.Element garden;
    public final BiomeSettings.ID glacier;
    public final BiomeSettings.Element grassland;
    public final BiomeSettings.ID gravelBeach;
    public final BiomeSettings.Element grove;
    public final BiomeSettings.Element heathland;
    public final BiomeSettings.Element highland;
    public final BiomeSettings.Element jadeCliffs;
    public final BiomeSettings.Element kelpForest;
    public final BiomeSettings.Element lavenderFields;
    public final BiomeSettings.Element lushDesert;
    public final BiomeSettings.ID lushRiver;
    public final BiomeSettings.Element lushSwamp;
    public final BiomeSettings.Element mangrove;
    public final BiomeSettings.Element mapleWoods;
    public final BiomeSettings.Element marsh;
    public final BiomeSettings.ID meadowForest;
    public final BiomeSettings.Element meadow;
    public final BiomeSettings.Element moor;
    public final BiomeSettings.Element mountain;
    public final BiomeSettings.Element mysticGrove;
    public final BiomeSettings.ID oasis;
    public final BiomeSettings.Element ominousWoods;
    public final BiomeSettings.Element orchard;
    public final BiomeSettings.Element originVally;
    public final BiomeSettings.Element outback;
    public final BiomeSettings.ID phantasmagoricInferno;
    public final BiomeSettings.Element prairie;
    public final BiomeSettings.ID quagmire;
    public final BiomeSettings.Element rainforest;
    public final BiomeSettings.Element redwoodForest;
    public final BiomeSettings.Element sacredSprings;
    public final BiomeSettings.ID savanna;
    public final BiomeSettings.ID savannaPlateau;
    public final BiomeSettings.ID scrubland;
    public final BiomeSettings.Element seasonalForest;
    public final BiomeSettings.ID seasonalSpruceForest;
    public final BiomeSettings.Element shield;
    public final BiomeSettings.ID shore;
    public final BiomeSettings.Element shrubland;
    public final BiomeSettings.Element silkglades;
    public final BiomeSettings.Element sludgepit;
    public final BiomeSettings.Element snowyConiferousForest;
    public final BiomeSettings.ID spruceWoods;
    public final BiomeSettings.Element steppe;
    public final BiomeSettings.Element temperateRainforest;
    public final BiomeSettings.Element thicket;
    public final BiomeSettings.Element tropicalRainforest;
    public final BiomeSettings.Element tropics;
    public final BiomeSettings.Element tundra;
    public final BiomeSettings.ID undergarden;
    public final BiomeSettings.ID visceralHeap;
    public final BiomeSettings.ID volcano;
    public final BiomeSettings.Element wasteland;
    public final BiomeSettings.Element wetland;
    public final BiomeSettings.Element woodland;
    public final BiomeSettings.Element denseForest;
    public final BiomeSettings.Element eucalyptusForest;
    public final BiomeSettings.Element landOfLakes;
    public final BiomeSettings.ID landOfLakesMarsh;
    public final BiomeSettings.Element xericShrubland;
    Acceptor<Integer> crashOnZero;
    Acceptor<Integer> crashOnNegative;
    private HashMap<BiomeSettings.ID, BiomeReplacer.Variable> subBiomeSets;
    static final String biomesOnName = "BoPBiomesOn";
    public final Mutable<Boolean> biomesFromConfig;
    static final String configName = "BoP";
    public final Mutable<Boolean> biomesInNewWorlds;

    public BoPSettings() {
        super(configName);
        this.alpsForest = (BiomeSettings)this.new BiomeSettings.Element("Alps Forest", 99, 0, Climate.SNOWY.name);
        this.alps = (BiomeSettings)this.new BiomeSettings.Element("Alps", 177, 5, Climate.SNOWY.name);
        this.arctic = new BiomeSettings.Element("Arctic", 178, 10, true, Climate.SNOWY.name);
        this.bambooForest = new BiomeSettings.Element("Bamboo Forest", 180, 5, true, "WARM");
        this.bayou = new BiomeSettings.Element("Bayou", 181, 10, true, "WARM");
        this.bog = new BiomeSettings.Element("Bog", 183, 7, true, "COOL");
        this.boneyard = (BiomeSettings)this.new BiomeSettings.ID("Boneyard", 111);
        this.borealForest = new BiomeSettings.Element("Boreal Forest", 184, 10, true, "COOL");
        this.brushland = new BiomeSettings.ID("Brushland", 185, true);
        this.canyon = (BiomeSettings)this.new BiomeSettings.Element("Canyon", 186, 7, "HOT");
        this.canyonRavineSubBiome = (BiomeSettings)this.new BiomeSettings.ID("Canyon Ravine (Sub-Biome)", 70);
        this.canyonRavine = (BiomeSettings)this.new BiomeSettings.ID("Canyon Ravine", 100);
        this.chaparral = new BiomeSettings.Element("Chaparral", 187, 10, true, "WARM");
        this.cherryBlossomGrove = new BiomeSettings.Element("Cherry Blossom Grove", 188, 3, true, "COOL");
        this.coniferousForestSnow = (BiomeSettings)this.new BiomeSettings.ID("Coniferous Forest (Snow)", 190);
        this.coniferousForest = new BiomeSettings.Element("Coniferous Forest", 189, 10, true, "WARM");
        this.coralReef = (BiomeSettings)this.new BiomeSettings.Element("Coral Reef", 94, 0, "OCEAN");
        this.corruptedSandsNether = (BiomeSettings)this.new BiomeSettings.ID("Corrupted Sands (Nether)", 81);
        this.corruptedSands = (BiomeSettings)this.new BiomeSettings.ID("Corrupted Sands", 109);
        this.crag = (BiomeSettings)this.new BiomeSettings.Element("Crag", 191, 3, "MEDIUM");
        this.deadForest = new BiomeSettings.Element("Dead Forest", 192, 7, true, "COOL");
        this.deadSwamp = new BiomeSettings.Element("Dead Swamp", 194, 7, true, "WARM");
        this.deciduousForest = new BiomeSettings.Element("Deciduous Forest", 196, 10, true, "WARM");
        this.dryRiver = (BiomeSettings)this.new BiomeSettings.ID("Dry River", 115);
        this.fen = (BiomeSettings)this.new BiomeSettings.Element("Fen", 198, true, "WARM");
        this.flowerField = new BiomeSettings.Element("Flower Field", 199, 3, true, "WARM");
        this.frostForest = new BiomeSettings.Element("Frost Forest", 200, 7, true, "SNOWY");
        this.fungiForest = (BiomeSettings)this.new BiomeSettings.Element("Fungi Forest", 201, 3);
        this.garden = (BiomeSettings)this.new BiomeSettings.Element("Garden", 202, 3, ClimateDistribution.MEDIUM.name());
        this.glacier = (BiomeSettings)this.new BiomeSettings.ID("Glacier", 203);
        this.grassland = (BiomeSettings)this.new BiomeSettings.Element("Grassland", 204, true, "COOL");
        this.gravelBeach = (BiomeSettings)this.new BiomeSettings.ID("Gravel Beach", 75);
        this.grove = (BiomeSettings)this.new BiomeSettings.Element("Grove", 205, 5, "COOL");
        this.heathland = (BiomeSettings)this.new BiomeSettings.Element("Heathland", 206, "COOL");
        this.highland = (BiomeSettings)this.new BiomeSettings.Element("Highland", 210, "COOL");
        this.jadeCliffs = (BiomeSettings)this.new BiomeSettings.Element("Jade Cliffs", 213, 5, "WARM");
        this.kelpForest = (BiomeSettings)this.new BiomeSettings.Element("Kelp Forest", 95, 0, "OCEAN");
        this.lavenderFields = (BiomeSettings)this.new BiomeSettings.Element("Lavender Fields", 56, 3, "WARM");
        this.lushDesert = new BiomeSettings.Element("Lush Desert", 214, 3, true, "HOT");
        this.lushRiver = (BiomeSettings)this.new BiomeSettings.ID("Lush River", 114);
        this.lushSwamp = (BiomeSettings)this.new BiomeSettings.Element("Lush Swamp", 215, true, "WARM");
        this.mangrove = (BiomeSettings)this.new BiomeSettings.Element("Mangrove", 216, 0, "WARM");
        this.mapleWoods = (BiomeSettings)this.new BiomeSettings.Element("Maple Woods", 217, true, "COOL");
        this.marsh = new BiomeSettings.Element("Marsh", 218, 7, true, "COOL");
        this.meadowForest = (BiomeSettings)this.new BiomeSettings.ID("Meadow Forest", 102);
        this.meadow = (BiomeSettings)this.new BiomeSettings.Element("Meadow", 219, true, "COOL");
        this.moor = (BiomeSettings)this.new BiomeSettings.Element("Moor", 221, true, "COOL");
        this.mountain = (BiomeSettings)this.new BiomeSettings.Element("Mountain", 222, "WARM");
        this.mysticGrove = (BiomeSettings)this.new BiomeSettings.Element("Mystic Grove", 223, 3, "MEDIUM");
        this.oasis = (BiomeSettings)this.new BiomeSettings.ID("Oasis", 224);
        this.ominousWoods = (BiomeSettings)this.new BiomeSettings.Element("Ominous Woods", 225, 3, "COOL");
        this.orchard = (BiomeSettings)this.new BiomeSettings.Element("Orchard", 226, 0, ClimateDistribution.MEDIUM.name());
        this.originVally = (BiomeSettings)this.new BiomeSettings.Element("Origin Valley", 227, 1, "MEDIUM");
        this.outback = new BiomeSettings.Element("Outback", 228, 7, true, "HOT");
        this.phantasmagoricInferno = (BiomeSettings)this.new BiomeSettings.ID("Phantasmagoric Inferno", 110);
        this.prairie = (BiomeSettings)this.new BiomeSettings.Element("Prairie", 231, true, "WARM");
        this.quagmire = (BiomeSettings)this.new BiomeSettings.ID("Quagmire", 232);
        this.rainforest = new BiomeSettings.Element("Rainforest", 233, 5, true, "WARM");
        this.redwoodForest = new BiomeSettings.Element("Redwood Forest", 234, 7, true, "COOL");
        this.sacredSprings = (BiomeSettings)this.new BiomeSettings.Element("Sacred Springs", 235, 3, ClimateDistribution.MEDIUM.name());
        this.savanna = (BiomeSettings)this.new BiomeSettings.ID("Savanna", 236);
        this.savannaPlateau = (BiomeSettings)this.new BiomeSettings.ID("Savanna Plateau (Sub-Biome)", 61);
        this.scrubland = (BiomeSettings)this.new BiomeSettings.ID("Scrubland", 237);
        this.seasonalForest = (BiomeSettings)this.new BiomeSettings.Element("Seasonal Forest", 238, true, "COOL");
        this.seasonalSpruceForest = (BiomeSettings)this.new BiomeSettings.ID("Seasonal Spruce Forest (Sub-Biome)", 62);
        this.shield = new BiomeSettings.Element("Shield", 239, 7, true, "COOL");
        this.shore = (BiomeSettings)this.new BiomeSettings.ID("Shore", 240);
        this.shrubland = (BiomeSettings)this.new BiomeSettings.Element("Shrubland", 241, true, "COOL");
        this.silkglades = (BiomeSettings)this.new BiomeSettings.Element("Silkglades", 60, 0, "COOL");
        this.sludgepit = new BiomeSettings.Element("Sludgepit", 242, 5, true, "WARM");
        this.snowyConiferousForest = (BiomeSettings)this.new BiomeSettings.Element("Snowy Coniferous Forest", 51, true, "SNOWY");
        this.spruceWoods = new BiomeSettings.ID("Spruce Woods", 243, true);
        this.steppe = new BiomeSettings.Element("Steppe", 244, 7, true, Climate.COOL.name);
        this.temperateRainforest = (BiomeSettings)this.new BiomeSettings.Element("Temperate Rainforest", 245, true, "WARM");
        this.thicket = new BiomeSettings.Element("Thicket", 246, 5, true, "COOL");
        this.tropicalRainforest = new BiomeSettings.Element("Tropical Rainforest", 248, 5, true, "HOT");
        this.tropics = new BiomeSettings.Element("Tropics", 249, 0, true, "HOT");
        this.tundra = new BiomeSettings.Element("Tundra", 250, 7, true, "SNOWY");
        this.undergarden = (BiomeSettings)this.new BiomeSettings.ID("Undergarden", 113);
        this.visceralHeap = (BiomeSettings)this.new BiomeSettings.ID("Visceral Heap", 112);
        this.volcano = (BiomeSettings)this.new BiomeSettings.ID("Volcano", 251);
        this.wasteland = (BiomeSettings)this.new BiomeSettings.Element("Wasteland", 252, 3, "HOT");
        this.wetland = new BiomeSettings.Element("Wetland", 253, 7, true, "WARM");
        this.woodland = (BiomeSettings)this.new BiomeSettings.Element("Woodland", 254, true, "WARM");
        this.denseForest = (BiomeSettings)this.new BiomeSettings.Element("Dense Forest", 56, false, "COOL");
        this.eucalyptusForest = (BiomeSettings)this.new BiomeSettings.Element("Eucalyptus Forest", 57, false, "WARM");
        this.landOfLakes = (BiomeSettings)this.new BiomeSettings.Element("Land of Lakes", 68, false, "COOL");
        this.landOfLakesMarsh = (BiomeSettings)this.new BiomeSettings.Element("Land of Lakes Marsh", 101, false, "COOL");
        this.xericShrubland = (BiomeSettings)this.new BiomeSettings.Element("Xeric Shrubland", 98, false, "HOT");
        this.crashOnZero = new Acceptor<Integer>(){

            @Override
            public void accept(Integer accepted) {
                throw new RuntimeException("Thicket incidence " + accepted);
            }
        };
        this.crashOnNegative = new Acceptor<Integer>(){

            @Override
            public void accept(Integer accepted) {
                throw new RuntimeException("Thicket ID " + accepted);
            }
        };
        this.biomesFromConfig = this.climateControlCategory.booleanSetting(biomesOnName, "", false);
        this.biomesInNewWorlds = this.climateControlCategory.booleanSetting(this.startBiomesName(configName), "Use biome in new worlds and dimensions", true);
    }

    @Override
    public void setNativeBiomeIDs(File configDirectory) {
        try {
            this.alps.setIDFrom(BOPCBiomes.alps);
            this.alpsForest.setIDFrom(BOPCBiomes.alpsForest);
            this.arctic.setIDFrom(BOPCBiomes.arctic);
            this.bambooForest.setIDFrom(BOPCBiomes.bambooForest);
            this.bayou.setIDFrom(BOPCBiomes.bayou);
            this.bog.setIDFrom(BOPCBiomes.bog);
            this.boneyard.setIDFrom(BOPCBiomes.boneyard);
            this.borealForest.setIDFrom(BOPCBiomes.borealForest);
            this.brushland.setIDFrom(BOPCBiomes.brushland);
            this.canyon.setIDFrom(BOPCBiomes.canyon);
            this.canyonRavine.setIDFrom(BOPCBiomes.canyonRavine);
            this.chaparral.setIDFrom(BOPCBiomes.chaparral);
            this.cherryBlossomGrove.setIDFrom(BOPCBiomes.cherryBlossomGrove);
            this.coniferousForest.setIDFrom(BOPCBiomes.coniferousForest);
            this.coralReef.setIDFrom(BOPCBiomes.coralReef);
            this.corruptedSands.setIDFrom(BOPCBiomes.corruptedSands);
            this.crag.setIDFrom(BOPCBiomes.crag);
            this.deadForest.setIDFrom(BOPCBiomes.deadForest);
            this.deadSwamp.setIDFrom(BOPCBiomes.deadSwamp);
            this.deciduousForest.setIDFrom(BOPCBiomes.deciduousForest);
            this.dryRiver.setIDFrom(BOPCBiomes.dryRiver);
            this.fen.setIDFrom(BOPCBiomes.fen);
            this.flowerField.setIDFrom(BOPCBiomes.flowerField);
            this.frostForest.setIDFrom(BOPCBiomes.frostForest);
            this.fungiForest.setIDFrom(BOPCBiomes.fungiForest);
            this.garden.setIDFrom(BOPCBiomes.garden);
            this.grassland.setIDFrom(BOPCBiomes.grassland);
            this.glacier.setIDFrom(BOPCBiomes.glacier);
            this.grove.setIDFrom(BOPCBiomes.grove);
            this.heathland.setIDFrom(BOPCBiomes.heathland);
            this.highland.setIDFrom(BOPCBiomes.highland);
            this.jadeCliffs.setIDFrom(BOPCBiomes.jadeCliffs);
            this.kelpForest.setIDFrom(BOPCBiomes.kelpForest);
            this.lavenderFields.setIDFrom(BOPCBiomes.lavenderFields);
            this.lushDesert.setIDFrom(BOPCBiomes.lushDesert);
            this.lushRiver.setIDFrom(BOPCBiomes.lushRiver);
            this.lushSwamp.setIDFrom(BOPCBiomes.lushSwamp);
            this.mangrove.setIDFrom(BOPCBiomes.mangrove);
            this.mapleWoods.setIDFrom(BOPCBiomes.mapleWoods);
            this.marsh.setIDFrom(BOPCBiomes.marsh);
            this.meadow.setIDFrom(BOPCBiomes.meadow);
            this.meadowForest.setIDFrom(BOPCBiomes.meadowForest);
            this.mysticGrove.setIDFrom(BOPCBiomes.mysticGrove);
            this.moor.setIDFrom(BOPCBiomes.moor);
            this.mountain.setIDFrom(BOPCBiomes.mountain);
            this.ominousWoods.setIDFrom(BOPCBiomes.ominousWoods);
            this.oasis.setIDFrom(BOPCBiomes.oasis);
            this.orchard.setIDFrom(BOPCBiomes.orchard);
            this.originVally.setIDFrom(BOPCBiomes.originValley);
            this.outback.setIDFrom(BOPCBiomes.outback);
            this.phantasmagoricInferno.setIDFrom(BOPCBiomes.phantasmagoricInferno);
            this.prairie.setIDFrom(BOPCBiomes.prairie);
            this.quagmire.setIDFrom(BOPCBiomes.quagmire);
            this.rainforest.setIDFrom(BOPCBiomes.rainforest);
            this.redwoodForest.setIDFrom(BOPCBiomes.redwoodForest);
            this.sacredSprings.setIDFrom(BOPCBiomes.sacredSprings);
            this.savanna.setIDFrom(BiomeGenBase.field_150588_X);
            this.savannaPlateau.setIDFrom(BiomeGenBase.field_150587_Y);
            this.scrubland.setIDFrom(BOPCBiomes.scrubland);
            this.seasonalForest.setIDFrom(BOPCBiomes.seasonalForest);
            this.shield.setIDFrom(BOPCBiomes.shield);
            this.shrubland.setIDFrom(BOPCBiomes.shrubland);
            this.sludgepit.setIDFrom(BOPCBiomes.sludgepit);
            this.snowyConiferousForest.setIDFrom(BOPCBiomes.snowyConiferousForest);
            this.silkglades.setIDFrom(BOPCBiomes.silkglades);
            this.spruceWoods.setIDFrom(BOPCBiomes.spruceWoods);
            this.steppe.setIDFrom(BOPCBiomes.steppe);
            this.snowyConiferousForest.setIDFrom(BOPCBiomes.snowyConiferousForest);
            this.temperateRainforest.setIDFrom(BOPCBiomes.temperateRainforest);
            this.thicket.setIDFrom(BOPCBiomes.thicket);
            this.tropicalRainforest.setIDFrom(BOPCBiomes.tropicalRainforest);
            this.tropics.setIDFrom(BOPCBiomes.tropics);
            this.tundra.setIDFrom(BOPCBiomes.tundra);
            this.undergarden.setIDFrom(BOPCBiomes.undergarden);
            this.visceralHeap.setIDFrom(BOPCBiomes.visceralHeap);
            this.volcano.setIDFrom(BOPCBiomes.volcano);
            this.wasteland.setIDFrom(BOPCBiomes.wasteland);
            this.wetland.setIDFrom(BOPCBiomes.wetland);
            this.woodland.setIDFrom(BOPCBiomes.woodland);
            try {
                this.denseForest.setIDFrom(BOPCBiomes.denseForest);
            }
            catch (NoSuchFieldError e) {
                this.denseForest.biomeID().set(-1);
            }
            try {
                this.eucalyptusForest.setIDFrom(BOPCBiomes.eucalyptusForest);
            }
            catch (NoSuchFieldError e) {
                this.eucalyptusForest.biomeID().set(-1);
            }
            try {
                this.landOfLakes.setIDFrom(BOPCBiomes.landOfLakes);
            }
            catch (NoSuchFieldError e) {
                this.landOfLakes.biomeID().set(-1);
            }
            try {
                this.landOfLakesMarsh.setIDFrom(BOPCBiomes.landOfLakesMarsh);
            }
            catch (NoSuchFieldError e) {
                this.landOfLakesMarsh.biomeID().set(-1);
            }
            try {
                this.xericShrubland.setIDFrom(BOPCBiomes.xericShrubland);
            }
            catch (NoSuchFieldError e) {
                this.xericShrubland.biomeID().set(-1);
            }
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
    }

    private BiomeReplacer.Variable subBiomeSet(BiomeSettings.ID biome) {
        BiomeReplacer.Variable result = this.subBiomeSets.get(biome);
        if (result == null) {
            result = new BiomeReplacer.Variable();
            this.subBiomeSets.put(biome, result);
        }
        return result;
    }

    private void addSubBiome(BiomeSettings.ID biome, BiomeSettings.ID subBiome) {
        if (subBiome.active()) {
            this.subBiomeSet(biome).add(subBiome, 1);
            biome.setSubBiomeChooser(this.subBiomeSet(biome));
        }
    }

    public void setSubBiomes(ClimateControlSettings settings) {
        this.subBiomeSets = new HashMap();
        ArrayList<BiomeSettings> biomeSettings = settings.biomeSettings();
        for (BiomeSettings biomeSetting : biomeSettings) {
            if (!(biomeSetting instanceof OceanBiomeSettings)) continue;
            OceanBiomeSettings oceanSettings = (OceanBiomeSettings)biomeSetting;
            this.addSubBiome(oceanSettings.coastalOcean, this.coralReef);
            this.addSubBiome(oceanSettings.coastalOcean, this.kelpForest);
        }
    }

    @Override
    public void setRules(ClimateControlRules rules) {
        rules.noBeaches(this.coralReef.biomeID().value());
        rules.noBeaches(this.kelpForest.biomeID().value());
        this.setVillages(rules);
    }

    @Override
    public void onNewWorld() {
        this.biomesFromConfig.set(this.biomesInNewWorlds);
    }

    @Override
    public boolean biomesAreActive() {
        return this.biomesFromConfig.value();
    }
}

