/*
 * Decompiled with CFR 0.152.
 */
package climateControl.biomeSettings;

import climateControl.api.BiomeSettings;
import climateControl.utils.IntRandomizer;

public abstract class BiomeReplacer {
    public static final BiomeReplacer noChange = new NoChange();

    public abstract int replacement(int var1, IntRandomizer var2, int var3, int var4);

    private static class NoChange
    extends BiomeReplacer {
        private NoChange() {
        }

        @Override
        public int replacement(int biome, IntRandomizer randomizer, int x, int y) {
            return biome;
        }
    }

    public static class Multiple
    extends BiomeReplacer {
        private final BiomeReplacer first;
        private final BiomeReplacer second;

        public Multiple(BiomeReplacer first, BiomeReplacer second) {
            this.first = first;
            this.second = second;
        }

        @Override
        public int replacement(int biome, IntRandomizer randomizer, int x, int y) {
            int result = this.first.replacement(biome, randomizer, x, y);
            if (biome != result) {
                return result;
            }
            return this.second.replacement(biome, randomizer, x, y);
        }
    }

    public static class Fixed
    extends BiomeReplacer {
        private final int replacement;

        public Fixed(int replacement) {
            this.replacement = replacement;
        }

        @Override
        public int replacement(int biome, IntRandomizer randomizer, int x, int y) {
            return this.replacement;
        }
    }

    public static class Variable
    extends BiomeReplacer {
        private int totalPossibilities;
        private int[] alternatives = new int[0];

        public void add(BiomeSettings.ID biome, int count) {
            int i;
            this.totalPossibilities += count;
            int[] newAlternatives = new int[this.alternatives.length + count];
            for (i = 0; i < this.alternatives.length; ++i) {
                newAlternatives[i] = this.alternatives[i];
            }
            for (i = this.alternatives.length; i < newAlternatives.length; ++i) {
                newAlternatives[i] = biome.biomeID().value();
            }
            this.alternatives = newAlternatives;
        }

        @Override
        public int replacement(int biome, IntRandomizer randomizer, int x, int y) {
            if (this.totalPossibilities == 0) {
                return biome;
            }
            int choice = randomizer.nextInt(this.totalPossibilities);
            if (choice >= this.alternatives.length) {
                return biome;
            }
            return this.alternatives[choice];
        }
    }
}

