/*
 * Decompiled with CFR 0.152.
 */
package climateControl;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.WorldSavedData;
import net.minecraft.world.storage.ISaveHandler;

public class DimensionalDataStorage<DataType extends WorldSavedData> {
    public final String dataStorageName;
    private ISaveHandler saveHandler;
    private final DataType dataType;

    public DimensionalDataStorage(ISaveHandler saveHandler, String dataStorageName, DataType dataType) {
        this.saveHandler = saveHandler;
        this.dataStorageName = dataStorageName;
        this.dataType = dataType;
    }

    public String fileName(int dimension) {
        return this.dataStorageName + dimension;
    }

    public DataType load(int dimension, DataType defaultValue) {
        if (this.saveHandler != null) {
            try {
                File file1 = this.saveHandler.func_75758_b(this.fileName(dimension));
                if (file1 != null && file1.exists()) {
                    FileInputStream fileinputstream = new FileInputStream(file1);
                    NBTTagCompound nbttagcompound = CompressedStreamTools.func_74796_a((InputStream)fileinputstream);
                    fileinputstream.close();
                    DataType data = this.dataType;
                    data.func_76184_a(nbttagcompound.func_74775_l("data"));
                    return data;
                }
            }
            catch (Exception exception1) {
                exception1.printStackTrace();
            }
        }
        return defaultValue;
    }

    public void save(DataType data, int dimension) {
        if (this.saveHandler != null) {
            try {
                File file1 = this.saveHandler.func_75758_b(this.fileName(dimension));
                if (file1 != null) {
                    NBTTagCompound tag = new NBTTagCompound();
                    data.func_76187_b(tag);
                    NBTTagCompound nbttagcompound1 = new NBTTagCompound();
                    nbttagcompound1.func_74782_a("data", (NBTBase)tag);
                    FileOutputStream fileoutputstream = new FileOutputStream(file1);
                    CompressedStreamTools.func_74799_a((NBTTagCompound)nbttagcompound1, (OutputStream)fileoutputstream);
                    fileoutputstream.close();
                }
            }
            catch (Exception exception1) {
                exception1.printStackTrace();
            }
        }
    }
}

