/*
 * Decompiled with CFR 0.152.
 */
package climateControl;

import climateControl.DimensionAccess;
import climateControl.GenLayerUpdater;
import climateControl.LockGenLayer;
import climateControl.LockGenLayers;
import climateControl.MinecraftFilesAccess;
import climateControl.SettingsTester;
import climateControl.api.BiomeSettings;
import climateControl.api.CCDimensionSettings;
import climateControl.api.ClimateControlSettings;
import climateControl.api.DimensionalSettingsRegistry;
import climateControl.customGenLayer.GenLayerLowlandRiverMix;
import climateControl.customGenLayer.GenLayerRiverMixWrapper;
import climateControl.genLayerPack.GenLayerPack;
import climateControl.generator.CorrectedContinentsGenerator;
import climateControl.generator.OneSixCompatibleGenerator;
import climateControl.generator.TestGeneratorPair;
import climateControl.generator.VanillaCompatibleGenerator;
import climateControl.utils.Accessor;
import climateControl.utils.ChunkGeneratorExtractor;
import climateControl.utils.ChunkLister;
import climateControl.utils.ConfigManager;
import climateControl.utils.Named;
import climateControl.utils.PlaneLocation;
import climateControl.utils.Settings;
import climateControl.utils.TaggedConfigManager;
import climateControl.utils.Zeno410Logger;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.event.FMLServerStoppedEvent;
import cpw.mods.fml.common.eventhandler.Event;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Random;
import java.util.logging.Logger;
import net.minecraft.init.Blocks;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.biome.WorldChunkManager;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.ChunkProviderServer;
import net.minecraft.world.gen.feature.WorldGeneratorBonusChest;
import net.minecraft.world.gen.layer.GenLayer;
import net.minecraft.world.gen.layer.GenLayerRiverMix;
import net.minecraft.world.gen.layer.IntCache;
import net.minecraft.world.gen.structure.MapGenVillage;
import net.minecraft.world.storage.WorldInfo;
import net.minecraftforge.common.ChestGenHooks;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.event.terraingen.WorldTypeEvent;
import net.minecraftforge.event.world.WorldEvent;

public class DimensionManager {
    public static Logger logger = new Zeno410Logger("DimensionManager").logger();
    private Accessor<GenLayerRiverMix, GenLayerPack> riverMixBiome = new Accessor("field_75910_b", "biomePatternGeneratorChain");
    private final ClimateControlSettings newSettings;
    private final CCDimensionSettings dimensionSettings;
    private GenLayerUpdater genLayerUpdater = new GenLayerUpdater();
    private HashMap<Integer, ClimateControlSettings> dimensionalSettings = new HashMap();
    private HashMap<Integer, GenLayerRiverMixWrapper> wrappers = new HashMap();
    private final File suggestedConfigFile;
    private final File configDirectory;
    private TaggedConfigManager addonConfigManager = new TaggedConfigManager("climatecontrol.cfg", "ClimateControl");
    private GenLayer original;
    private HashSet<Integer> dimensionsDone = new HashSet();
    PlaneLocation lastTry = new PlaneLocation(Integer.MIN_VALUE, Integer.MIN_VALUE);

    public DimensionManager(ClimateControlSettings newSettings, CCDimensionSettings dimensionSettings, MinecraftServer server) {
        this.newSettings = newSettings;
        this.dimensionSettings = dimensionSettings;
        if (server == null) {
            this.configDirectory = null;
            this.suggestedConfigFile = null;
            return;
        }
        this.configDirectory = server.func_71209_f("config");
        this.suggestedConfigFile = new File(this.configDirectory, "climatecontrol.cfg");
    }

    private GenLayerRiverMix patchedGenLayer(ClimateControlSettings settings, WorldType worldType, long worldSeed) {
        for (BiomeSettings biomeSettings : settings.biomeSettings()) {
        }
        if (this.ignore(worldType, settings)) {
            return null;
        }
        if (settings.noGenerationChanges.value().booleanValue()) {
            if (settings.oneSixCompatibility.value().booleanValue()) {
                return new OneSixCompatibleGenerator(settings).fromSeed(worldSeed, worldType);
            }
            return null;
        }
        new SettingsTester().test(settings);
        GenLayerRiverMix newMix = null;
        newMix = settings.vanillaLandAndClimate.value() != false ? new VanillaCompatibleGenerator(settings).fromSeed(worldSeed, worldType) : new CorrectedContinentsGenerator(settings, this.configDirectory.getParentFile()).fromSeed(worldSeed, worldType);
        GenLayer oldGen = null;
        GenLayer newGen = this.riverMixBiome.get(newMix);
        TestGeneratorPair pair = new TestGeneratorPair(oldGen, newGen);
        while (pair.hasNext()) {
            pair = pair.next();
        }
        if (newMix instanceof GenLayerLowlandRiverMix) {
            ((GenLayerLowlandRiverMix)newMix).setMaxChasm(settings.maxRiverChasm.value().floatValue());
        }
        for (BiomeSettings biomeSettings : settings.biomeSettings()) {
        }
        return newMix;
    }

    private ClimateControlSettings newSettings() {
        return this.newSettings;
    }

    private GenLayerRiverMixWrapper riverLayerWrapper(int dimension) {
        GenLayerRiverMixWrapper result = this.wrappers.get(dimension);
        if (result == null) {
            result = new GenLayerRiverMixWrapper(0L);
            result.setOriginal(this.original);
            this.wrappers.put(dimension, result);
        }
        return result;
    }

    private ClimateControlSettings defaultSettings(MinecraftFilesAccess dimension, boolean newWorld) {
        ClimateControlSettings result = this.defaultSettings(newWorld);
        if (!dimension.baseDirectory().exists()) {
            dimension.baseDirectory().mkdir();
            if (!dimension.baseDirectory().exists()) {
                // empty if block
            }
        }
        Configuration workingConfig = new Configuration(this.suggestedConfigFile);
        workingConfig.load();
        ConfigManager<ClimateControlSettings> workingConfigManager = new ConfigManager<ClimateControlSettings>(workingConfig, result, this.suggestedConfigFile);
        workingConfigManager.setWorldFile(dimension.baseDirectory());
        workingConfigManager.saveWorldSpecific();
        for (Named<Settings> named : result.registeredBiomeSettings()) {
            this.addonConfigManager.initializeConfig(named, this.configDirectory);
            this.addonConfigManager.updateConfig(named, this.configDirectory, dimension.configDirectory());
            if (!newWorld) continue;
            ((BiomeSettings)named.object).onNewWorld();
            this.addonConfigManager.saveConfigs(this.configDirectory, dimension.configDirectory(), named);
        }
        return result;
    }

    private ClimateControlSettings defaultSettings(boolean newWorld) {
        ClimateControlSettings result = new ClimateControlSettings();
        Configuration workingConfig = new Configuration(this.suggestedConfigFile);
        workingConfig.load();
        result.readFrom(workingConfig);
        result.setDefaults(this.configDirectory);
        for (Named<BiomeSettings> addonSetting : result.registeredBiomeSettings()) {
            if (newWorld) {
                ((BiomeSettings)addonSetting.object).onNewWorld();
            }
            this.addonConfigManager.initializeConfig(addonSetting, this.configDirectory);
            if (newWorld) {
                ((BiomeSettings)addonSetting.object).onNewWorld();
            }
            ((BiomeSettings)addonSetting.object).setNativeBiomeIDs(this.configDirectory);
        }
        return result;
    }

    private ClimateControlSettings dimensionalSettings(DimensionAccess dimension, boolean newWorld) {
        ClimateControlSettings result = this.dimensionalSettings.get(dimension.dimension);
        if (result == null) {
            result = this.defaultSettings(dimension, newWorld);
            DimensionalSettingsRegistry.instance.modify(dimension.dimension, result);
            this.dimensionalSettings.put(dimension.dimension, result);
        }
        return result;
    }

    public void onBiomeGenInit(WorldTypeEvent.InitBiomeGens event) {
        ClimateControlSettings generationSettings = this.defaultSettings(true);
        generationSettings.onNewWorld();
        if (this.ignore(event.worldType, this.newSettings)) {
            return;
        }
        MinecraftServer server = MinecraftServer.func_71276_C();
        if (server == null) {
            this.original = event.originalBiomeGens[0];
            this.riverLayerWrapper(0).setOriginal(event.originalBiomeGens[0]);
            this.riverLayerWrapper(0).useOriginal();
            return;
        }
        boolean newWorld = true;
        for (WorldServer worldServer : server.field_71305_c) {
            if (worldServer.func_82737_E() <= 0L) continue;
            newWorld = false;
        }
        this.original = event.originalBiomeGens[0];
        this.riverLayerWrapper(0).setOriginal(event.originalBiomeGens[0]);
        if (generationSettings.noGenerationChanges.value().booleanValue()) {
            event.newBiomeGens = this.riverLayerWrapper(0).modifiedGenerators();
            this.riverLayerWrapper(0).useOriginal();
            return;
        }
        if (FMLCommonHandler.instance().getEffectiveSide().isServer()) {
            GenLayerRiverMix patched = this.patchedGenLayer(generationSettings, event.worldType, event.seed);
            this.riverLayerWrapper(0).setRedirection(patched);
            event.newBiomeGens = this.riverLayerWrapper(0).modifiedGenerators();
            event.setResult(Event.Result.ALLOW);
        }
    }

    public void serverStopped(FMLServerStoppedEvent event) {
        new HashMap();
        this.dimensionalSettings = new HashMap();
    }

    private boolean ignore(WorldType considered, ClimateControlSettings settings) {
        if (considered == null) {
            return true;
        }
        if (!settings.suppressInStandardWorlds.value().booleanValue()) {
            if (considered.equals(WorldType.field_151360_e)) {
                return false;
            }
            if (considered.equals(WorldType.field_77137_b)) {
                return false;
            }
            if (considered.equals(WorldType.field_77136_e)) {
                return false;
            }
            if (considered.equals(WorldType.field_77135_d)) {
                return false;
            }
        }
        if (considered.equals(WorldType.field_77138_c)) {
            return true;
        }
        if (settings.interveneInBOPWorlds.value().booleanValue() && considered.func_77127_a().equalsIgnoreCase("BIOMESOP")) {
            return false;
        }
        if (settings.interveneInHighlandsWorlds.value().booleanValue()) {
            if (considered.func_77127_a().equalsIgnoreCase("Highlands")) {
                return false;
            }
            if (considered.func_77127_a().equalsIgnoreCase("HighlandsLB")) {
                return false;
            }
        }
        if (considered.func_77127_a().equalsIgnoreCase("FWG")) {
            return false;
        }
        return !considered.func_77127_a().equalsIgnoreCase("RTG");
    }

    public void onCreateSpawn(WorldEvent.CreateSpawnPosition event) {
        WorldServer world = (WorldServer)event.world;
        if (this.ignore(world.field_73011_w.field_76577_b, this.newSettings)) {
            return;
        }
        int dimension = world.field_73011_w.field_76574_g;
        if (!this.dimensionSettings.ccOnIn(dimension) && !DimensionalSettingsRegistry.instance.useCCIn(dimension)) {
            return;
        }
        this.onWorldLoad(event.world);
        this.salvageSpawn(event.world);
        if (event.settings.func_77167_c()) {
            int k;
            int l;
            int j;
            Random rand = new Random(world.func_72905_C());
            WorldGeneratorBonusChest worldgeneratorbonuschest = new WorldGeneratorBonusChest(ChestGenHooks.getItems((String)"bonusChest", (Random)rand), ChestGenHooks.getCount((String)"bonusChest", (Random)rand));
            for (int i = 0; !(i >= 100 || world.func_147439_a(j = world.func_72912_H().func_76079_c() + rand.nextInt(6 + i / 10) - rand.nextInt(6 + i / 10), l = world.func_72825_h(j, k = world.func_72912_H().func_76074_e() + rand.nextInt(6 + i / 10) - rand.nextInt(6 + i / 10)) + 1, k).equals(Blocks.field_150350_a) && worldgeneratorbonuschest.func_76484_a((World)world, rand, j, l, k)); ++i) {
            }
        }
        event.setCanceled(true);
    }

    public void onWorldLoad(World world) {
        if (this.dimensionsDone.contains(world.field_73011_w.field_76574_g)) {
            return;
        }
        this.dimensionsDone.add(world.field_73011_w.field_76574_g);
        if (this.ignore(world.field_73011_w.field_76577_b, this.newSettings)) {
            return;
        }
        int dimension = world.field_73011_w.field_76574_g;
        if (!this.dimensionSettings.ccOnIn(dimension) && !DimensionalSettingsRegistry.instance.useCCIn(dimension)) {
            return;
        }
        if (world.field_72995_K) {
            return;
        }
        if (!(world instanceof WorldServer)) {
            return;
        }
        WorldServer worldServer = (WorldServer)world;
        DimensionAccess dimensionAccess = new DimensionAccess(dimension, worldServer);
        long worldSeed = world.func_72905_C();
        if (world instanceof WorldServer && worldSeed != 0L) {
            block18: {
                ClimateControlSettings currentSettings = null;
                boolean newWorld = false;
                if (world.func_72912_H().func_82573_f() < 100L) {
                    newWorld = true;
                }
                currentSettings = this.dimensionalSettings(dimensionAccess, newWorld);
                this.riverLayerWrapper(dimension).setOriginal(this.original);
                try {
                    GenLayerRiverMix patched = this.patchedGenLayer(currentSettings, world.field_73011_w.field_76577_b, worldSeed);
                    if (patched != null) {
                        this.riverLayerWrapper(dimension).setRedirection(patched);
                        this.genLayerUpdater.update(this.riverLayerWrapper(dimension), world.field_73011_w);
                        this.riverLayerWrapper(dimension).lock(dimension, world, currentSettings);
                    } else {
                        LockGenLayers biomeLocker = new LockGenLayers();
                        Accessor worldGenLayer = new Accessor("field_76944_d", "genBiomes");
                        WorldChunkManager chunkGenerator = world.func_72959_q();
                        GenLayer toLock = (GenLayer)worldGenLayer.get(chunkGenerator);
                        if (toLock instanceof GenLayerRiverMixWrapper) {
                            toLock = this.original;
                        }
                        Accessor riverMixBiome = new Accessor("field_75910_b", "biomePatternGeneratorChain");
                        toLock = (GenLayer)riverMixBiome.get((GenLayerRiverMix)toLock);
                        biomeLocker.lock(toLock, dimension, world, currentSettings);
                    }
                    if (currentSettings.vanillaLandAndClimate.value().booleanValue() || currentSettings.noGenerationChanges.value().booleanValue()) break block18;
                    try {
                        new ChunkGeneratorExtractor().impose((WorldServer)world, new MapGenVillage());
                    }
                    catch (Exception biomeLocker) {
                    }
                    catch (NoClassDefFoundError biomeLocker) {
                        // empty catch block
                    }
                    if (world.func_72912_H().func_82573_f() < 40000L) {
                        ArrayList<PlaneLocation> existingChunks = new ChunkLister().savedChunks(this.levelSavePath((WorldServer)world));
                        logger.info("existing chunks:" + existingChunks.size());
                    }
                }
                catch (Exception e) {
                    logger.info(e.toString());
                    logger.info(e.getMessage());
                    throw new RuntimeException(e);
                }
                catch (Error e) {
                    logger.info(e.toString());
                    logger.info(e.getMessage());
                }
            }
            logger.info("start rescued");
        } else {
            this.genLayerUpdater.update(this.riverLayerWrapper(dimension), world.field_73011_w);
            LockGenLayer.logger.info(world.toString());
        }
    }

    private void salvageSpawn(World world) {
        WorldInfo info = world.func_72912_H();
        int x = info.func_76079_c() / 16 * 16 + this.newSettings().xSpawnOffset.value();
        int z = info.func_76074_e() / 16 * 16 + this.newSettings().zSpawnOffset.value();
        int move = 0;
        int ring = 0;
        int xMove = 0;
        int zMove = 0;
        int spawnX = 0;
        int spawnZ = 0;
        int spawnY = 0;
        BiomeGenBase checkSpawn = world.func_72807_a(x, z);
        int nextTry = 50;
        int nextTryIncrement = 80;
        int nextTryStretch = 20;
        IChunkProvider chunkManager = world.func_72863_F();
        ChunkProviderServer chunkServer = null;
        chunkServer = (ChunkProviderServer)chunkManager;
        int checked = 0;
        int rescueTries = 0;
        while (spawnY < 64) {
            if (this.newSettings.rescueSearchLimit.value() == rescueTries++) {
                return;
            }
            if (checked > 50) {
                if (chunkServer != null) {
                    chunkServer.func_73240_a();
                }
                checked = 0;
            }
            if (chunkServer != null) {
                // empty if block
            }
            ++checked;
            if (++move > ring * (ring + 1) * 4) {
                ++ring;
            }
            if (move < nextTry) continue;
            nextTry += (nextTryIncrement += nextTryStretch++);
            int inRing = move - (ring - 1) * ring * 4;
            if (inRing > ring * 6) {
                xMove = -ring;
                zMove = ring - (inRing - ring * 6) + 1;
            } else if (inRing > ring * 4) {
                zMove = ring;
                xMove = ring - (inRing - ring * 4) + 1;
            } else if (inRing > ring * 2) {
                xMove = ring;
                zMove = -ring + (inRing - ring * 2) - 1;
            } else {
                zMove = -ring;
                xMove = -ring + inRing - 1;
            }
            IntCache.func_76446_a();
            logger.info("checking for spawn at " + (x + xMove * 16) + "," + (z + zMove * 16) + "move " + move + " ring " + ring + " inRing " + inRing + " caches " + IntCache.func_85144_b() + " dimension " + world.field_73011_w.field_76574_g);
            checkSpawn = world.func_72807_a(x + xMove * 16, z + zMove * 16);
            spawnX = x + xMove * 16;
            spawnZ = z + zMove * 16;
            logger.info("setting spawn at " + spawnX + "," + spawnZ);
            if (checkSpawn.field_76756_M == BiomeGenBase.field_76789_p.field_76756_M) continue;
            spawnY = world.func_72825_h(spawnX, spawnZ) + 1;
            PlaneLocation newLocation = new PlaneLocation(spawnX, spawnZ);
            logger.info(this.lastTry.toString() + newLocation.toString());
            if (!newLocation.equals(this.lastTry)) continue;
            break;
        }
        world.func_72950_A(spawnX, spawnY, spawnZ);
    }

    private String levelSavePath(WorldServer world) {
        String result = "";
        result = world.getChunkSaveLocation().getAbsolutePath();
        return result;
    }

    private boolean hasOnlySea(Chunk tested) {
        byte[] biomes;
        for (byte biome : biomes = tested.func_76605_m()) {
            if (biome == BiomeGenBase.field_76771_b.field_76756_M || biome == BiomeGenBase.field_150575_M.field_76756_M) continue;
            return false;
        }
        return true;
    }

    private boolean isSea(BiomeGenBase tested) {
        if (tested.field_76756_M == BiomeGenBase.field_76771_b.field_76756_M) {
            return true;
        }
        if (tested.field_76756_M == BiomeGenBase.field_150575_M.field_76756_M) {
            return true;
        }
        return tested.field_76756_M == BiomeGenBase.field_76789_p.field_76756_M;
    }
}

