/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.robotics.ai;

import buildcraft.api.core.IZone;
import buildcraft.api.robots.AIRobot;
import buildcraft.api.robots.EntityRobotBase;
import buildcraft.robotics.IStationFilter;
import buildcraft.robotics.ai.AIRobotGotoStation;
import buildcraft.robotics.ai.AIRobotSearchStation;

public class AIRobotSearchAndGotoStation
extends AIRobot {
    private IStationFilter filter;
    private IZone zone;

    public AIRobotSearchAndGotoStation(EntityRobotBase iRobot) {
        super(iRobot);
    }

    public AIRobotSearchAndGotoStation(EntityRobotBase iRobot, IStationFilter iFilter, IZone iZone) {
        this(iRobot);
        this.filter = iFilter;
        this.zone = iZone;
    }

    @Override
    public void start() {
        this.startDelegateAI(new AIRobotSearchStation(this.robot, this.filter, this.zone));
    }

    @Override
    public void delegateAIEnded(AIRobot ai) {
        if (ai instanceof AIRobotSearchStation) {
            if (ai.success()) {
                this.startDelegateAI(new AIRobotGotoStation(this.robot, ((AIRobotSearchStation)ai).targetStation));
            } else {
                this.setSuccess(false);
                this.terminate();
            }
        } else if (ai instanceof AIRobotGotoStation) {
            this.setSuccess(ai.success());
            this.terminate();
        }
    }
}

