/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.lumi.internal.util;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import sun.misc.Unsafe;

public final class UnsafeUtil {
    private static final Unsafe UNSAFE;
    private static final long BYTE_ARRAY_BASE_OFFSET;
    private static final long LONG_ARRAY_BASE_OFFSET;

    public static void clearArray(byte @NotNull [] arr) {
        UNSAFE.setMemory(arr, BYTE_ARRAY_BASE_OFFSET, arr.length, (byte)0);
    }

    public static void clearArray(long @NotNull [] arr) {
        UNSAFE.setMemory(arr, LONG_ARRAY_BASE_OFFSET, arr.length * 8, (byte)0);
    }

    @Generated
    private UnsafeUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    static {
        Field[] fields = Unsafe.class.getDeclaredFields();
        Unsafe unsafe = null;
        for (Field field : fields) {
            int modifiers;
            if (!field.getType().equals(Unsafe.class) || !Modifier.isStatic(modifiers = field.getModifiers()) || !Modifier.isFinal(modifiers)) continue;
            try {
                field.setAccessible(true);
                unsafe = (Unsafe)field.get(null);
            }
            catch (Exception exception) {}
            break;
        }
        if (unsafe == null) {
            throw new UnsupportedOperationException();
        }
        UNSAFE = unsafe;
        BYTE_ARRAY_BASE_OFFSET = UNSAFE.arrayBaseOffset(byte[].class);
        LONG_ARRAY_BASE_OFFSET = UNSAFE.arrayBaseOffset(long[].class);
    }
}

