/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.lumi.internal.storage;

import com.falsepattern.chunk.api.DataManager;
import com.falsepattern.chunk.api.DataRegistry;
import com.falsepattern.lumi.api.chunk.LumiChunk;
import com.falsepattern.lumi.api.chunk.LumiSubChunk;
import com.falsepattern.lumi.api.init.LumiExtendedBlockStorageInitHook;
import com.falsepattern.lumi.api.lighting.LumiLightingEngine;
import com.falsepattern.lumi.api.world.LumiWorld;
import com.falsepattern.lumi.api.world.LumiWorldProvider;
import com.falsepattern.lumi.internal.Lumi;
import com.falsepattern.lumi.internal.storage.Utils;
import com.falsepattern.lumi.internal.world.WorldProviderManager;
import java.util.Arrays;
import lombok.Generated;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.NibbleArray;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SubChunkNBTManager
implements DataManager.SubChunkDataManager {
    private static final Logger LOG = Lumi.createLogger("Sub Chunk NBT Manager");
    private static final SubChunkNBTManager INSTANCE = new SubChunkNBTManager();
    private boolean isRegistered = false;
    private static final byte[] EMPTY = new byte[2048];

    public static SubChunkNBTManager subChunkNBTManager() {
        return INSTANCE;
    }

    public void registerDataManager() {
        if (this.isRegistered) {
            return;
        }
        DataRegistry.registerDataManager((DataManager)this);
        this.isRegistered = true;
        LOG.info("Registered data manager");
    }

    public boolean subChunkPrivilegedAccess() {
        return true;
    }

    public String domain() {
        return "lumi";
    }

    public String id() {
        return "lumi_sub_chunk";
    }

    public void writeSubChunkToNBT(Chunk chunkBase, ExtendedBlockStorage subChunkBase, NBTTagCompound output) {
        World worldBase = chunkBase.field_76637_e;
        WorldProviderManager worldProviderManager = WorldProviderManager.worldProviderManager();
        int worldProviderCount = worldProviderManager.worldProviderCount();
        byte[] blockLight = null;
        byte[] skyLight = null;
        for (int providerInternalID = 0; providerInternalID < worldProviderCount; ++providerInternalID) {
            LumiWorld world;
            LumiWorldProvider worldProvider = worldProviderManager.getWorldProviderByInternalID(providerInternalID);
            if (worldProvider == null || (world = worldProvider.provideWorld(worldBase)) == null) continue;
            LumiSubChunk subChunk = world.lumi$wrap(subChunkBase);
            LumiChunk chunk = world.lumi$wrap(chunkBase);
            LumiLightingEngine lightingEngine = world.lumi$lightingEngine();
            NBTTagCompound worldTag = Utils.writeWorldTag(output, world, worldProvider);
            SubChunkNBTManager.writeSubChunkData(subChunk, worldTag);
            SubChunkNBTManager.writeLightingEngineData(chunk, subChunk, lightingEngine, worldTag);
            blockLight = SubChunkNBTManager.mixLights(blockLight, subChunk.lumi$getBlockLightArray());
            skyLight = SubChunkNBTManager.mixLights(skyLight, subChunk.lumi$getSkyLightArray());
        }
        output.func_74773_a("BlockLight", blockLight == null ? EMPTY : blockLight);
        output.func_74773_a("SkyLight", skyLight == null ? EMPTY : skyLight);
    }

    private static byte[] mixLights(byte[] accumulator, NibbleArray input) {
        if (input == null) {
            return accumulator;
        }
        byte[] data = input.field_76585_a;
        if (accumulator == null) {
            return Arrays.copyOf(data, data.length);
        }
        int length = accumulator.length;
        for (int i = 0; i < length; ++i) {
            byte aI = accumulator[i];
            byte dI = data[i];
            accumulator[i] = (byte)(Math.max(aI >>> 4 & 0xF, dI >>> 4 & 0xF) << 4 | Math.max(aI & 0xF, dI & 0xF));
        }
        return accumulator;
    }

    public void readSubChunkFromNBT(Chunk chunkBase, ExtendedBlockStorage subChunkBase, NBTTagCompound input) {
        NBTTagCompound domain;
        if (input.func_74764_b(this.domain()) && (domain = input.func_74775_l(this.domain())).func_74764_b(this.id())) {
            this.readSubChunkFromNBTImpl(chunkBase, subChunkBase, domain.func_74775_l(this.id()), true);
            return;
        }
        this.readSubChunkFromNBTImpl(chunkBase, subChunkBase, input, false);
    }

    public void cloneSubChunk(Chunk fromChunk, ExtendedBlockStorage fromVanilla, ExtendedBlockStorage toVanilla) {
        this.ensureInitialized(toVanilla);
        World worldBase = fromChunk.field_76637_e;
        WorldProviderManager worldProviderManager = WorldProviderManager.worldProviderManager();
        int worldProviderCount = worldProviderManager.worldProviderCount();
        for (int providerInternalID = 0; providerInternalID < worldProviderCount; ++providerInternalID) {
            LumiWorld world;
            LumiWorldProvider worldProvider = worldProviderManager.getWorldProviderByInternalID(providerInternalID);
            if (worldProvider == null || (world = worldProvider.provideWorld(worldBase)) == null) continue;
            LumiChunk chunk = world.lumi$wrap(fromChunk);
            LumiSubChunk from = world.lumi$wrap(fromVanilla);
            LumiSubChunk to = world.lumi$wrap(toVanilla);
            LumiLightingEngine lightingEngine = world.lumi$lightingEngine();
            SubChunkNBTManager.cloneSubChunkData(from, to);
            SubChunkNBTManager.cloneLightingEngineData(chunk, from, to, lightingEngine);
        }
    }

    private void ensureInitialized(ExtendedBlockStorage toVanilla) {
        LumiExtendedBlockStorageInitHook toInit = (LumiExtendedBlockStorageInitHook)toVanilla;
        if (toInit.lumi$initHookExecuted()) {
            return;
        }
        toInit.lumi$doExtendedBlockStorageInit();
    }

    public void readSubChunkFromNBTImpl(Chunk chunkBase, ExtendedBlockStorage subChunkBase, NBTTagCompound input, boolean legacy) {
        World worldBase = chunkBase.field_76637_e;
        WorldProviderManager worldProviderManager = WorldProviderManager.worldProviderManager();
        int worldProviderCount = worldProviderManager.worldProviderCount();
        for (int providerInternalID = 0; providerInternalID < worldProviderCount; ++providerInternalID) {
            LumiWorld world;
            LumiWorldProvider worldProvider = worldProviderManager.getWorldProviderByInternalID(providerInternalID);
            if (worldProvider == null || (world = worldProvider.provideWorld(worldBase)) == null) continue;
            LumiChunk chunk = world.lumi$wrap(chunkBase);
            LumiSubChunk subChunk = world.lumi$wrap(subChunkBase);
            LumiLightingEngine lightingEngine = world.lumi$lightingEngine();
            NBTTagCompound worldTag = Utils.readWorldTag(input, world, worldProvider, legacy);
            if (worldTag == null) {
                SubChunkNBTManager.initSubChunkData(subChunk);
                SubChunkNBTManager.initLightingEngineData(chunk, subChunk, lightingEngine);
                continue;
            }
            SubChunkNBTManager.readSubChunkData(subChunk, worldTag);
            SubChunkNBTManager.readLightingEngineData(chunk, subChunk, lightingEngine, worldTag);
        }
    }

    private static void initSubChunkData(LumiSubChunk subChunk) {
        NBTTagCompound emptyTag = new NBTTagCompound();
        subChunk.lumi$readFromNBT(emptyTag);
    }

    private static void initLightingEngineData(LumiChunk chunk, LumiSubChunk subChunk, LumiLightingEngine lightingEngine) {
        NBTTagCompound emptyTag = new NBTTagCompound();
        lightingEngine.readSubChunkFromNBT(chunk, subChunk, emptyTag);
    }

    private static void writeSubChunkData(LumiSubChunk subChunk, NBTTagCompound output) {
        String subChunkTagName = subChunk.lumi$subChunkID();
        NBTTagCompound subChunkTag = new NBTTagCompound();
        subChunk.lumi$writeToNBT(subChunkTag);
        output.func_74782_a(subChunkTagName, (NBTBase)subChunkTag);
    }

    private static void writeLightingEngineData(LumiChunk chunk, LumiSubChunk subChunk, LumiLightingEngine lightingEngine, NBTTagCompound worldTag) {
        String lightingEngineTagName = lightingEngine.lightingEngineID();
        NBTTagCompound lightingEngineTag = new NBTTagCompound();
        lightingEngine.writeSubChunkToNBT(chunk, subChunk, lightingEngineTag);
        worldTag.func_74782_a(lightingEngineTagName, (NBTBase)lightingEngineTag);
    }

    private static void readSubChunkData(LumiSubChunk subChunk, NBTTagCompound input) {
        String subChunkTagName = subChunk.lumi$subChunkID();
        if (input.func_150297_b(subChunkTagName, 10)) {
            NBTTagCompound subChunkTag = input.func_74775_l(subChunkTagName);
            subChunk.lumi$readFromNBT(subChunkTag);
        }
    }

    private static void readLightingEngineData(LumiChunk chunk, LumiSubChunk subChunk, LumiLightingEngine lightingEngine, NBTTagCompound input) {
        String lightingEngineTagName = lightingEngine.lightingEngineID();
        if (input.func_150297_b(lightingEngineTagName, 10)) {
            NBTTagCompound lightingEngineTag = input.func_74775_l(lightingEngineTagName);
            lightingEngine.readSubChunkFromNBT(chunk, subChunk, lightingEngineTag);
        }
    }

    private static void cloneSubChunkData(LumiSubChunk from, LumiSubChunk to) {
        to.lumi$cloneFrom(from);
    }

    private static void cloneLightingEngineData(LumiChunk fromChunk, LumiSubChunk from, LumiSubChunk to, LumiLightingEngine lightingEngine) {
        lightingEngine.cloneSubChunk(fromChunk, from, to);
    }

    @NotNull
    public String version() {
        return "1.2.0";
    }

    @Nullable
    public String newInstallDescription() {
        return "Lumi chunk lighting data. Chunk lighting will be recomputed from scratch when loading old worlds.";
    }

    @NotNull
    public String uninstallMessage() {
        return "Lumi chunk lighting data. Fully compatible with vanilla, corruption very unlikely.";
    }

    @Nullable
    public String versionChangeMessage(String priorVersion) {
        return null;
    }

    @Generated
    private SubChunkNBTManager() {
    }
}

