/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.lumi.internal.storage;

import com.falsepattern.chunk.api.DataManager;
import com.falsepattern.chunk.api.DataRegistry;
import com.falsepattern.lumi.api.chunk.LumiChunk;
import com.falsepattern.lumi.api.init.LumiChunkInitHook;
import com.falsepattern.lumi.api.lighting.LumiLightingEngine;
import com.falsepattern.lumi.api.world.LumiWorld;
import com.falsepattern.lumi.api.world.LumiWorldProvider;
import com.falsepattern.lumi.internal.Lumi;
import com.falsepattern.lumi.internal.storage.Utils;
import com.falsepattern.lumi.internal.world.WorldProviderManager;
import java.util.Arrays;
import lombok.Generated;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ChunkNBTManager
implements DataManager.ChunkDataManager {
    private static final Logger LOG = Lumi.createLogger("Chunk NBT Manager");
    private static final ChunkNBTManager INSTANCE = new ChunkNBTManager();
    private boolean isRegistered = false;

    public static ChunkNBTManager chunkNBTManager() {
        return INSTANCE;
    }

    public void registerDataManager() {
        if (this.isRegistered) {
            return;
        }
        DataRegistry.registerDataManager((DataManager)this);
        this.isRegistered = true;
        LOG.info("Registered data manager");
    }

    public boolean chunkPrivilegedAccess() {
        return true;
    }

    public String domain() {
        return "lumi";
    }

    public String id() {
        return "lumi_chunk";
    }

    public void writeChunkToNBT(Chunk chunkBase, NBTTagCompound output) {
        World worldBase = chunkBase.field_76637_e;
        WorldProviderManager worldProviderManager = WorldProviderManager.worldProviderManager();
        int worldProviderCount = worldProviderManager.worldProviderCount();
        boolean populated = true;
        int[] heightMap = null;
        for (int providerInternalID = 0; providerInternalID < worldProviderCount; ++providerInternalID) {
            LumiWorld world;
            LumiWorldProvider worldProvider = worldProviderManager.getWorldProviderByInternalID(providerInternalID);
            if (worldProvider == null || (world = worldProvider.provideWorld(worldBase)) == null) continue;
            LumiChunk chunk = world.lumi$wrap(chunkBase);
            LumiLightingEngine lightingEngine = world.lumi$lightingEngine();
            NBTTagCompound worldTag = Utils.writeWorldTag(output, world, worldProvider);
            ChunkNBTManager.writeChunkData(chunk, worldTag);
            ChunkNBTManager.writeLightingEngineData(chunk, lightingEngine, worldTag);
            populated &= chunk.lumi$isLightingInitialized();
            int[] currentHeightMap = chunk.lumi$skyLightHeightMap();
            if (currentHeightMap == null) continue;
            if (heightMap == null) {
                heightMap = Arrays.copyOf(currentHeightMap, currentHeightMap.length);
                continue;
            }
            int len = Math.min(heightMap.length, currentHeightMap.length);
            for (int i = 0; i < len; ++i) {
                heightMap[i] = Math.min(heightMap[i], currentHeightMap[i]);
            }
        }
        output.func_74783_a("HeightMap", heightMap);
        output.func_74757_a("LightPopulated", populated);
    }

    public void readChunkFromNBT(Chunk chunkBase, NBTTagCompound input) {
        NBTTagCompound domain;
        if (input.func_74764_b(this.domain()) && (domain = input.func_74775_l(this.domain())).func_74764_b(this.id())) {
            this.readChunkFromNBTImpl(chunkBase, domain.func_74775_l(this.id()), true);
            return;
        }
        this.readChunkFromNBTImpl(chunkBase, input, false);
    }

    public void cloneChunk(Chunk fromVanilla, Chunk toVanilla) {
        World worldBase = fromVanilla.field_76637_e;
        this.ensureInitialized(toVanilla, worldBase);
        WorldProviderManager worldProviderManager = WorldProviderManager.worldProviderManager();
        int worldProviderCount = worldProviderManager.worldProviderCount();
        for (int providerInternalID = 0; providerInternalID < worldProviderCount; ++providerInternalID) {
            LumiWorld world;
            LumiWorldProvider worldProvider = worldProviderManager.getWorldProviderByInternalID(providerInternalID);
            if (worldProvider == null || (world = worldProvider.provideWorld(worldBase)) == null) continue;
            LumiChunk from = world.lumi$wrap(fromVanilla);
            LumiChunk to = world.lumi$wrap(toVanilla);
            LumiLightingEngine lightingEngine = world.lumi$lightingEngine();
            ChunkNBTManager.cloneChunkData(from, to);
            ChunkNBTManager.cloneLightingEngineData(from, to, lightingEngine);
        }
    }

    private void ensureInitialized(Chunk toVanilla, World worldObj) {
        LumiChunkInitHook toInit = (LumiChunkInitHook)toVanilla;
        if (toInit.lumi$initHookExecuted()) {
            return;
        }
        boolean temporaryWorld = false;
        if (toVanilla.field_76637_e == null) {
            temporaryWorld = true;
            toVanilla.field_76637_e = worldObj;
        }
        toInit.lumi$doChunkInit();
        if (temporaryWorld) {
            toVanilla.field_76637_e = null;
        }
    }

    public void readChunkFromNBTImpl(Chunk chunkBase, NBTTagCompound input, boolean legacy) {
        World worldBase = chunkBase.field_76637_e;
        WorldProviderManager worldProviderManager = WorldProviderManager.worldProviderManager();
        int worldProviderCount = worldProviderManager.worldProviderCount();
        for (int providerInternalID = 0; providerInternalID < worldProviderCount; ++providerInternalID) {
            LumiWorld world;
            LumiWorldProvider worldProvider = worldProviderManager.getWorldProviderByInternalID(providerInternalID);
            if (worldProvider == null || (world = worldProvider.provideWorld(worldBase)) == null) continue;
            LumiChunk chunk = world.lumi$wrap(chunkBase);
            LumiLightingEngine lightingEngine = world.lumi$lightingEngine();
            NBTTagCompound worldTag = Utils.readWorldTag(input, world, worldProvider, legacy);
            if (worldTag == null) {
                ChunkNBTManager.initChunkData(chunk);
                ChunkNBTManager.initLightingEngineData(chunk, lightingEngine);
                continue;
            }
            ChunkNBTManager.readChunkData(chunk, worldTag);
            ChunkNBTManager.readLightingEngineData(chunk, lightingEngine, worldTag);
        }
    }

    private static void initChunkData(LumiChunk chunk) {
        NBTTagCompound emptyTag = new NBTTagCompound();
        chunk.lumi$readFromNBT(emptyTag);
    }

    private static void initLightingEngineData(LumiChunk chunk, LumiLightingEngine lightingEngine) {
        NBTTagCompound emptyTag = new NBTTagCompound();
        lightingEngine.readChunkFromNBT(chunk, emptyTag);
    }

    private static void writeChunkData(LumiChunk chunk, NBTTagCompound output) {
        String chunkTagName = chunk.lumi$chunkID();
        NBTTagCompound chunkTag = new NBTTagCompound();
        chunk.lumi$writeToNBT(chunkTag);
        output.func_74782_a(chunkTagName, (NBTBase)chunkTag);
    }

    private static void writeLightingEngineData(LumiChunk chunk, LumiLightingEngine lightingEngine, NBTTagCompound output) {
        String lightingEngineTagName = lightingEngine.lightingEngineID();
        NBTTagCompound lightingEngineTag = new NBTTagCompound();
        lightingEngine.writeChunkToNBT(chunk, lightingEngineTag);
        output.func_74782_a(lightingEngineTagName, (NBTBase)lightingEngineTag);
    }

    private static void readChunkData(LumiChunk chunk, NBTTagCompound input) {
        String chunkTagName = chunk.lumi$chunkID();
        if (input.func_150297_b(chunkTagName, 10)) {
            NBTTagCompound chunkTag = input.func_74775_l(chunkTagName);
            chunk.lumi$readFromNBT(chunkTag);
        }
    }

    private static void readLightingEngineData(LumiChunk chunk, LumiLightingEngine lightingEngine, NBTTagCompound input) {
        String lightingEngineTagName = lightingEngine.lightingEngineID();
        if (input.func_150297_b(lightingEngineTagName, 10)) {
            NBTTagCompound lightingEngineTag = input.func_74775_l(lightingEngineTagName);
            lightingEngine.readChunkFromNBT(chunk, lightingEngineTag);
        }
    }

    private static void cloneChunkData(LumiChunk from, LumiChunk to) {
        to.lumi$cloneFrom(from);
    }

    private static void cloneLightingEngineData(LumiChunk from, LumiChunk to, LumiLightingEngine lightingEngine) {
        lightingEngine.cloneChunk(from, to);
    }

    @NotNull
    public String version() {
        return "1.2.0";
    }

    @Nullable
    public String newInstallDescription() {
        return "Lumi chunk metadata. Compatible with vanilla saves.";
    }

    @NotNull
    public String uninstallMessage() {
        return "Lumi chunk metadata. Fully compatible with vanilla, corruption very unlikely.";
    }

    @Nullable
    public String versionChangeMessage(String priorVersion) {
        return null;
    }

    @Generated
    private ChunkNBTManager() {
    }
}

