/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.lumi.internal.mixin.mixins.common.lumi;

import com.falsepattern.lumi.api.LumiAPI;
import com.falsepattern.lumi.api.chunk.LumiChunk;
import com.falsepattern.lumi.api.chunk.LumiChunkRoot;
import com.falsepattern.lumi.api.chunk.LumiSubChunk;
import com.falsepattern.lumi.api.lighting.LightType;
import com.falsepattern.lumi.api.lighting.LumiLightingEngine;
import com.falsepattern.lumi.api.world.LumiWorld;
import com.falsepattern.lumi.api.world.LumiWorldRoot;
import com.falsepattern.lumi.internal.world.DefaultWorldProvider;
import net.minecraft.block.Block;
import net.minecraft.profiler.Profiler;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Dynamic;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Unique
@Mixin(value={World.class})
public abstract class LumiWorldImplMixin
implements IBlockAccess,
LumiWorld {
    @Mutable
    @Final
    @Shadow
    public Profiler field_72984_F;
    private LumiWorldRoot lumi$root = null;
    private LumiLightingEngine lumi$lightingEngine = null;

    @Inject(method={"lumi$onWorldInit()V"}, at={@At(value="RETURN")}, remap=false, require=1)
    @Dynamic(value="Implemented by [Lumi] with the interface [com.falsepattern.lumi.api.init.LumiWorldInitHook]")
    private void lumiWorldInit(CallbackInfo ci) {
        this.lumi$root = (LumiWorldRoot)((Object)this);
        if (DefaultWorldProvider.isRegistered()) {
            this.lumi$lightingEngine = LumiAPI.provideLightingEngine(this, this.field_72984_F);
        }
    }

    @Override
    @NotNull
    public LumiWorldRoot lumi$root() {
        return this.lumi$root;
    }

    @Override
    @NotNull
    public String lumi$worldID() {
        return "lumi_world";
    }

    @Override
    @NotNull
    public LumiChunk lumi$wrap(@NotNull Chunk chunkBase) {
        return (LumiChunk)chunkBase;
    }

    @Override
    @NotNull
    public LumiSubChunk lumi$wrap(@NotNull ExtendedBlockStorage subChunkBase) {
        return (LumiSubChunk)subChunkBase;
    }

    @Override
    @Nullable
    public LumiChunk lumi$getChunkFromBlockPosIfExists(int posX, int posZ) {
        LumiChunkRoot chunkRoot = this.lumi$root.lumi$getChunkRootFromBlockPosIfExists(posX, posZ);
        if (chunkRoot instanceof LumiChunk) {
            return (LumiChunk)((Object)chunkRoot);
        }
        return null;
    }

    @Override
    @Nullable
    public LumiChunk lumi$getChunkFromChunkPosIfExists(int chunkPosX, int chunkPosZ) {
        LumiChunkRoot chunkRoot = this.lumi$root.lumi$getChunkRootFromChunkPosIfExists(chunkPosX, chunkPosZ);
        if (chunkRoot instanceof LumiChunk) {
            return (LumiChunk)((Object)chunkRoot);
        }
        return null;
    }

    @Override
    @NotNull
    public LumiLightingEngine lumi$lightingEngine() {
        return this.lumi$lightingEngine;
    }

    @Override
    public void lumi$setLightValue(@Nullable LumiChunk chunk, @NotNull LightType lightType, int posX, int posY, int posZ, int lightValue) {
        if (chunk != null) {
            int subChunkPosX = posX & 0xF;
            int subChunkPosZ = posZ & 0xF;
            chunk.lumi$setLightValue(lightType, subChunkPosX, posY, subChunkPosZ, lightValue);
        }
    }

    @Override
    public void lumi$setBlockLightValue(@Nullable LumiChunk chunk, int posX, int posY, int posZ, int lightValue) {
        if (chunk != null) {
            int subChunkPosX = posX & 0xF;
            int subChunkPosZ = posZ & 0xF;
            chunk.lumi$setBlockLightValue(subChunkPosX, posY, subChunkPosZ, lightValue);
        }
    }

    @Override
    public void lumi$setSkyLightValue(@Nullable LumiChunk chunk, int posX, int posY, int posZ, int lightValue) {
        if (!this.lumi$root().lumi$hasSky()) {
            return;
        }
        if (chunk != null) {
            int subChunkPosX = posX & 0xF;
            int subChunkPosZ = posZ & 0xF;
            chunk.lumi$setSkyLightValue(subChunkPosX, posY, subChunkPosZ, lightValue);
        }
    }

    @Override
    @NotNull
    public String lumi$blockStorageID() {
        return "lumi_world";
    }

    @Override
    @NotNull
    public LumiWorld lumi$world() {
        return this;
    }

    @Override
    public int lumi$getBrightness(@Nullable LumiChunk chunk, @NotNull LightType lightType, int posX, int posY, int posZ) {
        switch (lightType) {
            case BLOCK_LIGHT_TYPE: {
                return this.lumi$getBrightness(chunk, posX, posY, posZ);
            }
            case SKY_LIGHT_TYPE: {
                return this.lumi$getSkyLightValue(chunk, posX, posY, posZ);
            }
        }
        return 0;
    }

    @Override
    public int lumi$getBrightness(@Nullable LumiChunk chunk, int posX, int posY, int posZ) {
        if (chunk != null) {
            int subChunkPosX = posX & 0xF;
            int subChunkPosZ = posZ & 0xF;
            return chunk.lumi$getBrightness(subChunkPosX, posY, subChunkPosZ);
        }
        int blockBrightness = this.lumi$getBlockBrightness(posX, posY, posZ);
        return Math.max(blockBrightness, LightType.BLOCK_LIGHT_TYPE.defaultLightValue());
    }

    @Override
    public int lumi$getLightValue(@Nullable LumiChunk chunk, int posX, int posY, int posZ) {
        if (chunk != null) {
            int subChunkPosX = posX & 0xF;
            int subChunkPosZ = posZ & 0xF;
            return chunk.lumi$getLightValue(subChunkPosX, posY, subChunkPosZ);
        }
        return LightType.maxBaseLightValue();
    }

    @Override
    public int lumi$getLightValue(@Nullable LumiChunk chunk, @NotNull LightType lightType, int subchunkPosX, int posY, int subchunkPosZ) {
        if (chunk != null) {
            int subChunkPosX = subchunkPosX & 0xF;
            int subChunkPosZ = subchunkPosZ & 0xF;
            return chunk.lumi$getLightValue(lightType, subChunkPosX, posY, subChunkPosZ);
        }
        switch (lightType) {
            default: {
                return LightType.BLOCK_LIGHT_TYPE.defaultLightValue();
            }
            case SKY_LIGHT_TYPE: 
        }
        if (this.lumi$root().lumi$hasSky()) {
            return LightType.SKY_LIGHT_TYPE.defaultLightValue();
        }
        return 0;
    }

    @Override
    public int lumi$getBlockLightValue(@Nullable LumiChunk chunk, int posX, int posY, int posZ) {
        if (chunk != null) {
            int subChunkPosX = posX & 0xF;
            int subChunkPosZ = posZ & 0xF;
            return chunk.lumi$getBlockLightValue(subChunkPosX, posY, subChunkPosZ);
        }
        return LightType.BLOCK_LIGHT_TYPE.defaultLightValue();
    }

    @Override
    public int lumi$getSkyLightValue(@Nullable LumiChunk chunk, int posX, int posY, int posZ) {
        if (!this.lumi$root().lumi$hasSky()) {
            return 0;
        }
        if (chunk != null) {
            int subChunkPosX = posX & 0xF;
            int subChunkPosZ = posZ & 0xF;
            return chunk.lumi$getSkyLightValue(subChunkPosX, posY, subChunkPosZ);
        }
        return LightType.SKY_LIGHT_TYPE.defaultLightValue();
    }

    @Override
    public int lumi$getBlockBrightness(int posX, int posY, int posZ) {
        Block block = this.lumi$root.lumi$getBlock(posX, posY, posZ);
        return block.getLightValue((IBlockAccess)this, posX, posY, posZ);
    }

    @Override
    public int lumi$getBlockOpacity(int posX, int posY, int posZ) {
        Block block = this.lumi$root.lumi$getBlock(posX, posY, posZ);
        return block.getLightOpacity((IBlockAccess)this, posX, posY, posZ);
    }

    @Override
    public int lumi$getBlockBrightness(@NotNull Block block, int blockMeta, int posX, int posY, int posZ) {
        return block.getLightValue((IBlockAccess)this, posX, posY, posZ);
    }

    @Override
    public int lumi$getBlockOpacity(@NotNull Block block, int blockMeta, int posX, int posY, int posZ) {
        return block.getLightOpacity((IBlockAccess)this, posX, posY, posZ);
    }
}

