/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.lumi.internal.mixin.mixins.common.lumi;

import com.falsepattern.chunk.api.ArrayUtil;
import com.falsepattern.lumi.api.chunk.LumiSubChunk;
import com.falsepattern.lumi.api.chunk.LumiSubChunkRoot;
import com.falsepattern.lumi.api.lighting.LightType;
import com.falsepattern.lumi.internal.ArrayHelper;
import com.falsepattern.lumi.internal.mixin.interfaces.LumiSubChunkImpl;
import com.falsepattern.lumi.internal.util.LazyUtil;
import java.nio.ByteBuffer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.chunk.NibbleArray;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Dynamic;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Unique
@Mixin(value={ExtendedBlockStorage.class})
public abstract class LumiSubChunkImplMixin
implements LumiSubChunk,
LumiSubChunkImpl {
    @Shadow
    @Nullable
    private NibbleArray field_76679_g;
    @Shadow
    @Nullable
    private NibbleArray field_76685_h;
    private LumiSubChunkRoot lumi$root;

    @Inject(method={"lumi$onExtendedBlockStorageInit()V"}, at={@At(value="RETURN")}, remap=false, require=1)
    @Dynamic(value="Implemented by [Lumi] with the interface [com.falsepattern.lumi.api.init.LumiExtendedBlockStorageInitHook]")
    private void lumiSubChunkInit(CallbackInfo ci) {
        this.lumi$root = (LumiSubChunkRoot)((Object)this);
    }

    @Override
    @NotNull
    public LumiSubChunkRoot lumi$root() {
        return this.lumi$root;
    }

    @Override
    @NotNull
    public String lumi$subChunkID() {
        return "lumi_sub_chunk";
    }

    @Override
    public void lumi$writeToNBT(@NotNull NBTTagCompound output) {
        if (this.field_76679_g != null) {
            output.func_74773_a("block_light", this.field_76679_g.field_76585_a);
        }
        if (this.field_76685_h != null) {
            output.func_74773_a("sky_light", this.field_76685_h.field_76585_a);
        }
    }

    @Override
    public void lumi$readFromNBT(@NotNull NBTTagCompound input) {
        if (input.func_150297_b("block_light", 7)) {
            byte[] blockLightBytes = input.func_74770_j("block_light");
            if (ArrayHelper.isZero(blockLightBytes)) {
                this.field_76679_g = null;
            } else if (this.field_76679_g == null) {
                this.field_76679_g = new NibbleArray(blockLightBytes, 4);
            } else {
                System.arraycopy(blockLightBytes, 0, this.field_76679_g.field_76585_a, 0, 2048);
            }
        } else {
            this.field_76679_g = null;
        }
        if (input.func_150297_b("sky_light", 7)) {
            byte[] skyLightBytes = input.func_74770_j("sky_light");
            if (ArrayHelper.isZero(skyLightBytes)) {
                this.field_76685_h = null;
            } else if (this.field_76685_h == null) {
                this.field_76685_h = new NibbleArray(skyLightBytes, 4);
            } else {
                System.arraycopy(skyLightBytes, 0, this.field_76685_h.field_76585_a, 0, 2048);
            }
        } else {
            this.field_76685_h = null;
        }
    }

    @Override
    public void lumi$cloneFrom(LumiSubChunk from) {
        this.field_76679_g = ArrayUtil.copyArray((NibbleArray)from.lumi$getBlockLightArray(), (NibbleArray)this.lumi$getBlockLightArray());
        this.field_76685_h = ArrayUtil.copyArray((NibbleArray)from.lumi$getSkyLightArray(), (NibbleArray)this.lumi$getSkyLightArray());
    }

    @Override
    public void lumi$writeToPacket(@NotNull ByteBuffer output) {
        if (this.field_76679_g != null && ArrayHelper.isZero(this.field_76679_g.field_76585_a)) {
            this.field_76679_g = null;
            this.lumi$setDirty(true);
        }
        if (this.field_76685_h != null && ArrayHelper.isZero(this.field_76685_h.field_76585_a)) {
            this.field_76685_h = null;
            this.lumi$setDirty(true);
        }
        byte flag = (byte)((this.field_76679_g != null ? 1 : 0) | (this.field_76685_h != null ? 2 : 0));
        output.put(flag);
        if (this.field_76679_g != null) {
            output.put(this.field_76679_g.field_76585_a);
        }
        if (this.field_76685_h != null) {
            output.put(this.field_76685_h.field_76585_a);
        }
    }

    @Override
    public void lumi$readFromPacket(@NotNull ByteBuffer input) {
        boolean doSky;
        byte flag = input.get();
        boolean doBlock = (flag & 1) != 0;
        boolean bl = doSky = (flag & 2) != 0;
        if (doBlock) {
            if (this.field_76679_g == null) {
                this.field_76679_g = new NibbleArray(4096, 4);
            }
            input.get(this.field_76679_g.field_76585_a);
        } else {
            this.field_76679_g = null;
        }
        if (doSky) {
            if (this.field_76685_h == null) {
                this.field_76685_h = new NibbleArray(4096, 4);
            }
            input.get(this.field_76685_h.field_76585_a);
        } else {
            this.field_76685_h = null;
        }
        this.lumi$setDirty(true);
    }

    @Override
    public void lumi$setLightValue(@NotNull LightType lightType, int subChunkPosX, int subChunkPosY, int subChunkPosZ, int lightValue) {
        switch (lightType) {
            case BLOCK_LIGHT_TYPE: {
                this.lumi$setBlockLightValue(subChunkPosX, subChunkPosY, subChunkPosZ, lightValue);
                break;
            }
            case SKY_LIGHT_TYPE: {
                this.lumi$setSkyLightValue(subChunkPosX, subChunkPosY, subChunkPosZ, lightValue);
                break;
            }
        }
    }

    @Override
    public int lumi$getLightValue(@NotNull LightType lightType, int subChunkPosX, int subChunkPosY, int subChunkPosZ) {
        switch (lightType) {
            case BLOCK_LIGHT_TYPE: {
                return this.lumi$getBlockLightValue(subChunkPosX, subChunkPosY, subChunkPosZ);
            }
            case SKY_LIGHT_TYPE: {
                return this.lumi$getSkyLightValue(subChunkPosX, subChunkPosY, subChunkPosZ);
            }
        }
        return lightType.defaultLightValue();
    }

    @Override
    public void lumi$setBlockLightValue(int subChunkPosX, int subChunkPosY, int subChunkPosZ, int lightValue) {
        this.field_76679_g = LazyUtil.lazySet(this.field_76679_g, subChunkPosX, subChunkPosY, subChunkPosZ, lightValue);
        if (this.field_76679_g != null) {
            this.lumi$setDirty(true);
        }
    }

    @Override
    public int lumi$getBlockLightValue(int subChunkPosX, int subChunkPosY, int subChunkPosZ) {
        return LazyUtil.lazyGet(this.field_76679_g, subChunkPosX, subChunkPosY, subChunkPosZ);
    }

    @Override
    public void lumi$setSkyLightValue(int subChunkPosX, int subChunkPosY, int subChunkPosZ, int lightValue) {
        this.field_76685_h = LazyUtil.lazySet(this.field_76685_h, subChunkPosX, subChunkPosY, subChunkPosZ, lightValue);
        if (this.field_76685_h != null) {
            this.lumi$setDirty(true);
        }
    }

    @Override
    public int lumi$getSkyLightValue(int subChunkPosX, int subChunkPosY, int subChunkPosZ) {
        return LazyUtil.lazyGet(this.field_76685_h, subChunkPosX, subChunkPosY, subChunkPosZ);
    }

    @Override
    public NibbleArray lumi$getBlockLightArray() {
        return this.field_76679_g;
    }

    @Override
    public NibbleArray lumi$getSkyLightArray() {
        return this.field_76685_h;
    }
}

