/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.lumi.internal.mixin.mixins.common.lumi;

import com.falsepattern.chunk.api.ArrayUtil;
import com.falsepattern.lumi.api.LumiChunkAPI;
import com.falsepattern.lumi.api.chunk.LumiChunk;
import com.falsepattern.lumi.api.chunk.LumiChunkRoot;
import com.falsepattern.lumi.api.chunk.LumiSubChunk;
import com.falsepattern.lumi.api.lighting.LightType;
import com.falsepattern.lumi.api.world.LumiWorld;
import java.nio.ByteBuffer;
import net.minecraft.block.Block;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Dynamic;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Unique
@Mixin(value={Chunk.class})
public abstract class LumiChunkImplMixin
implements LumiChunk {
    @Final
    @Shadow
    public int field_76635_g;
    @Final
    @Shadow
    public int field_76647_h;
    @Shadow
    private ExtendedBlockStorage[] field_76652_q;
    @Shadow
    private int field_76649_t;
    @Shadow
    public boolean[] field_76639_c;
    @Shadow
    public World field_76637_e;
    @Shadow
    public int[] field_76634_f;
    @Shadow
    public int field_82912_p;
    private LumiChunkRoot lumi$root;
    private LumiWorld lumi$world;
    private boolean lumi$isLightingInitialized;

    @Inject(method={"lumi$onChunkInit()V"}, at={@At(value="RETURN")}, remap=false, require=1)
    @Dynamic(value="Implemented by [Lumi] with the interface [com.falsepattern.lumi.api.init.LumiChunkInitHook]")
    private void lumiChunkInit(CallbackInfo ci) {
        this.lumi$root = (LumiChunkRoot)((Object)this);
        this.lumi$world = (LumiWorld)this.field_76637_e;
        this.lumi$isLightingInitialized = false;
    }

    @Override
    @NotNull
    public LumiChunkRoot lumi$root() {
        return this.lumi$root;
    }

    @Override
    @NotNull
    public LumiWorld lumi$world() {
        return this.lumi$world;
    }

    @Override
    @NotNull
    public String lumi$chunkID() {
        return "lumi_chunk";
    }

    @Override
    public void lumi$writeToNBT(@NotNull NBTTagCompound output) {
        output.func_74783_a("sky_light_height_map", this.field_76634_f);
        output.func_74757_a("lighting_initialized", this.lumi$isLightingInitialized);
    }

    @Override
    public void lumi$readFromNBT(@NotNull NBTTagCompound input) {
        int[] skyLightHeightMapInput;
        boolean isLightInitializedInput;
        this.lumi$isLightingInitialized = false;
        if (input.func_150297_b("lighting_initialized", 1) && (isLightInitializedInput = input.func_74767_n("lighting_initialized")) && input.func_150297_b("sky_light_height_map", 11) && (skyLightHeightMapInput = input.func_74759_k("sky_light_height_map")).length == 256) {
            System.arraycopy(skyLightHeightMapInput, 0, this.field_76634_f, 0, 256);
            this.lumi$isLightingInitialized = true;
        }
        if (!this.lumi$isLightingInitialized) {
            LumiChunkAPI.scheduleChunkLightingEngineInit(this);
        }
    }

    @Override
    public void lumi$cloneFrom(@NotNull LumiChunk from) {
        this.field_76634_f = ArrayUtil.copyArray((int[])from.lumi$skyLightHeightMap(), (int[])this.lumi$skyLightHeightMap());
        this.lumi$isLightingInitialized = from.lumi$isLightingInitialized();
    }

    @Override
    public void lumi$writeToPacket(@NotNull ByteBuffer output) {
    }

    @Override
    public void lumi$readFromPacket(@NotNull ByteBuffer input) {
        this.lumi$isLightingInitialized = true;
    }

    @Override
    @Nullable
    public LumiSubChunk lumi$getSubChunkIfPrepared(int chunkPosY) {
        ExtendedBlockStorage subChunk = this.field_76652_q[chunkPosY];
        if (subChunk instanceof LumiSubChunk) {
            return (LumiSubChunk)subChunk;
        }
        return null;
    }

    @Override
    @NotNull
    public LumiSubChunk lumi$getSubChunk(int chunkPosY) {
        this.lumi$root.lumi$prepareSubChunk(chunkPosY);
        ExtendedBlockStorage subChunk = this.field_76652_q[chunkPosY];
        return (LumiSubChunk)subChunk;
    }

    @Override
    public int lumi$chunkPosX() {
        return this.field_76635_g;
    }

    @Override
    public int lumi$chunkPosZ() {
        return this.field_76647_h;
    }

    @Override
    public void lumi$queuedRandomLightUpdates(int queuedRandomLightUpdates) {
        this.field_76649_t = queuedRandomLightUpdates;
    }

    @Override
    public int lumi$queuedRandomLightUpdates() {
        return this.field_76649_t;
    }

    @Override
    public void lumi$resetQueuedRandomLightUpdates() {
        this.field_76649_t = 0;
    }

    @Override
    public int lumi$getBrightness(@NotNull LightType lightType, int subChunkPosX, int posY, int subChunkPosZ) {
        switch (lightType) {
            case BLOCK_LIGHT_TYPE: {
                return this.lumi$getBrightness(subChunkPosX, posY, subChunkPosZ);
            }
            case SKY_LIGHT_TYPE: {
                return this.lumi$getSkyLightValue(subChunkPosX, posY, subChunkPosZ);
            }
        }
        return 0;
    }

    @Override
    public int lumi$getBrightness(int subChunkPosX, int posY, int subChunkPosZ) {
        int blockBrightness = this.lumi$getBlockBrightness(subChunkPosX, posY, subChunkPosZ);
        int blockLightValue = this.lumi$getBlockLightValue(subChunkPosX, posY, subChunkPosZ);
        return Math.max(blockBrightness, blockLightValue);
    }

    @Override
    public int lumi$getLightValue(int subChunkPosX, int posY, int subChunkPosZ) {
        int blockLightValue = this.lumi$getBlockLightValue(subChunkPosX, posY, subChunkPosZ);
        int skyLightValue = this.lumi$getSkyLightValue(subChunkPosX, posY, subChunkPosZ);
        return Math.max(blockLightValue, skyLightValue);
    }

    @Override
    public void lumi$setLightValue(@NotNull LightType lightType, int subChunkPosX, int posY, int subChunkPosZ, int lightValue) {
        switch (lightType) {
            case BLOCK_LIGHT_TYPE: {
                this.lumi$setBlockLightValue(subChunkPosX, posY, subChunkPosZ, lightValue);
                break;
            }
            case SKY_LIGHT_TYPE: {
                this.lumi$setSkyLightValue(subChunkPosX, posY, subChunkPosZ, lightValue);
                break;
            }
        }
    }

    @Override
    public int lumi$getLightValue(@NotNull LightType lightType, int subChunkPosX, int posY, int subChunkPosZ) {
        switch (lightType) {
            case BLOCK_LIGHT_TYPE: {
                return this.lumi$getBlockLightValue(subChunkPosX, posY, subChunkPosZ);
            }
            case SKY_LIGHT_TYPE: {
                return this.lumi$getSkyLightValue(subChunkPosX, posY, subChunkPosZ);
            }
        }
        return 0;
    }

    @Override
    public void lumi$setBlockLightValue(int subChunkPosX, int posY, int subChunkPosZ, int lightValue) {
        int chunkPosY = (posY & 0xFF) / 16;
        int subChunkPosY = posY & 0xF;
        LumiSubChunk subChunk = this.lumi$getSubChunk(chunkPosY);
        subChunk.lumi$setBlockLightValue(subChunkPosX &= 0xF, subChunkPosY, subChunkPosZ &= 0xF, lightValue);
        this.lumi$root.lumi$markDirty();
    }

    @Override
    public int lumi$getBlockLightValue(int subChunkPosX, int posY, int subChunkPosZ) {
        int chunkPosY = (posY & 0xFF) / 16;
        LumiSubChunk subChunk = this.lumi$getSubChunk(chunkPosY);
        int subChunkPosY = posY & 0xF;
        return subChunk.lumi$getBlockLightValue(subChunkPosX &= 0xF, subChunkPosY, subChunkPosZ &= 0xF);
    }

    @Override
    public void lumi$setSkyLightValue(int subChunkPosX, int posY, int subChunkPosZ, int lightValue) {
        if (!this.lumi$world.lumi$root().lumi$hasSky()) {
            return;
        }
        int chunkPosY = (posY & 0xFF) / 16;
        int subChunkPosY = posY & 0xF;
        LumiSubChunk subChunk = this.lumi$getSubChunk(chunkPosY);
        subChunk.lumi$setSkyLightValue(subChunkPosX &= 0xF, subChunkPosY, subChunkPosZ &= 0xF, lightValue);
        this.lumi$root.lumi$markDirty();
    }

    @Override
    public int lumi$getSkyLightValue(int subChunkPosX, int posY, int subChunkPosZ) {
        if (!this.lumi$world.lumi$root().lumi$hasSky()) {
            return 0;
        }
        int chunkPosY = (posY & 0xFF) >> 4;
        LumiSubChunk subChunk = this.lumi$getSubChunk(chunkPosY);
        int subChunkPosY = posY & 0xF;
        return subChunk.lumi$getSkyLightValue(subChunkPosX &= 0xF, subChunkPosY, subChunkPosZ &= 0xF);
    }

    @Override
    public int lumi$getBlockBrightness(int subChunkPosX, int posY, int subChunkPosZ) {
        Block block = this.lumi$root.lumi$getBlock(subChunkPosX, posY, subChunkPosZ);
        int blockMeta = this.lumi$root.lumi$getBlockMeta(subChunkPosX, posY, subChunkPosZ);
        return this.lumi$getBlockBrightness(block, blockMeta, subChunkPosX, posY, subChunkPosZ);
    }

    @Override
    public int lumi$getBlockOpacity(int subChunkPosX, int posY, int subChunkPosZ) {
        Block block = this.lumi$root.lumi$getBlock(subChunkPosX, posY, subChunkPosZ);
        int blockMeta = this.lumi$root.lumi$getBlockMeta(subChunkPosX, posY, subChunkPosZ);
        return this.lumi$getBlockOpacity(block, blockMeta, subChunkPosX, posY, subChunkPosZ);
    }

    @Override
    public int lumi$getBlockBrightness(@NotNull Block block, int blockMeta, int subChunkPosX, int posY, int subChunkPosZ) {
        if (!this.lumi$isLightingInitialized) {
            return block.func_149750_m();
        }
        int posX = (this.field_76635_g << 4) + subChunkPosX;
        int posZ = (this.field_76647_h << 4) + subChunkPosZ;
        return this.lumi$world.lumi$getBlockBrightness(block, blockMeta, posX, posY, posZ);
    }

    @Override
    public int lumi$getBlockOpacity(@NotNull Block block, int blockMeta, int subChunkPosX, int posY, int subChunkPosZ) {
        if (!this.lumi$isLightingInitialized) {
            return block.func_149717_k();
        }
        int posX = (this.field_76635_g << 4) + subChunkPosX;
        int posZ = (this.field_76647_h << 4) + subChunkPosZ;
        return this.lumi$world.lumi$getBlockOpacity(block, blockMeta, posX, posY, posZ);
    }

    @Override
    public boolean lumi$canBlockSeeSky(int subChunkPosX, int posY, int subChunkPosZ) {
        int index = (subChunkPosX &= 0xF) + ((subChunkPosZ &= 0xF) << 4);
        int maxPosY = this.field_76634_f[index];
        return maxPosY <= posY;
    }

    @Override
    public void lumi$skyLightHeight(int subChunkPosX, int subChunkPosZ, int skyLightHeight) {
        int index = (subChunkPosX &= 0xF) + ((subChunkPosZ &= 0xF) << 4);
        this.field_76634_f[index] = skyLightHeight;
    }

    @Override
    public int lumi$skyLightHeight(int subChunkPosX, int subChunkPosZ) {
        int index = (subChunkPosX &= 0xF) + ((subChunkPosZ &= 0xF) << 4);
        return this.field_76634_f[index];
    }

    @Override
    public void lumi$minSkyLightHeight(int minSkyLightHeight) {
        this.field_82912_p = minSkyLightHeight;
    }

    @Override
    public int lumi$minSkyLightHeight() {
        return this.field_82912_p;
    }

    @Override
    public void lumi$resetSkyLightHeightMap() {
        LumiChunkAPI.resetHeightMapArray(this.field_76634_f);
        this.field_82912_p = Integer.MAX_VALUE;
    }

    @Override
    public void lumi$isHeightOutdated(int subChunkPosX, int subChunkPosZ, boolean isHeightOutdated) {
        int index = (subChunkPosX &= 0xF) + ((subChunkPosZ &= 0xF) << 4);
        this.field_76639_c[index] = isHeightOutdated;
    }

    @Override
    public boolean lumi$isHeightOutdated(int subChunkPosX, int subChunkPosZ) {
        int index = (subChunkPosX &= 0xF) + ((subChunkPosZ &= 0xF) << 4);
        return this.field_76639_c[index];
    }

    @Override
    public void lumi$resetOutdatedHeightFlags() {
        LumiChunkAPI.resetUpdateSkylightColumns(this.field_76639_c);
    }

    @Override
    public void lumi$isLightingInitialized(boolean isLightingInitialized) {
        this.lumi$isLightingInitialized = isLightingInitialized;
    }

    @Override
    public boolean lumi$isLightingInitialized() {
        return this.lumi$isLightingInitialized;
    }

    @Override
    public void lumi$resetLighting() {
        this.lumi$isLightingInitialized = false;
        this.lumi$world.lumi$lightingEngine().handleChunkInit(this);
    }

    @Override
    public int @NotNull [] lumi$skyLightHeightMap() {
        return this.field_76634_f;
    }
}

