/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.lumi.internal.mixin.mixins.common.lumi;

import com.falsepattern.lumi.api.chunk.LumiChunk;
import com.falsepattern.lumi.api.chunk.LumiChunkRoot;
import com.falsepattern.lumi.api.lighting.LightType;
import com.falsepattern.lumi.api.storage.LumiBlockStorage;
import com.falsepattern.lumi.api.storage.LumiBlockStorageRoot;
import com.falsepattern.lumi.api.world.LumiWorld;
import net.minecraft.block.Block;
import net.minecraft.world.ChunkCache;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Dynamic;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Unique
@Mixin(value={ChunkCache.class})
public abstract class LumiBlockCacheImplMixin
implements IBlockAccess,
LumiBlockStorage,
LumiBlockStorageRoot {
    @Shadow
    private int field_72818_a;
    @Shadow
    private int field_72816_b;
    @Shadow
    private Chunk[][] field_72817_c;
    @Shadow
    private boolean field_72814_d;
    @Shadow
    private World field_72815_e;
    private LumiWorld lumi$world = null;

    @Inject(method={"lumi$onChunkCacheInit()V"}, at={@At(value="RETURN")}, remap=false, require=1)
    @Dynamic(value="Implemented by [Lumi] with the interface [com.falsepattern.lumi.api.init.LumiChunkCacheInitHook]")
    private void lumiBlockChunkCacheInit(CallbackInfo ci) {
        this.lumi$world = (LumiWorld)this.field_72815_e;
    }

    @Override
    @NotNull
    public String lumi$blockStorageID() {
        return "lumi_block_cache";
    }

    @Override
    @NotNull
    public LumiWorld lumi$world() {
        return this.lumi$world;
    }

    @Override
    @NotNull
    public LumiBlockStorageRoot lumi$root() {
        return this;
    }

    @Override
    public int lumi$getBrightness(@Nullable LumiChunk chunk, @NotNull LightType lightType, int posX, int posY, int posZ) {
        switch (lightType) {
            case BLOCK_LIGHT_TYPE: {
                return this.lumi$getBrightness(chunk, posX, posY, posZ);
            }
            case SKY_LIGHT_TYPE: {
                return this.lumi$getSkyLightValue(chunk, posX, posY, posZ);
            }
        }
        return 0;
    }

    @Override
    public int lumi$getBrightness(@Nullable LumiChunk chunk, int posX, int posY, int posZ) {
        if (chunk != null) {
            int subChunkPosX = posX & 0xF;
            int subChunkPosZ = posZ & 0xF;
            return chunk.lumi$getBrightness(subChunkPosX, posY, subChunkPosZ);
        }
        int blockBrightness = this.lumi$getBlockBrightness(posX, posY, posZ);
        return Math.max(blockBrightness, LightType.BLOCK_LIGHT_TYPE.defaultLightValue());
    }

    @Override
    public int lumi$getLightValue(@Nullable LumiChunk chunk, int posX, int posY, int posZ) {
        if (chunk != null) {
            int subChunkPosX = posX & 0xF;
            int subChunkPosZ = posZ & 0xF;
            return chunk.lumi$getLightValue(subChunkPosX, posY, subChunkPosZ);
        }
        return LightType.maxBaseLightValue();
    }

    @Override
    public int lumi$getLightValue(@Nullable LumiChunk chunk, @NotNull LightType lightType, int posX, int posY, int posZ) {
        if (chunk != null) {
            int subChunkPosX = posX & 0xF;
            int subChunkPosZ = posZ & 0xF;
            return chunk.lumi$getLightValue(lightType, subChunkPosX, posY, subChunkPosZ);
        }
        switch (lightType) {
            default: {
                return LightType.BLOCK_LIGHT_TYPE.defaultLightValue();
            }
            case SKY_LIGHT_TYPE: 
        }
        if (this.lumi$root().lumi$hasSky()) {
            return LightType.SKY_LIGHT_TYPE.defaultLightValue();
        }
        return 0;
    }

    @Override
    public int lumi$getBlockLightValue(@Nullable LumiChunk chunk, int posX, int posY, int posZ) {
        if (chunk != null) {
            int subChunkPosX = posX & 0xF;
            int subChunkPosZ = posZ & 0xF;
            return chunk.lumi$getBlockLightValue(subChunkPosX, posY, subChunkPosZ);
        }
        return LightType.BLOCK_LIGHT_TYPE.defaultLightValue();
    }

    @Override
    public int lumi$getSkyLightValue(@Nullable LumiChunk chunk, int posX, int posY, int posZ) {
        if (!this.lumi$hasSky()) {
            return 0;
        }
        if (chunk != null) {
            int subChunkPosX = posX & 0xF;
            int subChunkPosZ = posZ & 0xF;
            return chunk.lumi$getSkyLightValue(subChunkPosX, posY, subChunkPosZ);
        }
        return LightType.SKY_LIGHT_TYPE.defaultLightValue();
    }

    @Override
    public int lumi$getBlockBrightness(int posX, int posY, int posZ) {
        Block block = this.lumi$getBlock(posX, posY, posZ);
        return block.getLightValue((IBlockAccess)this, posX, posY, posZ);
    }

    @Override
    public int lumi$getBlockOpacity(int posX, int posY, int posZ) {
        Block block = this.lumi$getBlock(posX, posY, posZ);
        return block.getLightOpacity((IBlockAccess)this, posX, posY, posZ);
    }

    @Override
    public int lumi$getBlockBrightness(@NotNull Block block, int blockMeta, int posX, int posY, int posZ) {
        return block.getLightValue((IBlockAccess)this, posX, posY, posZ);
    }

    @Override
    public int lumi$getBlockOpacity(@NotNull Block block, int blockMeta, int posX, int posY, int posZ) {
        return block.getLightOpacity((IBlockAccess)this, posX, posY, posZ);
    }

    @Override
    @Nullable
    public LumiChunk lumi$getChunkFromBlockPosIfExists(int posX, int posZ) {
        LumiChunkRoot chunk = this.lumi$getChunkRootFromBlockPosIfExists(posX, posZ);
        if (chunk instanceof LumiChunk) {
            return (LumiChunk)((Object)chunk);
        }
        return null;
    }

    @Override
    @Nullable
    public LumiChunk lumi$getChunkFromChunkPosIfExists(int chunkPosX, int chunkPosZ) {
        LumiChunkRoot chunk = this.lumi$getChunkRootFromChunkPosIfExists(chunkPosX, chunkPosZ);
        if (chunk instanceof LumiChunk) {
            return (LumiChunk)((Object)chunk);
        }
        return null;
    }
}

