/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.lumi.internal.mixin.mixins.common;

import com.falsepattern.lumi.internal.ArrayHelper;
import com.falsepattern.lumi.internal.mixin.interfaces.LumiSubChunkImpl;
import com.falsepattern.lumi.internal.util.LazyUtil;
import net.minecraft.world.chunk.NibbleArray;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ExtendedBlockStorage.class})
public abstract class ExtendedBlockStorageMixin
implements LumiSubChunkImpl {
    @Shadow
    private int field_76682_b;
    @Shadow
    private NibbleArray field_76679_g;
    @Shadow
    private NibbleArray field_76685_h;
    @Unique
    private boolean lumi$isDirty;
    @Unique
    private boolean lumi$isTrivial;
    private static final NibbleArray DUMMY = new NibbleArray(new byte[0], 4);

    @Redirect(method={"<init>"}, at=@At(value="NEW", target="(II)Lnet/minecraft/world/chunk/NibbleArray;", ordinal=1), require=1)
    private NibbleArray noBlocklightArray(int p_i1992_1_, int p_i1992_2_) {
        return DUMMY;
    }

    @Redirect(method={"<init>"}, at=@At(value="FIELD", target="Lnet/minecraft/world/chunk/storage/ExtendedBlockStorage;blocklightArray:Lnet/minecraft/world/chunk/NibbleArray;"), require=1)
    private void noPutBlockLight(ExtendedBlockStorage instance, NibbleArray value) {
    }

    @Redirect(method={"<init>"}, at=@At(value="NEW", target="(II)Lnet/minecraft/world/chunk/NibbleArray;", ordinal=2), require=1)
    private NibbleArray noSkylightArray(int p_i1992_1_, int p_i1992_2_) {
        return DUMMY;
    }

    @Redirect(method={"<init>"}, at=@At(value="FIELD", target="Lnet/minecraft/world/chunk/storage/ExtendedBlockStorage;skylightArray:Lnet/minecraft/world/chunk/NibbleArray;"), require=1)
    private void noPutSkyLight(ExtendedBlockStorage instance, NibbleArray value) {
    }

    @Overwrite
    public NibbleArray func_76661_k() {
        this.field_76679_g = LazyUtil.ensurePresent(this.field_76679_g);
        return this.field_76679_g;
    }

    @Overwrite
    public int func_76674_d(int x, int y, int z) {
        return LazyUtil.lazyGet(this.field_76679_g, x, y, z);
    }

    @Overwrite
    public NibbleArray func_76671_l() {
        this.field_76685_h = LazyUtil.ensurePresent(this.field_76685_h);
        return this.field_76685_h;
    }

    @Overwrite
    public int func_76670_c(int x, int y, int z) {
        return LazyUtil.lazyGet(this.field_76685_h, x, y, z);
    }

    @Inject(method={"<init>*"}, at={@At(value="RETURN", target="Ljava/util/Random;nextInt(I)I")}, require=1)
    private void lumiSubChunkInit(int posY, boolean hasSky, CallbackInfo ci) {
        this.lumi$isDirty = true;
        this.lumi$isTrivial = false;
    }

    @Overwrite
    public void func_76657_c(int posX, int posY, int posZ, int lightValue) {
        this.field_76685_h = LazyUtil.lazySet(this.field_76685_h, posX, posY, posZ, lightValue);
        if (this.field_76685_h != null) {
            this.lumi$isDirty = true;
        }
    }

    @Overwrite
    public void func_76677_d(int posX, int posY, int posZ, int lightValue) {
        this.field_76679_g = LazyUtil.lazySet(this.field_76679_g, posX, posY, posZ, lightValue);
        if (this.field_76685_h != null) {
            this.lumi$isDirty = true;
        }
    }

    @Overwrite
    public void func_76659_c(NibbleArray blockLightArray) {
        this.field_76679_g = blockLightArray;
        this.lumi$isDirty = true;
    }

    @Overwrite
    public void func_76666_d(NibbleArray skyLightArray) {
        this.field_76685_h = skyLightArray;
        this.lumi$isDirty = true;
    }

    @Overwrite
    public boolean func_76663_a() {
        if (this.field_76682_b != 0) {
            return false;
        }
        if (this.lumi$isDirty) {
            boolean blockLightEmpty = ArrayHelper.isEmpty(this.field_76679_g);
            boolean skyLightEmpty = ArrayHelper.isEmpty(this.field_76685_h);
            this.lumi$isTrivial = blockLightEmpty && skyLightEmpty;
            this.lumi$isDirty = false;
        }
        return this.lumi$isTrivial;
    }

    @Override
    public void lumi$setDirty(boolean state) {
        this.lumi$isDirty = state;
    }
}

