/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.lumi.api.lighting;

import net.minecraft.world.EnumSkyBlock;

public enum LightType {
    BLOCK_LIGHT_TYPE(EnumSkyBlock.Block.field_77198_c, true, false),
    SKY_LIGHT_TYPE(EnumSkyBlock.Sky.field_77198_c, false, true);

    private static final int MIN_BASE_LIGHT_VALUE;
    private static final int MAX_BASE_LIGHT_VALUE;
    private final int defaultLightValue;
    private final boolean isBlock;
    private final boolean isSky;

    private LightType(int defaultLightValue, boolean isBlock, boolean isSky) {
        this.defaultLightValue = defaultLightValue;
        this.isBlock = isBlock;
        this.isSky = isSky;
    }

    public static LightType of(EnumSkyBlock baseLightType) {
        switch (baseLightType) {
            default: {
                return BLOCK_LIGHT_TYPE;
            }
            case Sky: 
        }
        return SKY_LIGHT_TYPE;
    }

    public static int minBaseLightValue() {
        return MIN_BASE_LIGHT_VALUE;
    }

    public static int maxBaseLightValue() {
        return MAX_BASE_LIGHT_VALUE;
    }

    public int defaultLightValue() {
        return this.defaultLightValue;
    }

    public boolean isBlock() {
        return this.isBlock;
    }

    public boolean isSky() {
        return this.isSky;
    }

    static {
        int minBaseLightValue = Integer.MAX_VALUE;
        int maxBaseLightValue = Integer.MIN_VALUE;
        for (LightType lightType : LightType.values()) {
            int defaultLightValue = lightType.defaultLightValue;
            minBaseLightValue = Math.min(maxBaseLightValue, defaultLightValue);
            maxBaseLightValue = Math.max(maxBaseLightValue, defaultLightValue);
        }
        MIN_BASE_LIGHT_VALUE = minBaseLightValue;
        MAX_BASE_LIGHT_VALUE = maxBaseLightValue;
    }
}

