/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.mcpatcher.internal.modules.overlay;

import com.falsepattern.mcpatcher.internal.modules.overlay.ResourceGenerator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public class OverlayResourceManager
implements IResourceManager {
    private final IResourceManager backing;
    @Nullable
    private final Map<ResourceLocation, ResourceGenerator> overlayRes;
    private final Map<ResourceLocation, IResource> resolvedOverlayRes = new HashMap<ResourceLocation, IResource>();

    public Set<String> func_135055_a() {
        return this.backing.func_135055_a();
    }

    private IResource getResourceOverlay(ResourceLocation location) throws IOException {
        if (this.overlayRes == null) {
            return null;
        }
        IResource res = this.resolvedOverlayRes.get(location);
        if (res != null) {
            return res;
        }
        ResourceGenerator gen = this.overlayRes.get(location);
        if (gen == null) {
            return null;
        }
        IResource genRes = gen.gen(this);
        this.resolvedOverlayRes.put(location, genRes);
        this.overlayRes.remove(location);
        return genRes;
    }

    public IResource func_110536_a(ResourceLocation location) throws IOException {
        IResource res = this.getResourceOverlay(location);
        return res != null ? res : this.backing.func_110536_a(location);
    }

    public List<IResource> func_135056_b(ResourceLocation location) throws IOException {
        ArrayList<IResource> out = new ArrayList<IResource>();
        IResource res = this.getResourceOverlay(location);
        if (res != null) {
            out.add(res);
        }
        out.addAll(this.backing.func_135056_b(location));
        return out;
    }

    @Generated
    public OverlayResourceManager(IResourceManager backing, @Nullable Map<ResourceLocation, ResourceGenerator> overlayRes) {
        this.backing = backing;
        this.overlayRes = overlayRes;
    }
}

