/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.mcpatcher.internal.modules.mob;

import com.falsepattern.mcpatcher.internal.modules.common.CommonParser;
import com.falsepattern.mcpatcher.internal.modules.common.IntRange;
import com.falsepattern.mcpatcher.internal.modules.common.MCPMath;
import com.falsepattern.mcpatcher.internal.modules.common.ResourceScanner;
import com.falsepattern.mcpatcher.internal.modules.common.WeightedRandom;
import com.falsepattern.mcpatcher.internal.modules.mob.MobEngine;
import com.falsepattern.mcpatcher.internal.modules.mob.TrackedEntity;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import it.unimi.dsi.fastutil.objects.ObjectLists;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.io.IOException;
import java.util.Comparator;
import java.util.List;
import java.util.Properties;
import lombok.Generated;
import net.minecraft.client.resources.IResourcePack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.BiomeGenBase;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MobInfo {
    private static final String ENTITY_PATH_PREFIX = "textures/entity/";
    private static final String MCPATCHER_MOB_PATH_PREFIX = "mcpatcher/mob/";
    private static final String[] PROP_ALIASES = new String[]{"", "_eyes", "_overlay", "_tame", "_angry", "_collar", "_fur", "_invulnerable", "_shooting"};
    @NotNull
    private final String name;
    @NotNull
    private final @NotNull ResourceLocation @NotNull [] textures;
    @Nullable
    private final WeightedRandom weights;
    @Nullable
    private final IntRange.List heights;
    @Nullable
    private final ObjectSet<BiomeGenBase> biomes;

    private static int getRandom(int x, int y, int z) {
        int rand = MCPMath.intHash(x);
        rand = MCPMath.intHash(rand + z);
        rand = MCPMath.intHash(rand + y);
        return rand;
    }

    public static @Nullable ObjectList<@NotNull MobInfo> getInfoFor(@NotNull ResourceLocation resource) {
        String domain = resource.func_110624_b();
        if (!"minecraft".equals(domain)) {
            return null;
        }
        MobEngine.LOG.debug("Loading resources for: {}", new Object[]{resource});
        String path = resource.func_110623_a();
        if (path == null || !path.startsWith(ENTITY_PATH_PREFIX)) {
            return null;
        }
        String subPath = path.substring(ENTITY_PATH_PREFIX.length());
        if (subPath.endsWith(".png")) {
            subPath = subPath.substring(0, subPath.length() - 4);
        }
        String prefix = MCPATCHER_MOB_PATH_PREFIX + subPath;
        List<IResourcePack> packs = ResourceScanner.resourcePacks();
        for (IResourcePack pack : packs) {
            MobInfo info;
            if (pack == null) continue;
            boolean hasBaseTexture = pack.func_110589_b(resource);
            ObjectList<MobInfo> result = null;
            for (String alias : PROP_ALIASES) {
                String aliasedPrefix = prefix.substring(0, prefix.length() - alias.length());
                ResourceLocation propFile = new ResourceLocation(aliasedPrefix + ".properties");
                if (!pack.func_110589_b(propFile)) continue;
                Properties properties = new Properties();
                try {
                    MobEngine.LOG.debug("From prop file: {}", new Object[]{propFile});
                    properties.load(pack.func_110590_a(propFile));
                }
                catch (IOException e) {
                    CommonParser.LOG.warn("Failed to parse {}", new Object[]{propFile.toString()});
                    CommonParser.LOG.warn("Stacktrace:", (Throwable)e);
                }
                result = MobInfo.fromProperties(properties, resource, prefix);
            }
            if (result == null && (info = MobInfo.fromTextures(resource, pack, prefix)) != null) {
                result = ObjectLists.singleton((Object)info);
            }
            if (result != null) {
                return result;
            }
            if (!hasBaseTexture) continue;
            return null;
        }
        return null;
    }

    @NotNull
    private static @NotNull ObjectList<@NotNull MobInfo> fromProperties(@NotNull Properties props, @NotNull ResourceLocation resource, @NotNull String prefix) {
        IntList skins;
        String baseName = StringUtils.substringAfterLast((String)prefix, (String)"/") + ".";
        ObjectArrayList result = new ObjectArrayList();
        for (int i = 1; i < Integer.MAX_VALUE && (skins = CommonParser.parseInts(props.getProperty("skins." + i), 0, 65535)) != null; ++i) {
            IntList weightInts = CommonParser.parseInts(props.getProperty("weights." + i), 0, 65535);
            ObjectList<BiomeGenBase> biomesList = CommonParser.parseBiomes(props.getProperty("biomes." + i));
            IntRange.List heights = CommonParser.parseIntRanges(props.getProperty("heights." + i));
            if (heights == null) {
                int minHeight = CommonParser.parseInt(props.getProperty("minHeight." + i), Integer.MIN_VALUE);
                int maxHeight = CommonParser.parseInt(props.getProperty("maxHeight." + i), Integer.MAX_VALUE);
                if (minHeight != Integer.MIN_VALUE || maxHeight != Integer.MAX_VALUE) {
                    heights = new IntRange.List();
                    heights.add(new IntRange(minHeight, maxHeight));
                }
            }
            WeightedRandom weights = weightInts == null ? null : new WeightedRandom(weightInts, skins.size() + 1);
            ObjectOpenHashSet biomes = biomesList == null ? null : new ObjectOpenHashSet(biomesList);
            ObjectArrayList skinsList = new ObjectArrayList();
            IntIterator iter = skins.intIterator();
            while (iter.hasNext()) {
                int j = iter.nextInt();
                ResourceLocation replacementResource = new ResourceLocation(prefix + j + ".png");
                if (ResourceScanner.hasResource(replacementResource)) {
                    skinsList.add((Object)replacementResource);
                    MobEngine.LOG.debug("Added custom texture: {}", new Object[]{replacementResource});
                    continue;
                }
                if (j == 1) {
                    skinsList.add((Object)resource);
                    MobEngine.LOG.debug("Added default texture: {}", new Object[]{resource});
                    continue;
                }
                MobEngine.LOG.warn("Missing custom texture: {}", new Object[]{replacementResource});
            }
            result.add((Object)new MobInfo(baseName + i, (ResourceLocation[])skinsList.toArray((Object[])new ResourceLocation[0]), weights, heights, (ObjectSet<BiomeGenBase>)biomes));
        }
        result.add((Object)new MobInfo(baseName + 0, new ResourceLocation[]{resource}, null, null, null));
        return result;
    }

    @Nullable
    private static MobInfo fromTextures(@NotNull ResourceLocation resource, @NotNull IResourcePack pack, @NotNull String prefix) {
        ObjectList<String> names = ResourceScanner.collectFiles(pack, prefix, ".png", true);
        if (names.isEmpty()) {
            return null;
        }
        MobEngine.LOG.debug("From path directly");
        names.sort(Comparator.naturalOrder());
        ObjectArrayList res = new ObjectArrayList();
        res.add((Object)resource);
        MobEngine.LOG.debug("Added default texture: {}", new Object[]{resource});
        for (String name : names) {
            ResourceLocation replacementResource = new ResourceLocation(name);
            if (ResourceScanner.hasResource(replacementResource)) {
                res.add((Object)replacementResource);
                MobEngine.LOG.debug("Added custom texture: {}", new Object[]{replacementResource});
                continue;
            }
            MobEngine.LOG.warn("Missing custom texture: {}", new Object[]{replacementResource});
        }
        String name = StringUtils.substringAfterLast((String)prefix, (String)"/") + ".0";
        return new MobInfo(name, (ResourceLocation[])res.toArray((Object[])new ResourceLocation[0]), null, null, null);
    }

    public ResourceLocation getTextureFor(TrackedEntity entity) {
        int rand = MobInfo.getRandom(entity.mcp$initialX(), entity.mcp$initialY(), entity.mcp$initialZ());
        int index = this.weights == null ? rand % this.textures.length : this.weights.getIndex(rand) % this.textures.length;
        return this.textures[index];
    }

    public boolean matches(TrackedEntity entity) {
        return !(this.heights != null && !this.heights.isInRange(entity.mcp$initialY()) || this.biomes != null && !this.biomes.contains((Object)entity.mcp$initialBiome()));
    }

    @Generated
    private MobInfo(@NotNull String name, @NotNull @NotNull ResourceLocation @NotNull [] textures, @Nullable WeightedRandom weights, @Nullable IntRange.List heights, @Nullable ObjectSet<BiomeGenBase> biomes) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (textures == null) {
            throw new NullPointerException("textures is marked non-null but is null");
        }
        this.name = name;
        this.textures = textures;
        this.weights = weights;
        this.heights = heights;
        this.biomes = biomes;
    }
}

