/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.mcpatcher.internal.modules.mob;

import com.falsepattern.mcpatcher.internal.modules.mob.MobInfo;
import com.falsepattern.mcpatcher.internal.modules.mob.TrackedEntity;
import it.unimi.dsi.fastutil.Stack;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class MobEngine {
    static final Logger LOG = LogManager.getLogger((String)"Right Proper MCPatcher Mob");
    private static final Object2ObjectMap<ResourceLocation, ObjectList<MobInfo>> cache = new Object2ObjectOpenHashMap();
    private static final ObjectSet<ResourceLocation> negativeCache = new ObjectOpenHashSet();
    private static final Stack<@Nullable TrackedEntity> entityStack = new ObjectArrayList();
    private static boolean isActive = false;
    @Nullable
    private static TrackedEntity currentEntity;

    public static void reloadResources() {
        LOG.debug("Reloading Resources");
        while (!entityStack.isEmpty()) {
            entityStack.pop();
        }
        isActive = false;
        currentEntity = null;
        negativeCache.clear();
        cache.clear();
    }

    public static ResourceLocation getTexture(ResourceLocation original) {
        assert (isActive) : "Must be active";
        assert (currentEntity != null) : "Must have entity";
        if (negativeCache.contains((Object)original)) {
            return original;
        }
        ObjectList infos = (ObjectList)cache.computeIfAbsent((Object)original, MobInfo::getInfoFor);
        if (infos == null) {
            negativeCache.add((Object)original);
            return original;
        }
        for (MobInfo info : infos) {
            if (!info.matches(currentEntity)) continue;
            return info.getTextureFor(currentEntity);
        }
        return original;
    }

    public static boolean isActive() {
        return isActive;
    }

    public static void pushRenderingEntities() {
        if (isActive) {
            entityStack.push((Object)currentEntity);
        } else {
            isActive = true;
        }
        currentEntity = null;
    }

    public static void nextEntity(Entity entity) {
        assert (isActive) : "Must be active";
        if (entity instanceof TrackedEntity) {
            currentEntity = (TrackedEntity)entity;
        }
    }

    public static void popRenderingEntities() {
        if (entityStack.isEmpty()) {
            isActive = false;
            currentEntity = null;
        } else {
            currentEntity = (TrackedEntity)entityStack.pop();
        }
    }
}

