/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.mcpatcher.internal.modules.ctm;

import com.falsepattern.mcpatcher.internal.Share;
import com.falsepattern.mcpatcher.internal.config.ModuleConfig;
import com.falsepattern.mcpatcher.internal.modules.ctm.CTMEngine;
import com.falsepattern.mcpatcher.internal.modules.ctm.Side;
import cpw.mods.fml.common.Loader;
import ganymedes01.etfuturum.configuration.configs.ConfigMixins;
import net.minecraft.block.Block;
import net.minecraft.block.BlockPane;
import net.minecraft.block.BlockStainedGlassPane;
import net.minecraft.client.renderer.EntityRenderer;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;

public class PaneRenderHelper {
    private static final double PANE_THICKNESS_HALF = 0.0625;
    private static final double PANE_BELOW = 0.4375;
    private static final double PANE_ABOVE = 0.5625;
    private static final double PANE_BELOW_UV = 7.0;
    private static final double PANE_ABOVE_UV = 9.0;
    private static final int MASK_NONE = 0;
    private static final int MASK_Z_POS = 1;
    private static final int MASK_Z_NEG = 2;
    private static final int MASK_Z = 3;
    private static final int MASK_X_POS = 4;
    private static final int MASK_X_NEG = 8;
    private static final int MASK_X = 12;
    private static final boolean thinPanes;
    private final SideIconData xNegData = new SideIconData();
    private final SideIconData xPosData = new SideIconData();
    private final SideIconData zNegData = new SideIconData();
    private final SideIconData zPosData = new SideIconData();
    private final TopIconData topData = new TopIconData();
    private boolean edgeYPos;
    private boolean edgeYNeg;
    private int yPosMask;
    private int yNegMask;
    private double minX;
    private double maxX;
    private double minZ;
    private double maxZ;
    private double belowX;
    private double aboveX;
    private double belowZ;
    private double aboveZ;
    private double yMax;
    private double yMin;
    private Tessellator tess;

    private static int getMask(IBlockAccess blockAccess, Block block, int x, int y, int z, boolean aux) {
        boolean connectXNeg = ((BlockPane)block).func_150098_a(blockAccess.func_147439_a(x - 1, y, z));
        boolean connectXPos = ((BlockPane)block).func_150098_a(blockAccess.func_147439_a(x + 1, y, z));
        boolean connectZNeg = ((BlockPane)block).func_150098_a(blockAccess.func_147439_a(x, y, z - 1));
        boolean connectZPos = ((BlockPane)block).func_150098_a(blockAccess.func_147439_a(x, y, z + 1));
        int mask = (connectXNeg ? 8 : 0) | (connectXPos ? 4 : 0) | (connectZNeg ? 2 : 0) | (connectZPos ? 1 : 0);
        if (aux && mask == 0 && !thinPanes) {
            return 15;
        }
        return mask;
    }

    private void update(RenderBlocks rb, Block block, int x, int y, int z) {
        boolean edgeYNeg;
        boolean edgeYPos;
        this.tess = Tessellator.field_78398_a;
        IBlockAccess blockAccess = rb.field_147845_a;
        int meta = blockAccess.func_72805_g(x, y, z);
        boolean bl = edgeYPos = blockAccess.func_147439_a(x, y + 1, z) != block || blockAccess.func_72805_g(x, y + 1, z) != meta;
        if (!edgeYPos) {
            this.yPosMask = PaneRenderHelper.getMask(blockAccess, block, x, y + 1, z, true);
        }
        boolean bl2 = edgeYNeg = blockAccess.func_147439_a(x, y - 1, z) != block || blockAccess.func_72805_g(x, y - 1, z) != meta;
        if (!edgeYNeg) {
            this.yNegMask = PaneRenderHelper.getMask(blockAccess, block, x, y - 1, z, true);
        }
        this.edgeYPos = edgeYPos;
        this.edgeYNeg = edgeYNeg;
        this.minX = x;
        this.maxX = x + 1;
        this.minZ = z;
        this.maxZ = z + 1;
        this.belowX = (double)x + 0.4375;
        this.aboveX = (double)x + 0.5625;
        this.belowZ = (double)z + 0.4375;
        this.aboveZ = (double)z + 0.5625;
        this.yMax = edgeYPos ? (double)y + 0.999 : (double)(y + 1);
        this.yMin = edgeYNeg ? (double)y + 0.001 : (double)y;
        this.updateTextures(rb, blockAccess, block, meta, x, y, z);
    }

    private void updateTextures(RenderBlocks rb, IBlockAccess blockAccess, Block block, int meta, int x, int y, int z) {
        IIcon topIcon;
        IIcon xNegIcon;
        IIcon xPosIcon;
        IIcon zNegIcon;
        IIcon zPosIcon;
        boolean isStained = block instanceof BlockStainedGlassPane;
        if (rb.func_147744_b()) {
            assert (rb.field_147840_d != null);
            zNegIcon = zPosIcon = rb.field_147840_d;
            xPosIcon = zPosIcon;
            xNegIcon = zPosIcon;
            topIcon = rb.field_147840_d;
        } else {
            zNegIcon = zPosIcon = rb.func_147787_a(block, 0, meta);
            xPosIcon = zPosIcon;
            xNegIcon = zPosIcon;
            IIcon iIcon = topIcon = isStained ? ((BlockStainedGlassPane)block).func_150104_b(meta) : ((BlockPane)block).func_150097_e();
        }
        if (ModuleConfig.connectedTextures && rb.field_147840_d == null) {
            xNegIcon = CTMEngine.getCTMIconMultiPass(blockAccess, block, x, y, z, Side.XNeg, xNegIcon);
            xPosIcon = CTMEngine.getCTMIconMultiPass(blockAccess, block, x, y, z, Side.XPos, xNegIcon);
            zNegIcon = CTMEngine.getCTMIconMultiPass(blockAccess, block, x, y, z, Side.ZNeg, zPosIcon);
            zPosIcon = CTMEngine.getCTMIconMultiPass(blockAccess, block, x, y, z, Side.ZPos, zPosIcon);
        }
        this.xNegData.update(xNegIcon, false);
        this.xPosData.update(xPosIcon, true);
        this.zNegData.update(zNegIcon, true);
        this.zPosData.update(zPosIcon, false);
        this.topData.update(topIcon);
    }

    public void renderGlassPane(RenderBlocks rb, Block block, int x, int y, int z) {
        this.update(rb, block, x, y, z);
        IBlockAccess blockAccess = rb.field_147845_a;
        this.tess.func_78380_c(block.func_149677_c(blockAccess, x, y, z));
        int var7 = block.func_149720_d(blockAccess, x, y, z);
        float red = (float)(var7 >> 16 & 0xFF) / 255.0f;
        float green = (float)(var7 >> 8 & 0xFF) / 255.0f;
        float blue = (float)(var7 & 0xFF) / 255.0f;
        if (EntityRenderer.field_78517_a) {
            float aR = (red * 30.0f + green * 59.0f + blue * 11.0f) / 100.0f;
            float aG = (red * 30.0f + green * 70.0f) / 100.0f;
            float aB = (red * 30.0f + blue * 70.0f) / 100.0f;
            red = aR;
            green = aG;
            blue = aB;
        }
        this.tess.func_78386_a(red, green, blue);
        int mask = PaneRenderHelper.getMask(blockAccess, block, x, y, z, false);
        switch (mask) {
            case 0: {
                this.renderUnconnected();
                break;
            }
            case 1: {
                this.renderConnectZPos();
                break;
            }
            case 2: {
                this.renderConnectZNeg();
                break;
            }
            case 3: {
                this.renderConnectZ();
                break;
            }
            case 4: {
                this.renderConnectXPos();
                break;
            }
            case 5: {
                this.renderConnectXPosZPos();
                break;
            }
            case 6: {
                this.renderConnectXPosZNeg();
                break;
            }
            case 7: {
                this.renderConnectXPosZ();
                break;
            }
            case 8: {
                this.renderConnectXNeg();
                break;
            }
            case 9: {
                this.renderConnectXNegZPos();
                break;
            }
            case 10: {
                this.renderConnectXNegZNeg();
                break;
            }
            case 11: {
                this.renderConnectXNegZ();
                break;
            }
            case 12: {
                this.renderConnectX();
                break;
            }
            case 13: {
                this.renderConnectXZPos();
                break;
            }
            case 14: {
                this.renderConnectXZNeg();
                break;
            }
            case 15: {
                this.renderConnectXZ();
            }
        }
    }

    private void renderUnconnected() {
        if (thinPanes) {
            this.renderXNegBelowAbove();
            this.renderXPosBelowAbove();
            this.renderZNegBelowAbove();
            this.renderZPosBelowAbove();
            this.renderYCentered();
        } else {
            this.renderXNegBelowAbove(this.minX);
            this.renderXPosBelowAbove(this.maxX);
            this.renderZNegBelowAbove(this.minZ);
            this.renderZPosBelowAbove(this.maxZ);
            this.renderConnectXZ();
        }
    }

    private void renderConnectZPos() {
        this.renderXNegBelowMax();
        this.renderXPosBelowMax();
        this.renderZNegBelowAbove();
        this.renderYZBelowMax();
    }

    private void renderConnectZNeg() {
        this.renderXNegMinAbove();
        this.renderXPosMinAbove();
        this.renderZPosBelowAbove();
        this.renderYZMinAbove();
    }

    private void renderConnectZ() {
        this.renderXNegMinMax();
        this.renderXPosMinMax();
        this.renderYZMinMax();
    }

    private void renderConnectXPos() {
        this.renderZNegBelowMax();
        this.renderZPosBelowMax();
        this.renderXNegBelowAbove();
        this.renderYXBelowMax();
    }

    private void renderConnectXNeg() {
        this.renderZNegMinAbove();
        this.renderZPosMinAbove();
        this.renderXPosBelowAbove();
        this.renderYXMinAbove();
    }

    private void renderConnectX() {
        this.renderZNegMinMax();
        this.renderZPosMinMax();
        this.renderYXMinMax();
    }

    private void renderConnectXNegZNeg() {
        this.renderXNegMinBelow();
        this.renderXPosMinAbove();
        this.renderZNegMinBelow();
        this.renderZPosMinAbove();
        this.renderYXMinBelow();
        this.renderYZMinAbove();
    }

    private void renderConnectXNegZPos() {
        this.renderXNegAboveMax();
        this.renderXPosBelowMax();
        this.renderZNegMinAbove();
        this.renderZPosMinBelow();
        this.renderYXMinBelow();
        this.renderYZBelowMax();
    }

    private void renderConnectXPosZNeg() {
        this.renderXNegMinAbove();
        this.renderXPosMinBelow();
        this.renderZNegAboveMax();
        this.renderZPosBelowMax();
        this.renderYXAboveMax();
        this.renderYZMinAbove();
    }

    private void renderConnectXPosZPos() {
        this.renderXNegBelowMax();
        this.renderXPosAboveMax();
        this.renderZNegBelowMax();
        this.renderZPosAboveMax();
        this.renderYXAboveMax();
        this.renderYZBelowMax();
    }

    private void renderConnectXZNeg() {
        this.renderXNegMinBelow();
        this.renderXPosMinBelow();
        this.renderZNegMinBelow();
        this.renderZNegAboveMax();
        this.renderZPosMinMax();
        this.renderYXMinMax();
        this.renderYZMinBelow();
    }

    private void renderConnectXZPos() {
        this.renderXNegAboveMax();
        this.renderXPosAboveMax();
        this.renderZNegMinMax();
        this.renderZPosMinBelow();
        this.renderZPosAboveMax();
        this.renderYXMinMax();
        this.renderYZAboveMax();
    }

    private void renderConnectXNegZ() {
        this.renderXNegMinBelow();
        this.renderXNegAboveMax();
        this.renderXPosMinMax();
        this.renderZNegMinBelow();
        this.renderZPosMinBelow();
        this.renderYXMinBelow();
        this.renderYZMinMax();
    }

    private void renderConnectXPosZ() {
        this.renderXNegMinMax();
        this.renderXPosMinBelow();
        this.renderXPosAboveMax();
        this.renderZNegAboveMax();
        this.renderZPosAboveMax();
        this.renderYXAboveMax();
        this.renderYZMinMax();
    }

    private void renderConnectXZ() {
        this.renderXNegMinBelow();
        this.renderXNegAboveMax();
        this.renderXPosMinBelow();
        this.renderXPosAboveMax();
        this.renderZNegMinBelow();
        this.renderZNegAboveMax();
        this.renderZPosMinBelow();
        this.renderZPosAboveMax();
        this.renderYZMinMax();
        this.renderYXMinBelow();
        this.renderYXAboveMax();
    }

    private void renderXNegMinBelow() {
        this.renderXNeg(this.belowX, this.minZ, this.belowZ, this.xNegData.uMin, this.xNegData.uBelow, this.xNegData.vMin, this.xNegData.vMax);
    }

    private void renderXNegMinAbove() {
        this.renderXNeg(this.belowX, this.minZ, this.aboveZ, this.xNegData.uMin, this.xNegData.uAbove, this.xNegData.vMin, this.xNegData.vMax);
    }

    private void renderXNegMinMax() {
        this.renderXNeg(this.belowX, this.minZ, this.maxZ, this.xNegData.uMin, this.xNegData.uMax, this.xNegData.vMin, this.xNegData.vMax);
    }

    private void renderXNegBelowAbove() {
        this.renderXNegBelowAbove(this.belowX);
    }

    private void renderXNegBelowAbove(double x) {
        this.renderXNeg(x, this.belowZ, this.aboveZ, this.xNegData.uBelow, this.xNegData.uAbove, this.xNegData.vMin, this.xNegData.vMax);
    }

    private void renderXNegBelowMax() {
        this.renderXNeg(this.belowX, this.belowZ, this.maxZ, this.xNegData.uBelow, this.xNegData.uMax, this.xNegData.vMin, this.xNegData.vMax);
    }

    private void renderXNegAboveMax() {
        this.renderXNeg(this.belowX, this.aboveZ, this.maxZ, this.xNegData.uAbove, this.xNegData.uMax, this.xNegData.vMin, this.xNegData.vMax);
    }

    private void renderXNeg(double x, double zMin, double zMax, double uMin, double uMax, double vMin, double vMax) {
        this.tess.func_78374_a(x, this.yMax, zMax, uMax, vMin);
        this.tess.func_78374_a(x, this.yMax, zMin, uMin, vMin);
        this.tess.func_78374_a(x, this.yMin, zMin, uMin, vMax);
        this.tess.func_78374_a(x, this.yMin, zMax, uMax, vMax);
    }

    private void renderXPosMinBelow() {
        this.renderXPos(this.aboveX, this.minZ, this.belowZ, this.xPosData.uMin, this.xPosData.uBelow, this.xPosData.vMin, this.xPosData.vMax);
    }

    private void renderXPosMinAbove() {
        this.renderXPos(this.aboveX, this.minZ, this.aboveZ, this.xPosData.uMin, this.xPosData.uAbove, this.xPosData.vMin, this.xPosData.vMax);
    }

    private void renderXPosMinMax() {
        this.renderXPos(this.aboveX, this.minZ, this.maxZ, this.xPosData.uMin, this.xPosData.uMax, this.xPosData.vMin, this.xPosData.vMax);
    }

    private void renderXPosBelowAbove() {
        this.renderXPosBelowAbove(this.aboveX);
    }

    private void renderXPosBelowAbove(double x) {
        this.renderXPos(x, this.belowZ, this.aboveZ, this.xPosData.uBelow, this.xPosData.uAbove, this.xPosData.vMin, this.xPosData.vMax);
    }

    private void renderXPosBelowMax() {
        this.renderXPos(this.aboveX, this.belowZ, this.maxZ, this.xPosData.uBelow, this.xPosData.uMax, this.xPosData.vMin, this.xPosData.vMax);
    }

    private void renderXPosAboveMax() {
        this.renderXPos(this.aboveX, this.aboveZ, this.maxZ, this.xPosData.uAbove, this.xPosData.uMax, this.xPosData.vMin, this.xPosData.vMax);
    }

    private void renderXPos(double x, double zMin, double zMax, double uMin, double uMax, double vMin, double vMax) {
        this.tess.func_78374_a(x, this.yMin, zMax, uMax, vMax);
        this.tess.func_78374_a(x, this.yMin, zMin, uMin, vMax);
        this.tess.func_78374_a(x, this.yMax, zMin, uMin, vMin);
        this.tess.func_78374_a(x, this.yMax, zMax, uMax, vMin);
    }

    private void renderZNegMinBelow() {
        this.renderZNeg(this.minX, this.belowX, this.belowZ, this.zNegData.uMin, this.zNegData.uBelow, this.zNegData.vMin, this.zNegData.vMax);
    }

    private void renderZNegMinAbove() {
        this.renderZNeg(this.minX, this.aboveX, this.belowZ, this.zNegData.uMin, this.zNegData.uAbove, this.zNegData.vMin, this.zNegData.vMax);
    }

    private void renderZNegMinMax() {
        this.renderZNeg(this.minX, this.maxX, this.belowZ, this.zNegData.uMin, this.zNegData.uMax, this.zNegData.vMin, this.zNegData.vMax);
    }

    private void renderZNegBelowAbove() {
        this.renderZNegBelowAbove(this.belowZ);
    }

    private void renderZNegBelowAbove(double z) {
        this.renderZNeg(this.belowX, this.aboveX, z, this.zNegData.uBelow, this.zNegData.uAbove, this.zNegData.vMin, this.zNegData.vMax);
    }

    private void renderZNegBelowMax() {
        this.renderZNeg(this.belowX, this.maxX, this.belowZ, this.zNegData.uBelow, this.zNegData.uMax, this.zNegData.vMin, this.zNegData.vMax);
    }

    private void renderZNegAboveMax() {
        this.renderZNeg(this.aboveX, this.maxX, this.belowZ, this.zNegData.uAbove, this.zNegData.uMax, this.zNegData.vMin, this.zNegData.vMax);
    }

    private void renderZNeg(double xMin, double xMax, double z, double uMin, double uMax, double vMin, double vMax) {
        this.tess.func_78374_a(xMin, this.yMax, z, uMin, vMin);
        this.tess.func_78374_a(xMax, this.yMax, z, uMax, vMin);
        this.tess.func_78374_a(xMax, this.yMin, z, uMax, vMax);
        this.tess.func_78374_a(xMin, this.yMin, z, uMin, vMax);
    }

    private void renderZPosMinBelow() {
        this.renderZPos(this.minX, this.belowX, this.aboveZ, this.zPosData.uMin, this.zPosData.uBelow, this.zPosData.vMin, this.zPosData.vMax);
    }

    private void renderZPosMinAbove() {
        this.renderZPos(this.minX, this.aboveX, this.aboveZ, this.zPosData.uMin, this.zPosData.uAbove, this.zPosData.vMin, this.zPosData.vMax);
    }

    private void renderZPosMinMax() {
        this.renderZPos(this.minX, this.maxX, this.aboveZ, this.zPosData.uMin, this.zPosData.uMax, this.zPosData.vMin, this.zPosData.vMax);
    }

    private void renderZPosBelowAbove() {
        this.renderZPosBelowAbove(this.aboveZ);
    }

    private void renderZPosBelowAbove(double z) {
        this.renderZPos(this.belowX, this.aboveX, z, this.zPosData.uBelow, this.zPosData.uAbove, this.zPosData.vMin, this.zPosData.vMax);
    }

    private void renderZPosBelowMax() {
        this.renderZPos(this.belowX, this.maxX, this.aboveZ, this.zPosData.uBelow, this.zPosData.uMax, this.zPosData.vMin, this.zPosData.vMax);
    }

    private void renderZPosAboveMax() {
        this.renderZPos(this.aboveX, this.maxX, this.aboveZ, this.zPosData.uAbove, this.zPosData.uMax, this.zPosData.vMin, this.zPosData.vMax);
    }

    private void renderZPos(double xMin, double xMax, double z, double uMin, double uMax, double vMin, double vMax) {
        this.tess.func_78374_a(xMin, this.yMax, z, uMin, vMin);
        this.tess.func_78374_a(xMin, this.yMin, z, uMin, vMax);
        this.tess.func_78374_a(xMax, this.yMin, z, uMax, vMax);
        this.tess.func_78374_a(xMax, this.yMax, z, uMax, vMin);
    }

    private void renderYZMinBelow() {
        if (this.edgeYNeg || (this.yNegMask & 2) == 0) {
            this.renderYNegZMinBelow();
        }
        if (this.edgeYPos || (this.yPosMask & 2) == 0) {
            this.renderYPosZMinBelow();
        }
    }

    private void renderYZMinAbove() {
        if (this.edgeYNeg) {
            this.renderYNegZMinAbove();
        } else if ((this.yNegMask & 2) == 0) {
            this.renderYNegZMinBelow();
        }
        if (this.edgeYPos) {
            this.renderYPosZMinAbove();
        } else if ((this.yPosMask & 2) == 0) {
            this.renderYPosZMinBelow();
        }
    }

    private void renderYZMinMax() {
        if (this.edgeYNeg) {
            this.renderYNegZMinMax();
        } else {
            if ((this.yNegMask & 2) == 0) {
                this.renderYNegZMinBelow();
            }
            if ((this.yNegMask & 1) == 0) {
                this.renderYNegZAboveMax();
            }
        }
        if (this.edgeYPos) {
            this.renderYPosZMinMax();
        } else {
            if ((this.yPosMask & 2) == 0) {
                this.renderYPosZMinBelow();
            }
            if ((this.yPosMask & 1) == 0) {
                this.renderYPosZAboveMax();
            }
        }
    }

    private void renderYZBelowMax() {
        if (this.edgeYNeg) {
            this.renderYNegZBelowMax();
        } else if ((this.yNegMask & 1) == 0) {
            this.renderYNegZAboveMax();
        }
        if (this.edgeYPos) {
            this.renderYPosZBelowMax();
        } else if ((this.yPosMask & 1) == 0) {
            this.renderYPosZAboveMax();
        }
    }

    private void renderYZAboveMax() {
        if (this.edgeYNeg || (this.yNegMask & 1) == 0) {
            this.renderYNegZAboveMax();
        }
        if (this.edgeYPos || (this.yPosMask & 1) == 0) {
            this.renderYPosZAboveMax();
        }
    }

    private void renderYNegZMinBelow() {
        this.renderYNegZV(this.minZ, this.belowZ, this.topData.vMin, this.topData.vBelow);
    }

    private void renderYNegZMinAbove() {
        this.renderYNegZV(this.minZ, this.aboveZ, this.topData.vMin, this.topData.vAbove);
    }

    private void renderYNegZMinMax() {
        this.renderYNegZV(this.minZ, this.maxZ, this.topData.vMin, this.topData.vMax);
    }

    private void renderYNegZBelowMax() {
        this.renderYNegZV(this.belowZ, this.maxZ, this.topData.vBelow, this.topData.vMax);
    }

    private void renderYNegZAboveMax() {
        this.renderYNegZV(this.aboveZ, this.maxZ, this.topData.vAbove, this.topData.vMax);
    }

    private void renderYNegZV(double zMin, double zMax, double vMin, double vMax) {
        this.tess.func_78374_a(this.belowX, this.yMin, zMax, this.topData.uBelow, vMin);
        this.tess.func_78374_a(this.belowX, this.yMin, zMin, this.topData.uBelow, vMax);
        this.tess.func_78374_a(this.aboveX, this.yMin, zMin, this.topData.uAbove, vMax);
        this.tess.func_78374_a(this.aboveX, this.yMin, zMax, this.topData.uAbove, vMin);
    }

    private void renderYPosZMinBelow() {
        this.renderYPosZV(this.minZ, this.belowZ, this.topData.vMin, this.topData.vBelow);
    }

    private void renderYPosZMinAbove() {
        this.renderYPosZV(this.minZ, this.aboveZ, this.topData.vMin, this.topData.vAbove);
    }

    private void renderYPosZMinMax() {
        this.renderYPosZV(this.minZ, this.maxZ, this.topData.vMin, this.topData.vMax);
    }

    private void renderYPosZBelowMax() {
        this.renderYPosZV(this.belowZ, this.maxZ, this.topData.vBelow, this.topData.vMax);
    }

    private void renderYPosZAboveMax() {
        this.renderYPosZV(this.aboveZ, this.maxZ, this.topData.vAbove, this.topData.vMax);
    }

    private void renderYPosZV(double zMin, double zMax, double vMin, double vMax) {
        this.tess.func_78374_a(this.aboveX, this.yMax, zMax, this.topData.uAbove, vMin);
        this.tess.func_78374_a(this.aboveX, this.yMax, zMin, this.topData.uAbove, vMax);
        this.tess.func_78374_a(this.belowX, this.yMax, zMin, this.topData.uBelow, vMax);
        this.tess.func_78374_a(this.belowX, this.yMax, zMax, this.topData.uBelow, vMin);
    }

    private void renderYXMinBelow() {
        if (this.edgeYNeg || (this.yNegMask & 8) == 0) {
            this.renderYNegXMinBelow();
        }
        if (this.edgeYPos || (this.yPosMask & 8) == 0) {
            this.renderYPosXMinBelow();
        }
    }

    private void renderYXMinAbove() {
        if (this.edgeYNeg) {
            this.renderYNegXMinAbove();
        } else if ((this.yNegMask & 8) == 0) {
            this.renderYNegXMinBelow();
        }
        if (this.edgeYPos) {
            this.renderYPosXMinAbove();
        } else if ((this.yPosMask & 8) == 0) {
            this.renderYPosXMinBelow();
        }
    }

    private void renderYXMinMax() {
        if (this.edgeYNeg) {
            this.renderYNegXMinMax();
        } else {
            if ((this.yNegMask & 8) == 0) {
                this.renderYNegXMinBelow();
            }
            if ((this.yNegMask & 4) == 0) {
                this.renderYNegXAboveMax();
            }
        }
        if (this.edgeYPos) {
            this.renderYPosXMinMax();
        } else {
            if ((this.yPosMask & 8) == 0) {
                this.renderYPosXMinBelow();
            }
            if ((this.yPosMask & 4) == 0) {
                this.renderYPosXAboveMax();
            }
        }
    }

    private void renderYXBelowMax() {
        if (this.edgeYNeg) {
            this.renderYNegXBelowMax();
        } else if ((this.yNegMask & 4) == 0) {
            this.renderYNegXAboveMax();
        }
        if (this.edgeYPos) {
            this.renderYPosXBelowMax();
        } else if ((this.yPosMask & 4) == 0) {
            this.renderYPosXAboveMax();
        }
    }

    private void renderYXAboveMax() {
        if (this.edgeYNeg || (this.yNegMask & 4) == 0) {
            this.renderYNegXAboveMax();
        }
        if (this.edgeYPos || (this.yPosMask & 4) == 0) {
            this.renderYPosXAboveMax();
        }
    }

    private void renderYNegXMinBelow() {
        this.renderYNegXV(this.minX, this.belowX, this.topData.vMin, this.topData.vBelow);
    }

    private void renderYNegXMinAbove() {
        this.renderYNegXV(this.minX, this.aboveX, this.topData.vMin, this.topData.vAbove);
    }

    private void renderYNegXMinMax() {
        this.renderYNegXV(this.minX, this.maxX, this.topData.vMin, this.topData.vMax);
    }

    private void renderYNegXBelowMax() {
        this.renderYNegXV(this.belowX, this.maxX, this.topData.vBelow, this.topData.vMax);
    }

    private void renderYNegXAboveMax() {
        this.renderYNegXV(this.aboveX, this.maxX, this.topData.vAbove, this.topData.vMax);
    }

    private void renderYNegXV(double xMin, double xMax, double vMin, double vMax) {
        this.tess.func_78374_a(xMin, this.yMin, this.aboveZ, this.topData.uBelow, vMin);
        this.tess.func_78374_a(xMin, this.yMin, this.belowZ, this.topData.uAbove, vMin);
        this.tess.func_78374_a(xMax, this.yMin, this.belowZ, this.topData.uAbove, vMax);
        this.tess.func_78374_a(xMax, this.yMin, this.aboveZ, this.topData.uBelow, vMax);
    }

    private void renderYPosXMinBelow() {
        this.renderYPosXV(this.minX, this.belowX, this.topData.vMin, this.topData.vBelow);
    }

    private void renderYPosXMinAbove() {
        this.renderYPosXV(this.minX, this.aboveX, this.topData.vMin, this.topData.vAbove);
    }

    private void renderYPosXMinMax() {
        this.renderYPosXV(this.minX, this.maxX, this.topData.vMin, this.topData.vMax);
    }

    private void renderYPosXBelowMax() {
        this.renderYPosXV(this.belowX, this.maxX, this.topData.vBelow, this.topData.vMax);
    }

    private void renderYPosXAboveMax() {
        this.renderYPosXV(this.aboveX, this.maxX, this.topData.vAbove, this.topData.vMax);
    }

    private void renderYPosXV(double xMin, double xMax, double vMin, double vMax) {
        this.tess.func_78374_a(xMax, this.yMax, this.aboveZ, this.topData.uBelow, vMax);
        this.tess.func_78374_a(xMax, this.yMax, this.belowZ, this.topData.uAbove, vMax);
        this.tess.func_78374_a(xMin, this.yMax, this.belowZ, this.topData.uAbove, vMin);
        this.tess.func_78374_a(xMin, this.yMax, this.aboveZ, this.topData.uBelow, vMin);
    }

    private void renderYCentered() {
        if (this.edgeYNeg) {
            this.renderYNegCentered();
        }
        if (this.edgeYPos) {
            this.renderYPosCentered();
        }
    }

    private void renderYPosCentered() {
        this.tess.func_78374_a(this.aboveX, this.yMax, this.aboveZ, this.topData.uAbove, this.topData.vBelow);
        this.tess.func_78374_a(this.aboveX, this.yMax, this.belowZ, this.topData.uAbove, this.topData.vAbove);
        this.tess.func_78374_a(this.belowX, this.yMax, this.belowZ, this.topData.uBelow, this.topData.vAbove);
        this.tess.func_78374_a(this.belowX, this.yMax, this.aboveZ, this.topData.uBelow, this.topData.vBelow);
    }

    private void renderYNegCentered() {
        this.tess.func_78374_a(this.belowX, this.yMin, this.aboveZ, this.topData.uBelow, this.topData.vBelow);
        this.tess.func_78374_a(this.belowX, this.yMin, this.belowZ, this.topData.uBelow, this.topData.vAbove);
        this.tess.func_78374_a(this.aboveX, this.yMin, this.belowZ, this.topData.uAbove, this.topData.vAbove);
        this.tess.func_78374_a(this.aboveX, this.yMin, this.aboveZ, this.topData.uAbove, this.topData.vBelow);
    }

    static {
        boolean isThinPanes = false;
        try {
            if (Loader.isModLoaded((String)"etfuturum")) {
                isThinPanes = EtFuturumCompat.thinPanes();
            }
        }
        catch (Throwable e) {
            Share.log.error("Failed to check Et Futurum Requiem thin panes", e);
        }
        thinPanes = isThinPanes;
    }

    private static class EtFuturumCompat {
        private EtFuturumCompat() {
        }

        public static boolean thinPanes() {
            return ConfigMixins.thinPanes;
        }
    }

    private static class TopIconData {
        public double uBelow;
        public double uAbove;
        public double vMin;
        public double vMax;
        public double vBelow;
        public double vAbove;
        public IIcon icon;

        private TopIconData() {
        }

        public void update(IIcon icon) {
            this.uBelow = icon.func_94214_a(7.0);
            this.uAbove = icon.func_94214_a(9.0);
            this.vMin = icon.func_94206_g();
            this.vMax = icon.func_94210_h();
            this.vBelow = icon.func_94207_b(7.0);
            this.vAbove = icon.func_94207_b(9.0);
            this.icon = icon;
        }
    }

    private static class SideIconData {
        public double uMin;
        public double uMax;
        public double uBelow;
        public double uAbove;
        public double vMin;
        public double vMax;
        public IIcon icon;

        private SideIconData() {
        }

        public void update(IIcon icon, boolean negU) {
            this.uMin = negU ? (double)icon.func_94212_f() : (double)icon.func_94209_e();
            this.uMax = negU ? (double)icon.func_94209_e() : (double)icon.func_94212_f();
            this.uBelow = negU ? (double)icon.func_94214_a(9.0) : (double)icon.func_94214_a(7.0);
            this.uAbove = negU ? (double)icon.func_94214_a(7.0) : (double)icon.func_94214_a(9.0);
            this.vMin = icon.func_94206_g();
            this.vMax = icon.func_94210_h();
            this.icon = icon;
        }
    }
}

