/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.mcpatcher.internal.modules.ctm;

import com.falsepattern.mcpatcher.internal.modules.common.CommonParser;
import com.falsepattern.mcpatcher.internal.modules.ctm.Connect;
import com.falsepattern.mcpatcher.internal.modules.ctm.Method;
import com.falsepattern.mcpatcher.internal.modules.ctm.Side;
import com.falsepattern.mcpatcher.internal.modules.ctm.Symmetry;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import net.minecraft.block.Block;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CTMParser {
    private CTMParser() {
        throw new AssertionError((Object)"Utility class");
    }

    @Contract(value="!null, _ -> !null")
    @Nullable
    public static ObjectList<String> parseMatchTiles(@Nullable String str, @NotNull String basePath) {
        if (str == null) {
            return null;
        }
        ObjectArrayList names = new ObjectArrayList((Object[])StringUtils.split((String)str));
        int len = names.size();
        for (int i = 0; i < len; ++i) {
            String iconName = (String)names.get(i);
            if (iconName.endsWith(".png")) {
                iconName = iconName.substring(0, iconName.length() - 4);
            }
            iconName = CTMParser.fixResourcePath(iconName, basePath);
            names.set(i, (Object)iconName);
        }
        return names;
    }

    @NotNull
    public static String parseName(@NotNull String path) {
        int pos2;
        String str = path;
        int pos = path.lastIndexOf(47);
        if (pos >= 0) {
            str = path.substring(pos + 1);
        }
        if ((pos2 = str.lastIndexOf(46)) >= 0) {
            str = str.substring(0, pos2);
        }
        return str;
    }

    @NotNull
    public static String parseBasePath(@NotNull String path) {
        int pos = path.lastIndexOf(47);
        return pos < 0 ? "" : path.substring(0, pos);
    }

    @Contract(value="!null, _ -> !null")
    @Nullable
    public static ObjectList<String> parseTileNames(@Nullable String str, @NotNull String basePath) {
        String[] iconStrs;
        if (str == null) {
            return null;
        }
        ObjectArrayList list = new ObjectArrayList();
        for (String iconStr : iconStrs = StringUtils.split((String)str, (String)" ,")) {
            String[] subStrs;
            if (iconStr.contains("-") && (subStrs = StringUtils.split((String)iconStr, (String)"-")).length == 2) {
                int min = CommonParser.parseInt(subStrs[0], -1);
                int max = CommonParser.parseInt(subStrs[1], -1);
                if (min >= 0 && max >= 0) {
                    if (min > max) {
                        CommonParser.LOG.warn("Invalid interval: {}, when parsing: {}", new Object[]{iconStr, str});
                        continue;
                    }
                    for (int n = min; n <= max; ++n) {
                        list.add((Object)String.valueOf(n));
                    }
                    continue;
                }
            }
            list.add((Object)iconStr);
        }
        int len = list.size();
        for (int i = 0; i < len; ++i) {
            String iconName = (String)list.get(i);
            if (!((iconName = CTMParser.fixResourcePath(iconName, basePath)).startsWith(basePath) || iconName.startsWith("textures/") || iconName.startsWith("mcpatcher/"))) {
                iconName = basePath + "/" + iconName;
            }
            if (iconName.endsWith(".png")) {
                iconName = iconName.substring(0, iconName.length() - 4);
            }
            String pathBlocks = "textures/blocks/";
            if (iconName.startsWith("textures/blocks/")) {
                iconName = iconName.substring("textures/blocks/".length());
            }
            if (iconName.startsWith("/")) {
                iconName = iconName.substring(1);
            }
            list.set(i, (Object)iconName);
        }
        return list;
    }

    @NotNull
    public static Symmetry parseSymmetry(@Nullable String str) {
        if (str == null) {
            return Symmetry.None;
        }
        if ((str = str.trim()).equals("opposite")) {
            return Symmetry.Opposite;
        }
        if (str.equals("all")) {
            return Symmetry.All;
        }
        CommonParser.LOG.warn("Unknown symmetry: {}", new Object[]{str});
        return Symmetry.None;
    }

    public static int parseFacesMask(@Nullable String str) {
        if (str == null) {
            return Side.MASK_ALL;
        }
        String[] faceStrs = StringUtils.split((String)str, (String)" ,");
        int facesMask = 0;
        for (String faceStr : faceStrs) {
            facesMask |= CTMParser.parseFaceMask(faceStr);
        }
        return facesMask;
    }

    public static int parseFaceMask(@NotNull String str) {
        switch (str = str.toLowerCase()) {
            case "bottom": {
                return Side.Bottom.mask;
            }
            case "top": {
                return Side.Top.mask;
            }
            case "north": {
                return Side.North.mask;
            }
            case "south": {
                return Side.South.mask;
            }
            case "east": {
                return Side.East.mask;
            }
            case "west": {
                return Side.West.mask;
            }
            case "sides": {
                return Side.MASK_SIDES;
            }
            case "all": {
                return Side.MASK_ALL;
            }
        }
        CommonParser.LOG.warn("Unknown face: {}", new Object[]{str});
        return 128;
    }

    @NotNull
    public static Connect parseConnect(@Nullable String str) {
        if (str == null) {
            return Connect.None;
        }
        switch (str = str.trim()) {
            case "block": {
                return Connect.Block;
            }
            case "tile": {
                return Connect.Tile;
            }
            case "material": {
                return Connect.Material;
            }
        }
        CommonParser.LOG.warn("Unknown connect: {}", new Object[]{str});
        return Connect.Unknown;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public static @Nullable ObjectList<@NotNull Block> parseBlockIds(@Nullable String str) {
        String[] idStrs;
        if (str == null) {
            return null;
        }
        @NotNull ObjectArrayList list = new ObjectArrayList();
        for (String idStr : idStrs = StringUtils.split((String)str, (String)" ,")) {
            if (idStr.contains("-")) {
                String[] subStrs = StringUtils.split((String)idStr, (String)"-");
                if (subStrs.length != 2) {
                    CommonParser.LOG.warn("Invalid interval: {}, when parsing: {}", new Object[]{idStr, str});
                    continue;
                }
                int min = CTMParser.parseBlockId(subStrs[0]);
                int max = CTMParser.parseBlockId(subStrs[1]);
                if (min >= 0 && max >= 0 && min <= max) {
                    for (int n = min; n <= max; ++n) {
                        Block block = Block.func_149729_e((int)n);
                        if (block == null) continue;
                        list.add((Object)block);
                    }
                    continue;
                }
                CommonParser.LOG.warn("Invalid interval: {}, when parsing: {}", new Object[]{idStr, str});
                continue;
            }
            int val = CTMParser.parseBlockId(idStr);
            if (val < 0) {
                CommonParser.LOG.warn("Invalid block ID: {}, when parsing: {}", new Object[]{idStr, str});
                continue;
            }
            Block block = Block.func_149729_e((int)val);
            if (block == null) continue;
            list.add((Object)block);
        }
        return list;
    }

    public static int parseBlockId(@Nullable String blockStr) {
        int val = CommonParser.parseInt(blockStr, -1);
        if (val >= 0) {
            return val;
        }
        Block block = Block.func_149684_b((String)blockStr);
        return block != null ? Block.func_149682_b((Block)block) : -1;
    }

    @NotNull
    public static Method parseMethod(@Nullable String str) {
        if (str == null) {
            return Method.Ctm;
        }
        switch (str = str.trim()) {
            case "ctm": 
            case "glass": {
                return Method.Ctm;
            }
            case "ctm_compact": {
                return Method.Compact;
            }
            case "horizontal": 
            case "bookshelf": {
                return Method.Horizontal;
            }
            case "vertical": {
                return Method.Vertical;
            }
            case "top": {
                return Method.Top;
            }
            case "random": {
                return Method.Random;
            }
            case "repeat": {
                return Method.Repeat;
            }
            case "fixed": {
                return Method.Fixed;
            }
            case "horizontal+vertical": 
            case "h+v": {
                return Method.HorizontalVertical;
            }
            case "vertical+horizontal": 
            case "v+h": {
                return Method.VerticalHorizontal;
            }
        }
        CommonParser.LOG.warn("Unknown method: {}", new Object[]{str});
        return Method.None;
    }

    @NotNull
    private static String fixResourcePath(@NotNull String path, @NotNull String basePath) {
        String strAssMc = "assets/minecraft/";
        if (path.startsWith(strAssMc)) {
            return path.substring(strAssMc.length());
        }
        if (path.startsWith("./")) {
            path = path.substring(2);
            if (!basePath.endsWith("/")) {
                basePath = basePath + "/";
            }
            return basePath + path;
        }
        if (path.startsWith("/~")) {
            path = path.substring(1);
        }
        String strMcpatcher = "mcpatcher/";
        if (path.startsWith("~/")) {
            path = path.substring(2);
            return strMcpatcher + path;
        }
        return path.startsWith("/") ? strMcpatcher + path.substring(1) : path;
    }
}

