/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.mcpatcher.internal.modules.common;

import com.falsepattern.mcpatcher.internal.modules.common.CommonParser;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import org.jetbrains.annotations.NotNull;

public class WeightedRandom {
    @NotNull
    private final IntList weights;
    @NotNull
    private final IntList sumWeights;
    private final int sumAllWeights;

    public WeightedRandom(@NotNull IntList weights) {
        this(weights, weights.size());
    }

    public WeightedRandom(@NotNull IntList weights, int size) {
        int i;
        weights = new IntArrayList(weights);
        if (size < weights.size()) {
            weights.size(size);
        } else {
            int avg = WeightedRandom.getAverage(weights);
            for (i = weights.size(); i < size; ++i) {
                weights.add(avg);
            }
        }
        this.weights = weights;
        this.sumWeights = new IntArrayList(this.weights.size());
        int sum = 0;
        for (i = 0; i < this.weights.size(); ++i) {
            this.sumWeights.add(sum += this.weights.getInt(i));
        }
        if (sum <= 0) {
            CommonParser.LOG.warn("Invalid sum of all weights: {}", new Object[]{sum});
            sum = 1;
        }
        this.sumAllWeights = sum;
    }

    private static int getAverage(IntList vals) {
        if (vals.isEmpty()) {
            return 0;
        }
        int sum = 0;
        int len = vals.size();
        for (int i = 0; i < len; ++i) {
            int val = vals.getInt(i);
            sum += val;
        }
        return sum / len;
    }

    public int size() {
        return this.weights.size();
    }

    public int getIndex(int rand) {
        int index = 0;
        int randWeight = rand % this.sumAllWeights;
        int len = this.sumWeights.size();
        for (int i = 0; i < len; ++i) {
            if (randWeight >= this.sumWeights.getInt(i)) continue;
            index = i;
            break;
        }
        return index;
    }

    @NotNull
    public WeightedRandom resize(int size) {
        return new WeightedRandom(this.weights, size);
    }
}

