/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.mcpatcher.internal.modules.common;

import com.falsepattern.mcpatcher.internal.modules.common.CommonParser;
import com.google.common.collect.Lists;
import cpw.mods.fml.client.FMLFileResourcePack;
import cpw.mods.fml.client.FMLFolderResourcePack;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import it.unimi.dsi.fastutil.objects.ObjectLists;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.AbstractResourcePack;
import net.minecraft.client.resources.DefaultResourcePack;
import net.minecraft.client.resources.FallbackResourceManager;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourcePack;
import net.minecraft.client.resources.SimpleReloadableResourceManager;
import net.minecraft.util.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ResourceScanner {
    private static final String PREFIX_ASSETS = "assets/minecraft/";

    public static @NotNull List<@Nullable IResourcePack> resourcePacks() {
        FallbackResourceManager manager = (FallbackResourceManager)((SimpleReloadableResourceManager)Minecraft.func_71410_x().func_110442_L()).field_110548_a.get("minecraft");
        return Lists.reverse((List)manager.field_110540_a);
    }

    public static boolean isFromDefaultResourcePack(@NotNull ResourceLocation loc) {
        IResourcePack def = ResourceScanner.definingResourcePack(loc);
        if (def instanceof DefaultResourcePack) {
            return true;
        }
        if (def instanceof FMLFileResourcePack) {
            FMLFileResourcePack fmlDef = (FMLFileResourcePack)def;
            String id = fmlDef.getFMLContainer().getModId();
            return "Forge".equals(id) || "FML".equals(id);
        }
        if (def instanceof FMLFolderResourcePack) {
            FMLFolderResourcePack fmlDef = (FMLFolderResourcePack)def;
            String id = fmlDef.getFMLContainer().getModId();
            return "Forge".equals(id) || "FML".equals(id);
        }
        return false;
    }

    @Nullable
    public static IResourcePack definingResourcePack(@NotNull ResourceLocation loc) {
        for (IResourcePack rp : ResourceScanner.resourcePacks()) {
            if (rp == null || !rp.func_110589_b(loc)) continue;
            return rp;
        }
        return null;
    }

    public static IResource getResource(ResourceLocation location) throws IOException {
        return Minecraft.func_71410_x().func_110442_L().func_110536_a(location);
    }

    public static boolean hasResource(ResourceLocation location) {
        try {
            IResource res = ResourceScanner.getResource(location);
            return res != null;
        }
        catch (IOException ignored) {
            return false;
        }
    }

    @NotNull
    public static @NotNull ObjectList<@NotNull String> collectFiles(@NotNull IResourcePack pack, @Nullable String prefix, @Nullable String suffix, boolean digitsOnly) {
        if (!(pack instanceof AbstractResourcePack)) {
            return ObjectLists.emptyList();
        }
        File tpFile = ((AbstractResourcePack)pack).field_110597_b;
        if (tpFile == null) {
            return ObjectLists.emptyList();
        }
        if (tpFile.isDirectory()) {
            ObjectArrayList res = new ObjectArrayList();
            ResourceScanner.collectFilesFolder(tpFile, "", prefix, suffix, digitsOnly, (ObjectList<String>)res);
            return res;
        }
        if (tpFile.isFile()) {
            ObjectArrayList res = new ObjectArrayList();
            ResourceScanner.collectFilesZIP(tpFile, prefix, suffix, digitsOnly, (ObjectList<String>)res);
            return res;
        }
        return ObjectLists.emptyList();
    }

    private static void collectFilesFolder(@NotNull File tpFile, @NotNull String basePath, @Nullable String prefix, @Nullable String suffix, boolean digitsOnly, @NotNull @NotNull ObjectList<@NotNull String> output) {
        File[] files = tpFile.listFiles();
        if (files == null) {
            return;
        }
        for (File file : files) {
            if (file.isFile()) {
                String name = basePath + file.getName();
                ResourceScanner.addIfMatches(name, prefix, suffix, digitsOnly, output);
                continue;
            }
            if (!file.isDirectory()) continue;
            String dirPath = basePath + file.getName() + "/";
            ResourceScanner.collectFilesFolder(file, dirPath, prefix, suffix, digitsOnly, output);
        }
    }

    private static void collectFilesZIP(@NotNull File tpFile, @Nullable String prefix, @Nullable String suffix, boolean digitsOnly, @NotNull @NotNull ObjectList<@NotNull String> output) {
        try {
            ZipFile zf = new ZipFile(tpFile);
            Enumeration<? extends ZipEntry> en = zf.entries();
            while (en.hasMoreElements()) {
                ZipEntry ze = en.nextElement();
                String name = ze.getName();
                ResourceScanner.addIfMatches(name, prefix, suffix, digitsOnly, output);
            }
            zf.close();
        }
        catch (IOException e) {
            CommonParser.LOG.warn("Error collecting files from zip", (Throwable)e);
        }
    }

    private static void addIfMatches(@NotNull String name, @Nullable String prefix, @Nullable String suffix, boolean digitsOnly, @NotNull @NotNull ObjectList<@NotNull String> output) {
        if (name.startsWith(PREFIX_ASSETS)) {
            name = name.substring(PREFIX_ASSETS.length());
            if ((prefix == null || name.startsWith(prefix)) && (suffix == null || name.endsWith(suffix))) {
                String subStr;
                if (digitsOnly && !(subStr = name.substring(prefix != null ? prefix.length() : 0, suffix != null ? name.length() - suffix.length() : name.length())).matches("^\\d+$")) {
                    return;
                }
                output.add((Object)name);
            }
        }
    }
}

