/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.mcpatcher.internal.modules.cit;

import com.falsepattern.mcpatcher.internal.modules.cit.CITEngine;
import com.falsepattern.mcpatcher.internal.modules.cit.CITPropsSingle;
import com.falsepattern.mcpatcher.internal.modules.common.CollectionUtil;
import com.falsepattern.mcpatcher.internal.modules.common.Identity2ObjectHashMap;
import com.falsepattern.mcpatcher.internal.modules.overlay.ResourceGenerator;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import java.util.Map;
import java.util.Properties;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public final class CITPropsItem
extends CITPropsSingle {
    @Nullable
    private IIcon icon = null;
    private @Unmodifiable @Nullable Object2ObjectMap<IIcon, IIcon> altIcons = null;

    public CITPropsItem(String name, Properties props) {
        super(name, props);
    }

    public IIcon getIcon(IIcon original) {
        IIcon replacement = this.altIcons != null ? (IIcon)this.altIcons.getOrDefault((Object)original, (Object)this.icon) : this.icon;
        if (replacement != null) {
            return replacement;
        }
        return original;
    }

    @Override
    public boolean isValid() {
        if (this.items.isEmpty()) {
            CITEngine.LOG.warn("No valid items defined for: {}", new Object[]{this.name});
            return false;
        }
        if (this.texture == null && this.altTextures.isEmpty()) {
            CITEngine.LOG.warn("No valid textures defined for: {}", new Object[]{this.name});
            return false;
        }
        return true;
    }

    @Override
    public void load(TextureMap textureMap, @Nullable Map<ResourceLocation, ResourceGenerator> overlay) {
        this.icon = this.texture == null ? null : textureMap.func_94245_a(this.texture);
        if (this.altTextures.isEmpty()) {
            this.altIcons = null;
        } else {
            this.altIcons = new Identity2ObjectHashMap();
            for (Map.Entry entry : this.altTextures.entrySet()) {
                String srcName = (String)entry.getKey();
                String dstName = (String)entry.getValue();
                TextureAtlasSprite src = textureMap.getTextureExtry(srcName);
                if (src == null) continue;
                IIcon dst = textureMap.func_94245_a(dstName);
                this.altIcons.put((Object)src, (Object)dst);
                this.altIcons.put((Object)dst, (Object)dst);
            }
            this.altIcons = this.altIcons.isEmpty() ? null : CollectionUtil.lockMap(this.altIcons);
        }
    }

    @Override
    public boolean shouldKeep() {
        return this.icon != null || this.altIcons != null;
    }
}

