/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.mcpatcher.internal.modules.cit;

import com.falsepattern.mcpatcher.internal.modules.cit.CITEngine;
import com.falsepattern.mcpatcher.internal.modules.common.CommonParser;
import java.util.Properties;
import lombok.Generated;
import org.jetbrains.annotations.Nullable;

public final class CITPropsGlobal {
    private static final Method DEFAULT_METHOD = Method.AVERAGE;
    private static final int DEFAULT_CAP = 99;
    private static final float DEFAULT_FADE = 0.5f;
    private static final boolean DEFAULT_USE_GLINT = true;
    private final Method method;
    private final int cap;
    private final float fade;
    private final boolean useGlint;

    public CITPropsGlobal() {
        this.method = DEFAULT_METHOD;
        this.cap = 99;
        this.fade = 0.5f;
        this.useGlint = true;
    }

    public CITPropsGlobal(Properties props) {
        this.method = Method.parse(props.getProperty("method"), DEFAULT_METHOD);
        this.cap = Math.max(CommonParser.parseInt(props.getProperty("cap"), 99), 0);
        this.fade = Math.max(CommonParser.parseFloat(props.getProperty("fade"), 0.5f), 0.0f);
        this.useGlint = CommonParser.parseBoolean("glint", true);
    }

    @Generated
    public Method method() {
        return this.method;
    }

    @Generated
    public int cap() {
        return this.cap;
    }

    @Generated
    public float fade() {
        return this.fade;
    }

    @Generated
    public boolean useGlint() {
        return this.useGlint;
    }

    public static enum Method {
        AVERAGE,
        LAYERED,
        CYCLE;


        public static Method parse(@Nullable String value, Method def) {
            if (value == null) {
                return def;
            }
            switch (value) {
                case "average": {
                    return AVERAGE;
                }
                case "layered": {
                    return LAYERED;
                }
                case "cycle": {
                    return CYCLE;
                }
            }
            CITEngine.LOG.warn("Unknown method in cit.properties: [method={}]", new Object[]{value});
            return def;
        }
    }
}

