/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.mcpatcher.internal.modules.cit;

import com.falsepattern.mcpatcher.internal.modules.cit.DamageRangeList;
import com.falsepattern.mcpatcher.internal.modules.common.CollectionUtil;
import com.falsepattern.mcpatcher.internal.modules.common.CommonParser;
import com.falsepattern.mcpatcher.internal.modules.common.IntRange;
import com.falsepattern.mcpatcher.internal.modules.common.NBTRule;
import cpw.mods.fml.common.registry.GameRegistry;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import it.unimi.dsi.fastutil.objects.ObjectList;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import net.minecraft.item.Item;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CITParser {
    private CITParser() {
        throw new UnsupportedOperationException();
    }

    public static int parseWeight(Properties props) {
        return CommonParser.parseInt(props.getProperty("weight"), 0);
    }

    @Nullable
    public static DamageRangeList parseDamage(Properties props) {
        IntRange.List ranges;
        String str = props.getProperty("damage");
        if (str == null) {
            return null;
        }
        boolean isPercent = StringUtils.contains((CharSequence)str, (int)37);
        if (isPercent) {
            str = StringUtils.remove((String)str, (char)'%');
        }
        if ((ranges = CommonParser.parseIntRanges(str)) == null) {
            return null;
        }
        return new DamageRangeList(ranges, isPercent);
    }

    public static int parseDamageMask(Properties props) {
        return CommonParser.parseInt(props.getProperty("damageMask"), -1);
    }

    public static  @Nullable IntRange.List parseStackSize(Properties props) {
        return CommonParser.parseIntRanges(props.getProperty("stackSize"));
    }

    public static  @Nullable IntRange.List parseEnchantmentIDs(Properties props) {
        return CommonParser.parseIntRanges(props.getProperty("enchantmentIDs"));
    }

    public static  @Nullable IntRange.List parseEnchantmentLevels(Properties props) {
        return CommonParser.parseIntRanges(props.getProperty("enchantmentLevels"));
    }

    public static ObjectList<NBTRule> parseNbtRules(Properties props) {
        ObjectArrayList list = new ObjectArrayList();
        Set<Map.Entry<Object, Object>> entries = props.entrySet();
        for (Map.Entry<Object, Object> entry : entries) {
            NBTRule rule = NBTRule.create((String)entry.getKey(), (String)entry.getValue());
            if (rule == null) continue;
            list.add((Object)rule);
        }
        return CollectionUtil.lockList(list);
    }

    @NotNull
    public static ObjectSet<Item> parseItems(Properties props) {
        ObjectArraySet set = new ObjectArraySet();
        CITParser.parseItems((ObjectSet<Item>)set, props.getProperty("items"));
        if (set.isEmpty()) {
            CITParser.parseItems((ObjectSet<Item>)set, props.getProperty("matchItems"));
        }
        return CollectionUtil.lockSet(set);
    }

    @Nullable
    public static String parseTexture(String name, Properties props) {
        String texture = CITParser.parseTexture(name, props.getProperty("source"));
        if (texture == null) {
            texture = CITParser.parseTexture(name, props.getProperty("texture"));
        }
        if (texture == null) {
            texture = CITParser.parseTexture(name, props.getProperty("tile"));
        }
        return texture;
    }

    public static Object2ObjectMap<String, String> parseAltTextures(String name, Properties props) {
        Object2ObjectArrayMap map = new Object2ObjectArrayMap();
        Set<Map.Entry<Object, Object>> entries = props.entrySet();
        for (Map.Entry<Object, Object> entry : entries) {
            String value;
            String texture;
            String str;
            String key = (String)entry.getKey();
            if (key.startsWith("source.")) {
                str = key.substring("source.".length());
            } else if (key.startsWith("texture.")) {
                str = key.substring("texture.".length());
            } else {
                if (!key.startsWith("tile.")) continue;
                str = key.substring("tile.".length());
            }
            if ((texture = CITParser.parseTexture(name, value = (String)entry.getValue())) == null) continue;
            map.put((Object)str, (Object)texture);
        }
        return CollectionUtil.lockMap(map);
    }

    private static void parseItems(ObjectSet<Item> set, @Nullable String str) {
        String[] itemNames;
        if (str == null) {
            return;
        }
        for (String itemName : itemNames = StringUtils.split((String)str)) {
            Item item = CITParser.findItem(itemName);
            if (item == null) continue;
            set.add((Object)item);
        }
    }

    @Nullable
    private static Item findItem(@NotNull String itemName) {
        String name;
        String modId;
        String[] split = StringUtils.split((String)itemName, (char)':');
        if (split.length == 1) {
            modId = "minecraft";
            name = split[0];
        } else if (split.length == 2) {
            modId = split[0];
            name = split[1];
        } else {
            CommonParser.LOG.warn("Invalid item name: {}", new Object[]{itemName});
            return null;
        }
        Item item = GameRegistry.findItem((String)modId, (String)name);
        if (item == null) {
            CommonParser.LOG.warn("Item not found: {}", new Object[]{itemName});
            return null;
        }
        return item;
    }

    @Nullable
    private static String parseTexture(String name, @Nullable String str) {
        if (str == null) {
            return null;
        }
        String texture = StringUtils.contains((CharSequence)str, (int)47) ? str : StringUtils.substringBeforeLast((String)name, (String)"/") + "/" + str;
        if (texture.endsWith(".png")) {
            return texture.substring(0, texture.length() - ".png".length());
        }
        return texture;
    }
}

