/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.mcpatcher.internal.config;

import com.falsepattern.lib.config.Config;
import com.falsepattern.lib.config.ConfigurationManager;
import com.falsepattern.mcpatcher.internal.config.MixinConfig;
import lombok.Generated;

@Config.Comment(value={"Runtime Module Toggles"})
@Config.LangKey
@Config(modid="mcpatcher", category="00_modules")
public final class ModuleConfig {
    @Config.Comment(value={"Runtime toggle for connected textures.", "Requires connectedTexturesMixins enabled."})
    @Config.LangKey
    @Config.Name(value="connectedTextures")
    @Config.DefaultBoolean(value=true)
    public static boolean connectedTextures;
    @Config.Comment(value={"Allow regular glass blocks, glass panes, and beacon glass to have semi-transparent textures.", "Requires betterGlassMixins enabled."})
    @Config.LangKey
    @Config.Name(value="betterGlass")
    @Config.DefaultBoolean(value=true)
    public static boolean betterGlass;
    @Config.Comment(value={"Runtime toggle for random mobs.", "Requires randomMobsMixins to be enabled."})
    @Config.LangKey
    @Config.Name(value="randomMobs")
    @Config.DefaultBoolean(value=true)
    public static boolean randomMobs;
    @Config.Comment(value={"Runtime toggle for custom item textures.", "Requires customItemTexturesMixins enabled."})
    @Config.LangKey
    @Config.Name(value="customItemTextures")
    @Config.DefaultBoolean(value=true)
    public static boolean customItemTextures;

    public static boolean isConnectedTexturesEnabled() {
        return MixinConfig.connectedTexturesMixins && connectedTextures;
    }

    public static boolean isBetterGlassEnabled() {
        return MixinConfig.betterGlassMixins && betterGlass;
    }

    public static boolean isCustomItemTexturesEnabled() {
        return MixinConfig.customItemTexturesMixins != MixinConfig.CITMixinStrength.Disabled && customItemTextures;
    }

    public static boolean isRandomMobsEnabled() {
        return MixinConfig.randomMobsMixins && randomMobs;
    }

    public static void init() {
    }

    @Generated
    public ModuleConfig() {
    }

    static {
        ConfigurationManager.selfInit();
        MixinConfig.init();
    }
}

