/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.mcpatcher.internal;

import com.falsepattern.mcpatcher.internal.Share;
import com.falsepattern.mcpatcher.internal.config.ModuleConfig;
import com.falsepattern.mcpatcher.internal.modules.cit.CITEngine;
import com.falsepattern.mcpatcher.internal.modules.mob.MobEngine;
import cpw.mods.fml.client.event.ConfigChangedEvent;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.IReloadableResourceManager;
import net.minecraft.client.resources.IResourceManager;

public class Proxy {
    public void postInit(FMLPostInitializationEvent event) {
    }

    public static class Client
    extends Proxy {
        private boolean connectedTextures;
        private boolean customItemTextures;
        private boolean randomMobs;

        @Override
        public void postInit(FMLPostInitializationEvent event) {
            Minecraft mc = Minecraft.func_71410_x();
            IReloadableResourceManager resMan = (IReloadableResourceManager)mc.func_110442_L();
            resMan.func_110542_a(this::reloadResources);
            this.connectedTextures = ModuleConfig.isConnectedTexturesEnabled();
            this.customItemTextures = ModuleConfig.isCustomItemTexturesEnabled();
            this.randomMobs = ModuleConfig.isRandomMobsEnabled();
            FMLCommonHandler.instance().bus().register((Object)this);
        }

        @SubscribeEvent
        public void onConfigCache(ConfigChangedEvent.PostConfigChangedEvent e) {
            if (!"mcpatcher".equals(e.modID)) {
                return;
            }
            boolean doResourceRefresh = false;
            doResourceRefresh |= this.connectedTextures != ModuleConfig.isConnectedTexturesEnabled();
            doResourceRefresh |= this.customItemTextures != ModuleConfig.isCustomItemTexturesEnabled();
            if (doResourceRefresh |= this.randomMobs && !ModuleConfig.isRandomMobsEnabled()) {
                Minecraft.func_71410_x().func_147106_B();
            }
            this.connectedTextures = ModuleConfig.isConnectedTexturesEnabled();
            this.customItemTextures = ModuleConfig.isCustomItemTexturesEnabled();
            this.randomMobs = ModuleConfig.isRandomMobsEnabled();
        }

        private void reloadResources(IResourceManager resourceManager) {
            Share.log.debug("Reloading Resources");
            if (ModuleConfig.isCustomItemTexturesEnabled()) {
                CITEngine.reloadResources();
            }
            if (ModuleConfig.isRandomMobsEnabled()) {
                MobEngine.reloadResources();
            }
        }
    }

    public static class Server
    extends Proxy {
    }
}

