/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.falsetweaks.modules.voxelizer.strategy;

import com.falsepattern.falsetweaks.modules.voxelizer.Face;
import com.falsepattern.falsetweaks.modules.voxelizer.strategy.MergingStrategy;
import java.util.Arrays;
import java.util.List;

public class BestMergingStrategy
implements MergingStrategy {
    private final MergingStrategy[] strategies;

    public BestMergingStrategy(MergingStrategy ... strategies) {
        this.strategies = Arrays.copyOf(strategies, strategies.length);
    }

    public BestMergingStrategy(List<? extends MergingStrategy> strategies) {
        this(strategies.toArray(new MergingStrategy[0]));
    }

    @Override
    public void merge(Face[][] faces) {
        int i;
        Face[][][] sources = new Face[this.strategies.length][][];
        int bestFaceCount = 0;
        int bestFaceCountIndex = -1;
        sources[0] = faces;
        for (i = 1; i < this.strategies.length; ++i) {
            sources[i] = MergingStrategy.clone(faces);
        }
        for (i = 0; i < this.strategies.length; ++i) {
            this.strategies[i].merge(sources[i]);
            int faceCount = MergingStrategy.countFaces(sources[i]);
            if (faceCount >= bestFaceCount && bestFaceCountIndex != -1) continue;
            bestFaceCount = faceCount;
            bestFaceCountIndex = i;
        }
        MergingStrategy.emplace(faces, sources[bestFaceCountIndex]);
    }
}

