/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.falsetweaks.modules.triangulator.calibration;

import com.falsepattern.falsetweaks.modules.triangulator.calibration.Calibration;
import com.falsepattern.lib.compat.GuiLabel;
import com.falsepattern.lib.text.FormattedText;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class CalibrationGUI
extends GuiScreen {
    private static final int ID_DESCRIPTION = 0;
    private static final int ID_TOGGLE = 1;
    private static final int ID_APPLY = 2;
    private final ResourceLocation reference = new ResourceLocation("falsetweaks", "reference.png");
    protected List<GuiLabel> field_146293_o = new ArrayList<GuiLabel>();
    private boolean flip = false;

    private int getYAfterComparison(int scale) {
        return 10 + scale * 4 + 20;
    }

    private void drawComparison(int scale) {
        int centerX = this.field_146294_l / 2;
        int left = centerX - scale;
        int top = 10;
        GL11.glPushAttrib((int)8256);
        GL11.glDisable((int)3042);
        GL11.glDisable((int)2896);
        GL11.glDisable((int)3553);
        GL11.glShadeModel((int)7425);
        this.drawQuad(left, top, scale, 3, 0xFFFF00, false, this.flip);
        this.drawQuad(left, top + scale, scale, 0, 0xFFFF00, false, !this.flip);
        this.drawQuad(left + scale, top + scale, scale, 1, 0xFFFF00, false, this.flip);
        this.drawQuad(left + scale, top, scale, 2, 0xFFFF00, false, !this.flip);
        GL11.glEnable((int)3553);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(this.reference);
        this.drawQuad(left, top += scale * 2 + 10, scale * 2, 4, 0xFFFFFF, true, false);
        GL11.glPopAttrib();
    }

    public void func_73866_w_() {
        String key;
        String translated;
        super.func_73866_w_();
        this.field_146293_o.clear();
        int centerX = this.field_146294_l / 2;
        int y = this.getYAfterComparison(25) + 5;
        GuiLabel descriptionLabel = new GuiLabel(this.field_146289_q, 0, centerX, y, 0, 10, 0xFFFFFF);
        descriptionLabel.setCentered();
        int i = 0;
        while (!(translated = I18n.func_135052_a((String)(key = "gui.triangulator.calibrationdescription.line" + i), (Object[])new Object[0])).equals("END") && !translated.equals(key)) {
            descriptionLabel.addLine(key);
            y += 10;
            ++i;
        }
        this.field_146293_o.add(descriptionLabel);
        GuiButton toggle = new GuiButton(1, centerX - 110, y, 100, 20, I18n.func_135052_a((String)"gui.triangulator.calibration.toggle", (Object[])new Object[0]));
        GuiButton apply = new GuiButton(2, centerX + 10, y, 100, 20, I18n.func_135052_a((String)"gui.triangulator.calibration.apply", (Object[])new Object[0]));
        this.field_146292_n.add(toggle);
        this.field_146292_n.add(apply);
    }

    protected void func_146284_a(GuiButton button) {
        switch (button.field_146127_k) {
            case 1: {
                this.flip = !this.flip;
                break;
            }
            case 2: {
                Calibration.setCalibration(this.flip);
                Minecraft mc = Minecraft.func_71410_x();
                mc.func_147108_a(null);
                FormattedText.parse((String)(EnumChatFormatting.GREEN + I18n.func_135052_a((String)"chat.triangulator.calibrated.message", (Object[])new Object[0]))).addChatMessage((EntityPlayerSP)mc.field_71439_g);
            }
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        this.drawComparison(25);
        for (GuiLabel guiLabel : this.field_146293_o) {
            guiLabel.drawLabel(this.field_146297_k, mouseX, mouseY);
        }
        super.func_73863_a(mouseX, mouseY, partialTicks);
    }

    private void drawQuad(float x, float y, float scale, int blackIndex, int rgb, boolean texture, boolean alt) {
        int[] nArray;
        GL11.glBegin((int)7);
        int r = rgb >>> 16 & 0xFF;
        int g = rgb >>> 8 & 0xFF;
        int b = rgb & 0xFF;
        if (alt) {
            int[] nArray2 = new int[4];
            nArray2[0] = 1;
            nArray2[1] = 2;
            nArray2[2] = 3;
            nArray = nArray2;
            nArray2[3] = 0;
        } else {
            int[] nArray3 = new int[4];
            nArray3[0] = 0;
            nArray3[1] = 1;
            nArray3[2] = 2;
            nArray = nArray3;
            nArray3[3] = 3;
        }
        int[] map = nArray;
        for (int i = 0; i < 4; ++i) {
            float Y;
            int j = map[i];
            int color = j == blackIndex ? 0 : 1;
            GL11.glColor3f((float)(r * color), (float)(g * color), (float)(b * color));
            float X = j == 0 || j == 3 ? x + scale : x;
            float f = Y = j == 2 || j == 3 ? y + scale : y;
            if (texture) {
                GL11.glTexCoord2f((float)(j == 0 || j == 3 ? 1.0f : 0.0f), (float)(j == 2 || j == 3 ? 1.0f : 0.0f));
            }
            GL11.glVertex2f((float)X, (float)Y);
        }
        GL11.glEnd();
    }
}

