/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.falsetweaks.modules.threadedupdates.saftey;

import com.falsepattern.falsetweaks.api.threading.ThreadSafeBlockRenderer;
import com.falsepattern.falsetweaks.modules.threadedupdates.saftey.IRenderingRegistryExt;
import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import cpw.mods.fml.client.registry.RenderingRegistry;
import it.unimi.dsi.fastutil.objects.Reference2BooleanMap;
import it.unimi.dsi.fastutil.objects.Reference2BooleanOpenHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import net.minecraft.block.Block;

public class ThreadedBlockSafetyRegistry {
    private static final ReentrantReadWriteLock LOCK = new ReentrantReadWriteLock();
    private static final Reference2BooleanMap<Block> ISBRH_SAFETY_MAP = new Reference2BooleanOpenHashMap();

    public static boolean canBlockRenderOffThread(Block block) {
        Lock lock = LOCK.readLock();
        while (!lock.tryLock()) {
            Thread.yield();
        }
        try {
            if (ISBRH_SAFETY_MAP.containsKey((Object)block)) {
                boolean bl = ISBRH_SAFETY_MAP.getBoolean((Object)block);
                return bl;
            }
            lock.unlock();
            lock = LOCK.writeLock();
            while (!lock.tryLock()) {
                Thread.yield();
            }
            boolean bl = ISBRH_SAFETY_MAP.computeIfAbsent((Object)block, ThreadedBlockSafetyRegistry::getCanRenderOffThread);
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    private static boolean getCanRenderOffThread(Block block) {
        ISimpleBlockRenderingHandler renderer = ((IRenderingRegistryExt)RenderingRegistry.instance()).getISBRH(block);
        return renderer instanceof ThreadSafeBlockRenderer;
    }
}

