/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.falsetweaks.modules.threadedupdates.interop;

import cofh.core.block.BlockCoFHBase;
import cofh.thermalexpansion.block.simple.BlockFrame;
import com.falsepattern.falsetweaks.modules.threading.MainThreadContainer;
import lombok.Generated;

public final class ThermalExpansionCompat {
    private static final ThreadLocal<Integer> cofhBlockRenderPass = ThreadLocal.withInitial(() -> 0);
    private static final ThreadLocal<Integer> frameBlockRenderPass = ThreadLocal.withInitial(() -> 0);

    public static int getCofhBlockRenderPass() {
        if (MainThreadContainer.isMainThread()) {
            return BlockCoFHBase.renderPass;
        }
        return cofhBlockRenderPass.get();
    }

    public static void setCofhBlockRenderPass(int pass) {
        if (MainThreadContainer.isMainThread()) {
            BlockCoFHBase.renderPass = pass;
        } else {
            cofhBlockRenderPass.set(pass);
        }
    }

    public static int getFrameBlockRenderPass() {
        if (MainThreadContainer.isMainThread()) {
            return BlockFrame.renderPass;
        }
        return frameBlockRenderPass.get();
    }

    public static void setFrameBlockRenderPass(int pass) {
        if (MainThreadContainer.isMainThread()) {
            BlockFrame.renderPass = pass;
        } else {
            frameBlockRenderPass.set(pass);
        }
    }

    @Generated
    private ThermalExpansionCompat() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

