/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.falsetweaks.modules.profiler;

import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ProfilingNode {
    public final ProfilingNode parent;
    public final String name;
    public final Map<String, ProfilingNode> childrenMap = new HashMap<String, ProfilingNode>();
    private final List<ProfilingNode> children = new ArrayList<ProfilingNode>();
    public long totalTime = 0L;
    private long start;
    private String fullNameString = null;

    private ProfilingNode(ProfilingNode parent, String name) {
        this.parent = parent;
        this.name = name.intern();
    }

    public static ProfilingNode createRoot() {
        return new ProfilingNode(null, "");
    }

    public void start() {
        this.start = System.nanoTime();
    }

    public long end() {
        long delta = System.nanoTime() - this.start;
        this.totalTime += delta;
        return delta;
    }

    public ProfilingNode getOrCreateChild(String name) {
        return this.childrenMap.computeIfAbsent(name, s -> {
            ProfilingNode n = new ProfilingNode(this, (String)s);
            this.children.add(n);
            return n;
        });
    }

    public String fullName() {
        if (this.fullNameString == null) {
            this.fullNameString = (this.parent.parent != null ? this.parent.fullName() + "." + this.name : this.name).intern();
        }
        return this.fullNameString;
    }

    public ProfilingNode findChild(String[] path, int index) {
        if (path == null || path.length == 0) {
            return null;
        }
        if (index == path.length) {
            return this;
        }
        String node = path[index];
        if (!this.childrenMap.containsKey(node)) {
            return null;
        }
        return this.childrenMap.get(node).findChild(path, index + 1);
    }

    public void toJson(JsonWriter json) throws IOException {
        if (this.parent != null) {
            json.beginObject();
            json.name("name").value(this.name);
            json.name("timeNs").value(this.totalTime);
            json.name("children");
            json.beginArray();
        }
        for (ProfilingNode child : this.childrenMap.values()) {
            child.toJson(json);
        }
        if (this.parent != null) {
            json.endArray();
            json.endObject();
        }
    }
}

