/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.falsetweaks.modules.misc;

import com.falsepattern.falsetweaks.Share;
import com.falsepattern.falsetweaks.modules.misc.IPendingBlockUpdatesWorldServer;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMaps;
import it.unimi.dsi.fastutil.objects.ObjectRBTreeSet;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.NextTickListEntry;

public class ChunkPendingBlockUpdateMap {
    public static final boolean DEBUG = Boolean.parseBoolean(System.getProperty("coretweaks.optimizeGetPendingBlockUpdates.debug", "false"));
    public static final boolean LENIENT_MODE = Boolean.parseBoolean(System.getProperty("coretweaks.optimizeGetPendingBlockUpdates.lenient", "false"));

    public static void add(IPendingBlockUpdatesWorldServer ws, NextTickListEntry e) {
        Long2ObjectMap<ObjectSet<NextTickListEntry>> map = ws.ft$getChunkPendingUpdatesMap();
        long key = ChunkCoordIntPair.func_77272_a((int)(e.field_77183_a >> 4), (int)(e.field_77182_c >> 4));
        ObjectSet chunkSet = (ObjectSet)map.computeIfAbsent(key, k -> new ObjectRBTreeSet());
        chunkSet.add((Object)e);
    }

    public static void remove(IPendingBlockUpdatesWorldServer ws, NextTickListEntry e) {
        long key;
        Long2ObjectMap<ObjectSet<NextTickListEntry>> map = ws.ft$getChunkPendingUpdatesMap();
        ObjectSet chunkSet = (ObjectSet)map.get(key = ChunkCoordIntPair.func_77272_a((int)(e.field_77183_a >> 4), (int)(e.field_77182_c >> 4)));
        if (chunkSet != null) {
            chunkSet.remove((Object)e);
            if (chunkSet.isEmpty()) {
                map.remove(key);
            }
        }
    }

    public static ObjectSet<NextTickListEntry> get(IPendingBlockUpdatesWorldServer ws, int cx, int cz) {
        Long2ObjectMap<ObjectSet<NextTickListEntry>> map = ws.ft$getChunkPendingUpdatesMap();
        long key = ChunkCoordIntPair.func_77272_a((int)cx, (int)cz);
        return (ObjectSet)map.get(key);
    }

    public static void removeKey(IPendingBlockUpdatesWorldServer ws, int cx, int cz) {
        Long2ObjectMap<ObjectSet<NextTickListEntry>> map = ws.ft$getChunkPendingUpdatesMap();
        long key = ChunkCoordIntPair.func_77272_a((int)cx, (int)cz);
        map.remove(key);
    }

    public static boolean isEmpty(IPendingBlockUpdatesWorldServer ws) {
        Long2ObjectMap<ObjectSet<NextTickListEntry>> map = ws.ft$getChunkPendingUpdatesMap();
        return map == null || map.isEmpty();
    }

    public static void onTick(IPendingBlockUpdatesWorldServer ws) {
        if (DEBUG) {
            Long2ObjectMap<ObjectSet<NextTickListEntry>> map = ws.ft$getChunkPendingUpdatesMap();
            StringBuilder debug = new StringBuilder();
            for (Long2ObjectMap.Entry e : Long2ObjectMaps.fastIterable(map)) {
                long k = e.getLongKey();
                int cx = ChunkPendingBlockUpdateMap.chunkCoordPairToX(k);
                int cz = ChunkPendingBlockUpdateMap.chunkCoordPairToZ(k);
                debug.append("(").append(cx).append(", ").append(cz).append("), ");
            }
            if (!map.isEmpty()) {
                Share.log.info("{}: {}", new Object[]{map.size(), debug});
            }
        }
    }

    private static int chunkCoordPairToX(long pair) {
        return (int)(pair & 0xFFFFFFFFL);
    }

    private static int chunkCoordPairToZ(long pair) {
        return (int)(pair >> 32 & 0xFFFFFFFFL);
    }

    public static void onError() {
        System.out.println("ERROR");
    }
}

