/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.falsetweaks.modules.dynlights;

import com.falsepattern.falsetweaks.Compat;
import com.falsepattern.falsetweaks.Share;
import com.falsepattern.falsetweaks.api.dynlights.DynamicLightsDriver;
import com.falsepattern.falsetweaks.config.DynamicLightsConfig;
import com.falsepattern.falsetweaks.config.ModuleConfig;
import com.falsepattern.falsetweaks.modules.dynlights.DynamicLightsNoOp;
import com.falsepattern.falsetweaks.modules.dynlights.base.DynamicLights;

public class DynamicLightsDrivers {
    public static DynamicLightsDriver frontend = DynamicLightsNoOp.INSTANCE;
    private static int backendPriority = 1000;
    private static DynamicLightsDriver backend;
    private static boolean initialized;

    public static void registerBackend(DynamicLightsDriver backend, int priority) {
        if (initialized) {
            throw new IllegalStateException("Frontend already initialized! Register dynamic light backends in preInit or init!");
        }
        if (priority < backendPriority) {
            backendPriority = priority;
            DynamicLightsDrivers.backend = backend;
        } else if (priority == backendPriority) {
            Share.log.warn("Dynamic lights backend with colliding priority registered!\nExisting backend class: {}\nNew backend class: {}", new Object[]{DynamicLightsDrivers.backend.getClass().getName(), backend.getClass().getName()});
            DynamicLightsDrivers.backend = backend;
        }
    }

    public static void postInit() {
        initialized = true;
        if (backend == null) {
            backend = DynamicLights.INSTANCE;
        }
        frontend = backend;
    }

    public static boolean isDynamicLights() {
        if (Compat.optiFineHasDynamicLights()) {
            return OptiFineCompat.isDynamicLights();
        }
        return ModuleConfig.DYNAMIC_LIGHTS && DynamicLightsConfig.STATE != DynamicLightsConfig.DynamicLightsState.Disabled;
    }

    public static boolean isDynamicLightsFast() {
        if (Compat.optiFineHasDynamicLights()) {
            return OptiFineCompat.isDynamicLightsFast();
        }
        return ModuleConfig.DYNAMIC_LIGHTS && DynamicLightsConfig.STATE == DynamicLightsConfig.DynamicLightsState.Fast;
    }

    public static boolean isDynamicHandLight() {
        if (Compat.optiFineHasDynamicLights()) {
            if (Compat.shaderType() == Compat.ShaderType.Optifine) {
                return OptiFineCompat.isDynamicHandLight();
            }
            return OptiFineCompat.isDynamicLights();
        }
        return ModuleConfig.DYNAMIC_LIGHTS && DynamicLightsConfig.STATE != DynamicLightsConfig.DynamicLightsState.Disabled && DynamicLightsConfig.LIGHT_SOURCES.hand;
    }

    public static boolean isDynamicEntityLight() {
        if (Compat.optiFineHasDynamicLights()) {
            return OptiFineCompat.isDynamicLights();
        }
        return ModuleConfig.DYNAMIC_LIGHTS && DynamicLightsConfig.STATE != DynamicLightsConfig.DynamicLightsState.Disabled && DynamicLightsConfig.LIGHT_SOURCES.entity;
    }

    public static boolean isCircular() {
        return DynamicLightsConfig.CIRCULAR;
    }

    static {
        initialized = false;
    }

    private static class OptiFineCompat {
        private OptiFineCompat() {
        }

        public static boolean isDynamicLights() {
            return Config.isDynamicLights();
        }

        public static boolean isDynamicLightsFast() {
            return Config.isDynamicLightsFast();
        }

        public static boolean isDynamicHandLight() {
            return Config.isDynamicHandLight();
        }
    }
}

