/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.falsetweaks.mixin.mixins.common.startup;

import com.falsepattern.falsetweaks.modules.startup.RegexHelper;
import com.falsepattern.falsetweaks.modules.startup.ThreadSafeASMDataTable;
import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.LoaderException;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.discovery.ASMDataTable;
import cpw.mods.fml.common.discovery.ModCandidate;
import cpw.mods.fml.common.discovery.ModDiscoverer;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(value={ModDiscoverer.class}, remap=false)
public abstract class ModDiscovererMixin {
    @Shadow
    private List<ModCandidate> candidates;
    @Shadow
    private ASMDataTable dataTable;
    @Shadow
    private List<File> nonModLibs;
    private String fileName;

    @Redirect(method={"findModDirMods(Ljava/io/File;[Ljava/io/File;)V"}, at=@At(value="INVOKE", target="Ljava/util/regex/Pattern;matcher(Ljava/lang/CharSequence;)Ljava/util/regex/Matcher;"), require=1)
    private Matcher noMatcher(Pattern instance, CharSequence charSequence) {
        this.fileName = charSequence.toString();
        return null;
    }

    @Redirect(method={"findModDirMods(Ljava/io/File;[Ljava/io/File;)V"}, at=@At(value="INVOKE", target="Ljava/util/regex/Matcher;matches()Z"), require=1)
    private boolean fastMatch(Matcher instance) {
        return RegexHelper.zipJarRegex(this.fileName);
    }

    @Redirect(method={"findModDirMods(Ljava/io/File;[Ljava/io/File;)V"}, at=@At(value="INVOKE", target="Ljava/util/regex/Matcher;group(I)Ljava/lang/String;"), require=1)
    private String noGroup(Matcher instance, int i) {
        return this.fileName;
    }

    @Overwrite
    public List<ModContainer> identifyMods() {
        ModCandidate candidate;
        int i;
        ExecutorService executor = Executors.newWorkStealingPool();
        ArrayList modList = Lists.newArrayList();
        int size = this.candidates.size();
        ArrayList<Future<List>> futures = new ArrayList<Future<List>>(size);
        ((ThreadSafeASMDataTable)this.dataTable).enableMutex(true);
        for (i = 0; i < size; ++i) {
            candidate = this.candidates.get(i);
            futures.add(executor.submit(() -> candidate.explore(this.dataTable)));
        }
        executor.shutdown();
        for (i = 0; i < size; ++i) {
            candidate = this.candidates.get(i);
            try {
                List mods;
                try {
                    mods = (List)((Future)futures.get(i)).get();
                }
                catch (ExecutionException e) {
                    throw e.getCause();
                }
                if (mods.isEmpty() && !candidate.isClasspath()) {
                    this.nonModLibs.add(candidate.getModContainer());
                    continue;
                }
                modList.addAll(mods);
                continue;
            }
            catch (LoaderException le) {
                FMLLog.log((Level)Level.WARN, (Throwable)le, (String)"Identified a problem with the mod candidate %s, ignoring this source", (Object[])new Object[]{candidate.getModContainer()});
                continue;
            }
            catch (Throwable t) {
                Throwables.propagate((Throwable)t);
            }
        }
        ((ThreadSafeASMDataTable)this.dataTable).enableMutex(false);
        return modList;
    }
}

