/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.falsetweaks.mixin.mixins.client.vertexapi;

import com.falsepattern.falsetweaks.Compat;
import com.falsepattern.falsetweaks.modules.vertexapi.VertexInfo;
import java.util.Comparator;
import net.minecraft.client.util.QuadComparator;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={QuadComparator.class}, priority=950)
public abstract class QuadComparatorMixin
implements Comparator<Integer> {
    @Shadow
    public int[] field_147627_d;
    @Shadow
    public float field_147630_a;
    @Shadow
    public float field_147628_b;
    @Shadow
    public float field_147629_c;

    @Override
    @Overwrite
    public int compare(Integer o1, Integer o2) {
        int[] vertexData = this.field_147627_d;
        int stride = VertexInfo.getVertexInfo(Compat.shaderType(), 1);
        int stride2 = stride * 2;
        int stride3 = stride * 3;
        float refX = this.field_147630_a;
        float refY = this.field_147628_b;
        float refZ = this.field_147629_c;
        float aSQ = QuadComparatorMixin.ft$getDistSQ(vertexData, o1, stride, stride2, stride3, refX, refY, refZ);
        float bSQ = QuadComparatorMixin.ft$getDistSQ(vertexData, o2, stride, stride2, stride3, refX, refY, refZ);
        return Float.compare(bSQ, aSQ);
    }

    @Unique
    private static float ft$getDistSQ(int[] vertexData, int primitive, int stride, int stride2, int stride3, float refX, float refY, float refZ) {
        float x1 = Float.intBitsToFloat(vertexData[primitive]) - refX;
        float y1 = Float.intBitsToFloat(vertexData[primitive + 1]) - refY;
        float z1 = Float.intBitsToFloat(vertexData[primitive + 2]) - refZ;
        float x2 = Float.intBitsToFloat(vertexData[primitive + stride]) - refX;
        float y2 = Float.intBitsToFloat(vertexData[primitive + stride + 1]) - refY;
        float z2 = Float.intBitsToFloat(vertexData[primitive + stride + 2]) - refZ;
        float x3 = Float.intBitsToFloat(vertexData[primitive + stride2]) - refX;
        float y3 = Float.intBitsToFloat(vertexData[primitive + stride2 + 1]) - refY;
        float z3 = Float.intBitsToFloat(vertexData[primitive + stride2 + 2]) - refZ;
        float x4 = Float.intBitsToFloat(vertexData[primitive + stride3]) - refX;
        float y4 = Float.intBitsToFloat(vertexData[primitive + stride3 + 1]) - refY;
        float z4 = Float.intBitsToFloat(vertexData[primitive + stride3 + 2]) - refZ;
        float x = (x1 + x2 + x3 + x4) * 0.25f;
        float y = (y1 + y2 + y3 + y4) * 0.25f;
        float z = (z1 + z2 + z3 + z4) * 0.25f;
        return x * x + y * y + z * z;
    }
}

