/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.falsetweaks.mixin.mixins.client.triangulator;

import com.falsepattern.falsetweaks.Compat;
import com.falsepattern.falsetweaks.api.triangulator.ToggleableTessellator;
import com.falsepattern.falsetweaks.config.TriangulatorConfig;
import com.falsepattern.falsetweaks.modules.triangulator.interfaces.IRenderBlocksMixin;
import com.falsepattern.falsetweaks.modules.triangulator.interfaces.ITriangulatorTessellator;
import com.falsepattern.falsetweaks.modules.triangulator.renderblocks.Facing;
import java.util.Arrays;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.util.IIcon;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={RenderBlocks.class})
public abstract class RenderBlocksMixin
implements IRenderBlocksMixin {
    @Shadow(aliases={"colorRedTopLeftF"})
    public float field_147872_ap;
    @Shadow(aliases={"colorGreenTopLeftF"})
    public float field_147846_at;
    @Shadow(aliases={"colorBlueTopLeftF"})
    public float field_147854_ax;
    @Shadow(aliases={"colorRedBottomLeftF"})
    public float field_147852_aq;
    @Shadow(aliases={"colorGreenBottomLeftF"})
    public float field_147860_au;
    @Shadow(aliases={"colorBlueBottomLeftF"})
    public float field_147841_ay;
    @Shadow(aliases={"colorRedBottomRightF"})
    public float field_147850_ar;
    @Shadow(aliases={"colorGreenBottomRightF"})
    public float field_147858_av;
    @Shadow(aliases={"colorBlueBottomRightF"})
    public float field_147839_az;
    @Shadow(aliases={"colorRedTopRightF"})
    public float field_147848_as;
    @Shadow(aliases={"colorGreenTopRightF"})
    public float field_147856_aw;
    @Shadow(aliases={"colorBlueTopRightF"})
    public float field_147833_aA;
    @Unique
    private boolean[] ft$tri$states;
    @Unique
    private boolean[] ft$tri$reusePreviousStates;
    @Unique
    private boolean ft$tri$enableMultiRenderReuse;

    @Override
    public void ft$enableMultiRenderReuse(boolean state) {
        this.ft$tri$enableMultiRenderReuse = state;
    }

    @Override
    public void ft$reusePreviousStates(boolean state) {
        Arrays.fill(this.ft$tri$reusePreviousStates, state);
    }

    @Inject(method={"<init>()V", "<init>(Lnet/minecraft/world/IBlockAccess;)V"}, at={@At(value="RETURN")}, require=2)
    private void setupStates(CallbackInfo ci) {
        this.ft$tri$states = new boolean[6];
        this.ft$tri$reusePreviousStates = new boolean[6];
    }

    @Unique
    private void ft$reuseDiagonal(Facing.Direction dir) {
        int ord = dir.ordinal();
        if (this.ft$tri$reusePreviousStates[ord]) {
            ((ITriangulatorTessellator)Compat.tessellator()).alternativeTriangulation(this.ft$tri$states[ord]);
        } else {
            this.ft$tri$states[dir.ordinal()] = ((ITriangulatorTessellator)Compat.tessellator()).alternativeTriangulation();
        }
        if (this.ft$tri$enableMultiRenderReuse) {
            this.ft$tri$reusePreviousStates[ord] = true;
        }
    }

    @Unique
    private void ft$setTriangulatorDiagonal(Facing.Direction dir) {
        float altDiagonalDiff;
        float mainDiagonalDiff;
        if (this.ft$tri$reusePreviousStates[dir.ordinal()]) {
            return;
        }
        float avgTopLeft = (this.field_147872_ap + this.field_147846_at + this.field_147854_ax) / 3.0f;
        float avgBottomLeft = (this.field_147852_aq + this.field_147860_au + this.field_147841_ay) / 3.0f;
        float avgBottomRight = (this.field_147850_ar + this.field_147858_av + this.field_147839_az) / 3.0f;
        float avgTopRight = (this.field_147848_as + this.field_147856_aw + this.field_147833_aA) / 3.0f;
        if (((ToggleableTessellator)Compat.tessellator()).isTriangulatorDisabled() && TriangulatorConfig.Calibration.FLIP_DIAGONALS) {
            float tmp = avgTopLeft;
            avgTopLeft = avgBottomLeft;
            avgBottomLeft = tmp;
            tmp = avgTopRight;
            avgTopRight = avgBottomRight;
            avgBottomRight = tmp;
        }
        if ((double)Math.abs((mainDiagonalDiff = Math.abs(avgTopLeft - avgBottomRight)) - (altDiagonalDiff = Math.abs(avgBottomLeft - avgTopRight))) < 0.01) {
            float mainDiagonalAvg = (avgTopLeft + avgBottomRight) / 2.0f;
            float altDiagonalAvg = (avgBottomLeft + avgTopRight) / 2.0f;
            if ((double)Math.abs(mainDiagonalAvg - altDiagonalAvg) > 0.01 && mainDiagonalAvg < altDiagonalAvg) {
                ((ITriangulatorTessellator)Compat.tessellator()).alternativeTriangulation(true);
                return;
            }
        } else if (altDiagonalDiff < mainDiagonalDiff) {
            ((ITriangulatorTessellator)Compat.tessellator()).alternativeTriangulation(true);
            return;
        }
        ((ITriangulatorTessellator)Compat.tessellator()).alternativeTriangulation(false);
    }

    @Inject(method={"renderFaceXNeg"}, at={@At(value="HEAD")}, require=1)
    private void reuseXNeg(Block p_147798_1_, double p_147798_2_, double p_147798_4_, double p_147798_6_, IIcon p_147798_8_, CallbackInfo ci) {
        this.ft$setTriangulatorDiagonal(Facing.Direction.FACE_XNEG);
        this.ft$reuseDiagonal(Facing.Direction.FACE_XNEG);
    }

    @Inject(method={"renderFaceXPos"}, at={@At(value="HEAD")}, require=1)
    private void reuseXPos(Block p_147798_1_, double p_147798_2_, double p_147798_4_, double p_147798_6_, IIcon p_147798_8_, CallbackInfo ci) {
        this.ft$setTriangulatorDiagonal(Facing.Direction.FACE_XPOS);
        this.ft$reuseDiagonal(Facing.Direction.FACE_XPOS);
    }

    @Inject(method={"renderFaceYNeg"}, at={@At(value="HEAD")}, require=1)
    private void reuseYNeg(Block p_147798_1_, double p_147798_2_, double p_147798_4_, double p_147798_6_, IIcon p_147798_8_, CallbackInfo ci) {
        this.ft$setTriangulatorDiagonal(Facing.Direction.FACE_YNEG);
        this.ft$reuseDiagonal(Facing.Direction.FACE_YNEG);
    }

    @Inject(method={"renderFaceYPos"}, at={@At(value="HEAD")}, require=1)
    private void reuseYPos(Block p_147798_1_, double p_147798_2_, double p_147798_4_, double p_147798_6_, IIcon p_147798_8_, CallbackInfo ci) {
        this.ft$setTriangulatorDiagonal(Facing.Direction.FACE_YPOS);
        this.ft$reuseDiagonal(Facing.Direction.FACE_YPOS);
    }

    @Inject(method={"renderFaceZNeg"}, at={@At(value="HEAD")}, require=1)
    private void reuseZNeg(Block p_147798_1_, double p_147798_2_, double p_147798_4_, double p_147798_6_, IIcon p_147798_8_, CallbackInfo ci) {
        this.ft$setTriangulatorDiagonal(Facing.Direction.FACE_ZNEG);
        this.ft$reuseDiagonal(Facing.Direction.FACE_ZNEG);
    }

    @Inject(method={"renderFaceZPos"}, at={@At(value="HEAD")}, require=1)
    private void reuseZPos(Block p_147798_1_, double p_147798_2_, double p_147798_4_, double p_147798_6_, IIcon p_147798_8_, CallbackInfo ci) {
        this.ft$setTriangulatorDiagonal(Facing.Direction.FACE_ZPOS);
        this.ft$reuseDiagonal(Facing.Direction.FACE_ZPOS);
    }
}

