/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.falsetweaks;

import com.falsepattern.falsetweaks.api.ThreadedChunkUpdates;
import com.falsepattern.falsetweaks.config.ModuleConfig;
import com.falsepattern.falsetweaks.config.TriangulatorConfig;
import com.falsepattern.falsetweaks.modules.threadedupdates.ThreadTessellator;
import com.github.basdxz.apparatus.defenition.managed.IParaBlock;
import cpw.mods.fml.common.Loader;
import java.io.IOException;
import lombok.Generated;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.launchwrapper.Launch;
import net.minecraft.world.IBlockAccess;

public class Compat {
    public static boolean swanSongInstalled() {
        return SWANSONG.PRESENT;
    }

    public static boolean optiFineInstalled() {
        return OPTIFINE.PRESENT;
    }

    public static boolean dynamicLightsPresent() {
        return ModuleConfig.DYNAMIC_LIGHTS || Compat.optiFineHasDynamicLights();
    }

    public static boolean optiFineHasDynamicLights() {
        return OPTIFINE.PRESENT && DYNLIGHTS.PRESENT;
    }

    public static boolean optiFineHasShaders() {
        return OPTIFINE.PRESENT && SHADERS.PRESENT;
    }

    public static boolean beddiumInstalled() {
        return BEDDIUM.PRESENT;
    }

    public static void applyCompatibilityTweaks() {
        ThreadingCompat.init();
        if (Loader.isModLoaded((String)"apparatus")) {
            ApparatusCompat.init();
        }
    }

    public static boolean enableTriangulation() {
        return TriangulatorConfig.ENABLE_QUAD_TRIANGULATION && !Compat.beddiumInstalled();
    }

    public static Tessellator tessellator() {
        if (ThreadingCompat.isThreadedChunkUpdatingEnabled()) {
            return ThreadTessellator.getThreadTessellator();
        }
        return ThreadTessellator.mainThreadTessellator();
    }

    public static ShaderType shaderType() {
        return SWANSONG.PRESENT ? ShaderType.Swansong : (Compat.optiFineHasShaders() && OptifineCompat.isShaders() ? ShaderType.Optifine : ShaderType.None);
    }

    public static boolean isSTBIStitcher() {
        try {
            return LWJGL3IFY.PRESENT && LWJGL3IfyCompat.stbiTextureStitching();
        }
        catch (Throwable t) {
            t.printStackTrace();
            return false;
        }
    }

    public static float getAmbientOcclusionLightValue(Block block, int x, int y, int z, IBlockAccess blockAccess) {
        if (ApparatusCompat.isApparatusPresent()) {
            return ApparatusCompat.getAmbientOcclusionLightValue(block, x, y, z, blockAccess);
        }
        return block.func_149685_I();
    }

    private static class OptifineCompat {
        private OptifineCompat() {
        }

        public static boolean isShaders() {
            return Config.isShaders();
        }
    }

    private static class LWJGL3IfyCompat {
        private LWJGL3IfyCompat() {
        }

        public static boolean stbiTextureStitching() {
            return me.eigenraven.lwjgl3ify.core.Config.MIXIN_STBI_TEXTURE_STITCHING;
        }
    }

    private static class ThreadingCompat {
        private static boolean isThreadedChunkUpdatingEnabled;

        private ThreadingCompat() {
        }

        private static void init() {
            isThreadedChunkUpdatingEnabled = ThreadedChunkUpdates.isEnabled();
        }

        @Generated
        public static boolean isThreadedChunkUpdatingEnabled() {
            return isThreadedChunkUpdatingEnabled;
        }
    }

    private static class ApparatusCompat {
        private static boolean apparatusPresent = false;

        private ApparatusCompat() {
        }

        private static void init() {
            apparatusPresent = true;
        }

        public static float getAmbientOcclusionLightValue(Block block, int x, int y, int z, IBlockAccess blockAccess) {
            if (!(block instanceof IParaBlock)) {
                return block.func_149685_I();
            }
            return ((IParaBlock)block).paraTile(blockAccess, x, y, z).getAmbientOcclusionLightValue();
        }

        @Generated
        public static boolean isApparatusPresent() {
            return apparatusPresent;
        }
    }

    private static class SWANSONG {
        private static final boolean PRESENT;

        private SWANSONG() {
        }

        static {
            boolean present;
            try {
                present = Launch.classLoader.getClassBytes("com.ventooth.swansong.Share") != null;
            }
            catch (IOException e) {
                e.printStackTrace();
                present = false;
            }
            PRESENT = present;
        }
    }

    private static class BEDDIUM {
        private static final boolean PRESENT;

        private BEDDIUM() {
        }

        static {
            boolean present;
            try {
                present = Launch.classLoader.getClassBytes("com.ventooth.beddium.Share") != null;
            }
            catch (IOException e) {
                e.printStackTrace();
                present = false;
            }
            PRESENT = present;
        }
    }

    private static class LWJGL3IFY {
        private static final boolean PRESENT;

        private LWJGL3IFY() {
        }

        static {
            boolean present;
            try {
                present = Launch.classLoader.getClassBytes("me.eigenraven.lwjgl3ify.core.Lwjgl3ifyCoremod") != null;
            }
            catch (IOException e) {
                e.printStackTrace();
                present = false;
            }
            PRESENT = present;
        }
    }

    private static class SHADERS {
        private static final boolean PRESENT;

        private SHADERS() {
        }

        static {
            boolean present;
            try {
                present = Launch.classLoader.getClassBytes("shadersmod.client.Shaders") != null;
            }
            catch (IOException e) {
                e.printStackTrace();
                present = false;
            }
            PRESENT = present;
        }
    }

    private static class DYNLIGHTS {
        private static final boolean PRESENT;

        private DYNLIGHTS() {
        }

        static {
            boolean present;
            try {
                present = Launch.classLoader.getClassBytes("DynamicLights") != null;
            }
            catch (IOException e) {
                e.printStackTrace();
                present = false;
            }
            PRESENT = present;
        }
    }

    private static class OPTIFINE {
        private static final boolean PRESENT;

        private OPTIFINE() {
        }

        static {
            boolean present;
            try {
                present = Launch.classLoader.getClassBytes("Config") != null;
            }
            catch (IOException e) {
                e.printStackTrace();
                present = false;
            }
            PRESENT = present;
        }
    }

    public static enum ShaderType {
        None,
        Optifine,
        Swansong;

    }
}

