/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.endlessids.util;

import java.util.Arrays;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.chunk.NibbleArray;

public class DataUtil {
    public static byte[] ensureSubChunkByteArray(byte[] arr) {
        return arr == null ? null : (arr.length == 4096 ? arr : Arrays.copyOf(arr, 4096));
    }

    public static NibbleArray ensureSubChunkNibbleArray(byte[] data) {
        return data == null ? null : new NibbleArray(data.length == 2048 ? data : Arrays.copyOf(data, 2048), 4);
    }

    public static int readIDFromNBT(NBTTagCompound nbt) {
        if (nbt.func_150297_b("idExt", 3)) {
            return nbt.func_74762_e("idExt");
        }
        if (nbt.func_150297_b("id", 3)) {
            return nbt.func_74762_e("id");
        }
        if (nbt.func_150297_b("id", 2)) {
            return nbt.func_74765_d("id");
        }
        return 0;
    }

    public static void writeIDToNBT(NBTTagCompound nbt, int id) {
        if (id > 31999) {
            nbt.func_74777_a("id", (short)0);
            nbt.func_74768_a("idExt", id);
        } else {
            nbt.func_74777_a("id", (short)id);
        }
    }

    public static boolean nbtHasID(NBTTagCompound nbt) {
        return nbt.func_150297_b("id", 3) || nbt.func_150297_b("idExt", 3) || nbt.func_150297_b("id", 2);
    }
}

