/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.endlessids.mixin.mixins.common.antiidconflict;

import code.elix_x.coremods.antiidconflict.AntiIdConflictBase;
import code.elix_x.coremods.antiidconflict.managers.BiomesManager;
import com.falsepattern.endlessids.mixin.helpers.AIDCStringFixer;
import java.io.File;
import java.io.PrintWriter;
import net.minecraft.world.biome.BiomeGenBase;
import org.apache.commons.lang3.ArrayUtils;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.Constant;
import org.spongepowered.asm.mixin.injection.ModifyConstant;

@Mixin(value={BiomesManager.class}, remap=false)
public abstract class BiomesManagerMixin {
    @Shadow
    public static String freeBiomeIDs;
    @Shadow
    public static String occupiedBiomeIDs;
    @Shadow
    public static boolean debug;
    @Shadow
    public static int IconflictedIds;
    @Shadow
    public static String conflictedIds;

    private static String[] getIntervalNaming(int first, int last) {
        if (first == last) {
            return new String[]{Integer.toString(first)};
        }
        if (first + 1 == last) {
            return new String[]{Integer.toString(first), Integer.toString(last)};
        }
        return new String[]{first + "-" + last};
    }

    @ModifyConstant(method={"<clinit>"}, constant={@Constant(intValue=256)}, require=1)
    private static int extendIDs(int constant) {
        return 65536;
    }

    @ModifyConstant(method={"preinit"}, constant={@Constant(stringValue="\\biomes")})
    private static String fixPaths1(String original) {
        return AIDCStringFixer.fixString(original);
    }

    @ModifyConstant(method={"setUpBiomesFolder"}, constant={@Constant(stringValue="\\main.cfg")})
    private static String fixPaths2(String original) {
        return AIDCStringFixer.fixString(original);
    }

    @Overwrite
    public static void updateBiomesFolder() throws Exception {
        String[] conflictedIDs;
        String[] occupiedIDs;
        String[] freeIDs;
        int n;
        BiomeGenBase[] biomes = BiomeGenBase.func_150565_n();
        StringBuilder builder = new StringBuilder();
        boolean hasEmpty = false;
        int emptyRegionStart = 0;
        for (int i = 0; i < biomes.length; ++i) {
            if (biomes[i] == null) {
                if (!hasEmpty) {
                    emptyRegionStart = i;
                    hasEmpty = true;
                }
                ++BiomesManager.freeIds;
                continue;
            }
            if (!hasEmpty) continue;
            hasEmpty = false;
            String[] stringArray = BiomesManagerMixin.getIntervalNaming(emptyRegionStart, i - 1);
            n = stringArray.length;
            for (int j = 0; j < n; ++j) {
                String part = stringArray[j];
                builder.append(part).append('\n');
            }
        }
        if (hasEmpty) {
            String[] i = BiomesManagerMixin.getIntervalNaming(emptyRegionStart, 65535);
            int n2 = i.length;
            for (n = 0; n < n2; ++n) {
                String string = i[n];
                builder.append(string).append('\n');
            }
        }
        freeBiomeIDs = builder.toString();
        builder.setLength(0);
        System.out.println("Found " + BiomesManager.freeIds + " free biome ids in total.");
        for (BiomeGenBase biomeGenBase : biomes) {
            if (biomeGenBase == null) continue;
            builder.append(biomeGenBase.field_76756_M).append(" : ").append(biomeGenBase.field_76791_y).append(" (").append(biomeGenBase.func_150562_l()).append(")\n");
            ++BiomesManager.occupiedIds;
        }
        occupiedBiomeIDs = builder.toString();
        builder.setLength(0);
        System.out.println("Found " + BiomesManager.occupiedIds + " occupied biome ids in total.");
        for (BiomeGenBase biomeGenBase : BiomesManager.conflicts) {
            if (biomeGenBase == null) continue;
            if (debug) {
                System.out.println("Found biomes id conflict for " + biomeGenBase.ID + " : " + biomeGenBase.getCrashMessage());
            }
            builder.append(biomeGenBase.getCrashMessage()).append('\n');
            ++IconflictedIds;
        }
        conflictedIds = builder.toString();
        builder.setLength(0);
        System.out.println("Found " + IconflictedIds + " conflicted biome ids in total.");
        File available = new File(AntiIdConflictBase.biomesFolder, "availableIDs.txt");
        if (available.exists()) {
            available.delete();
        }
        available.createNewFile();
        PrintWriter writer = new PrintWriter(available);
        writer.println("Total amount of free biome ids: " + available);
        writer.println("List of free biome ids:");
        for (String freeID : freeIDs = freeBiomeIDs.split("\n")) {
            writer.println(freeID);
        }
        writer.close();
        File file = new File(AntiIdConflictBase.biomesFolder, "occupiedIDs.txt");
        if (file.exists()) {
            file.delete();
        }
        file.createNewFile();
        writer = new PrintWriter(file);
        writer.println("Total amount of occupied biome ids: " + BiomesManager.occupiedIds);
        writer.println("Table of occupied biome ids and their owners");
        writer.println("id:name(class)");
        for (String occupiedID : occupiedIDs = occupiedBiomeIDs.split("\n")) {
            writer.println(occupiedID);
        }
        writer.close();
        File conflicted = new File(AntiIdConflictBase.biomesFolder, "conflictedIDs.txt");
        if (conflicted.exists()) {
            conflicted.delete();
        }
        conflicted.createNewFile();
        writer = new PrintWriter(conflicted);
        writer.println("Total amount of conflicted biome ids: " + IconflictedIds);
        writer.println("IDs in conflict:\n");
        for (String conflictedID : conflictedIDs = conflictedIds.split("\n")) {
            writer.println(conflictedID);
        }
        writer.close();
        File all = new File(AntiIdConflictBase.biomesFolder, "AllIDs.txt");
        writer = new PrintWriter(all);
        writer.println("Total amount of free biome ids: " + BiomesManager.freeIds);
        writer.println("Total amount of occupied biome ids: " + BiomesManager.occupiedIds);
        writer.println("Total amount of conflicted biome ids: " + IconflictedIds);
        writer.println("All ids and their position:");
        hasEmpty = false;
        emptyRegionStart = 0;
        for (int i = 0; i < biomes.length; ++i) {
            if (!ArrayUtils.isEmpty((Object[])BiomesManager.conflicts) && BiomesManager.conflicts[i] != null) {
                writer.println(BiomesManager.conflicts[i].getCrashMessage());
                continue;
            }
            if (biomes[i] != null) {
                if (hasEmpty) {
                    hasEmpty = false;
                    for (String part : BiomesManagerMixin.getIntervalNaming(emptyRegionStart, i - 1)) {
                        writer.print(part);
                        writer.println(" is Available");
                    }
                }
                writer.print(i);
                writer.print(" is Occupied by ");
                writer.print(biomes[i].field_76791_y);
                writer.print(" (");
                writer.print(biomes[i].func_150562_l().getName());
                writer.println(")");
                continue;
            }
            if (hasEmpty) continue;
            hasEmpty = true;
            emptyRegionStart = i;
        }
        if (hasEmpty) {
            for (String part : BiomesManagerMixin.getIntervalNaming(emptyRegionStart, 65535)) {
                writer.print(part);
                writer.println(" is Available");
            }
        }
        writer.close();
    }
}

