/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.endlessids.asm.transformer;

import com.falsepattern.endlessids.asm.AsmTransformException;
import com.falsepattern.endlessids.asm.EndlessIDsTransformer;
import com.falsepattern.endlessids.config.GeneralConfig;
import com.falsepattern.lib.turboasm.ClassNodeHandle;
import com.falsepattern.lib.turboasm.TurboClassTransformer;
import java.util.ListIterator;
import org.jetbrains.annotations.NotNull;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public class GameDataAccelerator
implements TurboClassTransformer {
    private static final int MASK_REGISTER_BLOCK = 1;
    private static final int MASK_REGISTER_ITEM = 2;

    private void transformRegisterItem(MethodNode method) {
        ListIterator iter = method.instructions.iterator();
        while (iter.hasNext()) {
            AbstractInsnNode insn = (AbstractInsnNode)iter.next();
            if (!(insn instanceof FieldInsnNode)) continue;
            FieldInsnNode typeInsn = (FieldInsnNode)insn;
            if (!typeInsn.owner.equals("net/minecraft/item/ItemBlock") || !typeInsn.name.equals("field_150939_a") || !typeInsn.desc.equals("Lnet/minecraft/block/Block;")) continue;
            iter.previous();
            iter.add(new InsnNode(89));
            iter.add(new VarInsnNode(25, 0));
            iter.add(new MethodInsnNode(184, "com/falsepattern/endlessids/asm/GameDataHooks", "cacheItemBlock", "(Lnet/minecraft/item/ItemBlock;Lcpw/mods/fml/common/registry/GameData;)V", false));
            return;
        }
        GameDataAccelerator.transformError(method);
    }

    private static void transformError(MethodNode method) {
        EndlessIDsTransformer.logger.error("Could not add caching code to GameData." + method.name + method.desc);
    }

    private void transformRegisterBlock(MethodNode method) {
        ListIterator iter = method.instructions.iterator();
        while (iter.hasNext()) {
            AbstractInsnNode insn = (AbstractInsnNode)iter.next();
            if (insn.getOpcode() != 180 && !(insn instanceof FieldInsnNode)) continue;
            FieldInsnNode fieldInsn = (FieldInsnNode)insn;
            if (!fieldInsn.owner.equals("cpw/mods/fml/common/registry/GameData") || !fieldInsn.name.equals("iItemRegistry") || !fieldInsn.desc.equals("Lcpw/mods/fml/common/registry/FMLControlledNamespacedRegistry;")) continue;
            iter.remove();
            AbstractInsnNode testInsn = (AbstractInsnNode)iter.previous();
            if (testInsn.getOpcode() != 25 || ((VarInsnNode)testInsn).var != 0) {
                throw new AsmTransformException("Opcode assertion 1 failed!");
            }
            iter.remove();
            testInsn = (AbstractInsnNode)iter.next();
            if (testInsn.getOpcode() != 182) {
                throw new AsmTransformException("Opcodes assertion 2 failed!");
            }
            MethodInsnNode testInvoke = (MethodInsnNode)testInsn;
            if (!testInvoke.owner.equals("cpw/mods/fml/common/registry/FMLControlledNamespacedRegistry") || !testInvoke.name.equals("typeSafeIterable")) {
                throw new AsmTransformException("Opcodes assertion 3 failed!");
            }
            iter.remove();
            iter.add(new VarInsnNode(25, 1));
            iter.add(new VarInsnNode(25, 0));
            iter.add(new MethodInsnNode(184, "com/falsepattern/endlessids/asm/GameDataHooks", "fetchCachedItemBlock", "(Lnet/minecraft/block/Block;Lcpw/mods/fml/common/registry/GameData;)Lnet/minecraft/item/ItemBlock;", false));
            iter.add(new VarInsnNode(58, 4));
            iter.add(new MethodInsnNode(184, "com/falsepattern/endlessids/asm/GameDataHooks", "fakeIterable", "()Ljava/lang/Iterable;", false));
            return;
        }
        GameDataAccelerator.transformError(method);
    }

    public String owner() {
        return "EndlessIDs";
    }

    public String name() {
        return "GameDataAccelerator";
    }

    public boolean shouldTransformClass(@NotNull String className, @NotNull ClassNodeHandle classNode) {
        return GeneralConfig.enableRegistryPerformanceTweak && "cpw.mods.fml.common.registry.GameData".equals(className);
    }

    public boolean transformClass(@NotNull String className, @NotNull ClassNodeHandle classNode) {
        ClassNode cn = classNode.getNode();
        if (cn == null) {
            return false;
        }
        FieldNode cacheField = new FieldNode(4097, "endlessIDsItemBlockCache", "Lcom/falsepattern/endlessids/util/WeakIdentityHashMap;", null, null);
        cn.fields.add(cacheField);
        int tweaksLeft = 3;
        for (MethodNode method : cn.methods) {
            if ((tweaksLeft & 1) != 0 && method.name.equals("registerBlock") && method.desc.equals("(Lnet/minecraft/block/Block;Ljava/lang/String;I)I")) {
                this.transformRegisterBlock(method);
                tweaksLeft &= 0xFFFFFFFE;
            } else if ((tweaksLeft & 2) != 0 && method.name.equals("registerItem") && method.desc.equals("(Lnet/minecraft/item/Item;Ljava/lang/String;I)I")) {
                this.transformRegisterItem(method);
                tweaksLeft &= 0xFFFFFFFD;
            }
            if (tweaksLeft != 0) continue;
            return true;
        }
        throw new AsmTransformException("Failed to accelerate block registration! Disable enableRegistryPerformanceTweak in the EndlessIDs config!");
    }
}

