/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.endlessids.asm.transformer;

import com.falsepattern.endlessids.asm.EndlessIDsCore;
import com.falsepattern.lib.turboasm.ClassNodeHandle;
import com.falsepattern.lib.turboasm.TurboClassTransformer;
import java.io.IOException;
import net.minecraft.launchwrapper.Launch;
import org.jetbrains.annotations.NotNull;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.MethodNode;

public class DevFixer
implements TurboClassTransformer {
    private static final ClassNode blocks;

    private static boolean biomeTweakerCompat(ClassNode cn) {
        boolean modified = false;
        for (FieldNode field : cn.fields) {
            if (!field.name.startsWith("spawnable")) continue;
            field.access &= 0xFFFFFFFB;
            field.access |= 1;
            modified = true;
        }
        return modified;
    }

    private static boolean remapBlocks(ClassNode cn) {
        boolean modified = false;
        for (MethodNode method : cn.methods) {
            InsnList instructions = method.instructions;
            int insnCount = instructions.size();
            for (int i = 0; i < insnCount; ++i) {
                FieldInsnNode field;
                AbstractInsnNode insn = instructions.get(i);
                if (!(insn instanceof FieldInsnNode) || (field = (FieldInsnNode)insn).getOpcode() != 178 || !field.owner.equals("net/minecraft/init/Blocks")) continue;
                for (FieldNode blockField : DevFixer.blocks.fields) {
                    if (!blockField.name.equals(field.name) || blockField.desc.equals(field.desc)) continue;
                    field.desc = blockField.desc;
                    modified = true;
                }
            }
        }
        return modified;
    }

    public String owner() {
        return "EndlessIDs";
    }

    public String name() {
        return "DevFixer";
    }

    public boolean shouldTransformClass(@NotNull String className, @NotNull ClassNodeHandle classNode) {
        return EndlessIDsCore.deobfuscated && !"net.minecraft.world.chunk.storage.AnvilChunkLoader".equals(className);
    }

    public boolean transformClass(@NotNull String className, @NotNull ClassNodeHandle classNode) {
        ClassNode cn = classNode.getNode();
        if (cn == null) {
            return false;
        }
        boolean modified = false;
        modified |= DevFixer.remapBlocks(cn);
        if (className.equals("net.minecraft.world.biome.BiomeGenBase")) {
            modified |= DevFixer.biomeTweakerCompat(cn);
        }
        return modified;
    }

    static {
        if (!EndlessIDsCore.deobfuscated) {
            blocks = null;
        } else {
            try {
                byte[] blox = Launch.classLoader.getClassBytes("net/minecraft/init/Blocks");
                blocks = new ClassNode(327680);
                ClassReader reader = new ClassReader(blox);
                reader.accept((ClassVisitor)blocks, 0);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

