/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.endlessids.asm;

import com.falsepattern.endlessids.util.WeakIdentityHashMap;
import cpw.mods.fml.common.registry.GameData;
import java.lang.ref.WeakReference;
import java.util.Collections;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;

public class GameDataHooks {
    private static WeakIdentityHashMap<Block, WeakReference<ItemBlock>> forGameData(GameData gameData) {
        if (gameData.endlessIDsItemBlockCache == null) {
            gameData.endlessIDsItemBlockCache = new WeakIdentityHashMap();
        }
        return gameData.endlessIDsItemBlockCache;
    }

    public static void cacheItemBlock(ItemBlock itemBlock, GameData gameData) {
        GameDataHooks.forGameData(gameData).put(itemBlock.field_150939_a, new WeakReference<ItemBlock>(itemBlock));
    }

    public static ItemBlock fetchCachedItemBlock(Block block, GameData gameData) {
        WeakReference<ItemBlock> weakItem = GameDataHooks.forGameData(gameData).get(block);
        if (weakItem != null) {
            return (ItemBlock)weakItem.get();
        }
        return null;
    }

    public static Iterable<Item> fakeIterable() {
        return Collections.emptyList();
    }
}

