/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.endlessids;

import com.falsepattern.chunk.api.DataManager;
import com.falsepattern.chunk.api.DataRegistry;
import com.falsepattern.endlessids.config.GeneralConfig;
import com.falsepattern.endlessids.managers.BiomeManager;
import com.falsepattern.endlessids.managers.BlockIDManager;
import com.falsepattern.endlessids.managers.BlockMetaManager;
import com.falsepattern.endlessids.patching.CommonManager;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLConstructionEvent;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="endlessids", version="1.6.14", name="EndlessIDs", acceptedMinecraftVersions="[1.7.10]", dependencies="required-after:chunkapi@[0.6.4,);required-after:falsepatternlib@[1.9.0,);after:antiidconflict")
public class EndlessIDs {
    public static final byte[] ZERO_LENGTH_BIOME_ARRAY_PLACEHOLDER = new byte[0];
    public static final byte[] FAKE_BIOME_ARRAY_PLACEHOLDER = new byte[256];
    public static final Logger LOG = LogManager.getLogger((String)"EndlessIDs");
    @SidedProxy(clientSide="com.falsepattern.endlessids.patching.ClientManager", serverSide="com.falsepattern.endlessids.patching.ServerManager", modId="endlessids")
    private static CommonManager patchManager;

    @Mod.EventHandler
    public void construct(FMLConstructionEvent e) {
        patchManager.construct();
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent e) {
        LOG.info("---------------------------------------------------------");
        LOG.info("Current EndlessIDs configuration:");
        EndlessIDs.logConfig("  Biome Extension", GeneralConfig.extendBiome);
        EndlessIDs.logConfig("  Block/Item Extension", GeneralConfig.extendBlockItem);
        if (GeneralConfig.extendBlockItem) {
            EndlessIDs.logConfig("    Extra Item Bits", GeneralConfig.extraItemIDBits);
            EndlessIDs.logConfig("    Extra Block Bits", GeneralConfig.extraBlockIDBits);
        }
        EndlessIDs.logConfig("  DataWatcher Extension", GeneralConfig.extendDataWatcher);
        EndlessIDs.logConfig("  Enchantment Extension", GeneralConfig.extendEnchantment);
        EndlessIDs.logConfig("  Potion Extension", GeneralConfig.extendPotion);
        EndlessIDs.logConfig("  Redstone Extension", GeneralConfig.extendRedstone);
        if (GeneralConfig.extendRedstone) {
            LOG.warn("    (Redstone extension is an experimental and dangerous feature, and should NEVER be used in worlds that you worry about getting corrupted!)");
            EndlessIDs.logConfig("    Max redstone level", GeneralConfig.maxRedstone);
        }
        EndlessIDs.logConfig("  Registry performance tweak", GeneralConfig.enableRegistryPerformanceTweak);
        if (GeneralConfig.enableRegistryPerformanceTweak) {
            LOG.warn("    (This tweak has not gone through proper testing yet, so it might corrupt worlds. USE BACKUPS!)");
        }
        LOG.info("---------------------------------------------------------");
        patchManager.preInit();
    }

    private static void logConfig(String name, boolean value) {
        LOG.info(name + (value ? ": ENABLED" : ": disabled"));
    }

    private static void logConfig(String name, int value) {
        LOG.info(name + ": " + value);
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent e) {
        patchManager.init();
        if (GeneralConfig.extendBiome) {
            DataRegistry.registerDataManager((DataManager)new BiomeManager());
        }
        if (GeneralConfig.extendBlockItem) {
            DataRegistry.registerDataManager((DataManager)new BlockIDManager());
            DataRegistry.registerDataManager((DataManager)new BlockMetaManager());
        }
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent e) {
        patchManager.postInit();
        if (GeneralConfig.extendBiome) {
            DataRegistry.disableDataManager((String)"minecraft", (String)"biome");
        }
        if (GeneralConfig.extendBlockItem) {
            DataRegistry.disableDataManager((String)"minecraft", (String)"blockid");
            DataRegistry.disableDataManager((String)"minecraft", (String)"metadata");
        }
    }
}

