/*
 * Decompiled with CFR 0.152.
 */
package mods.octarinecore.client.resource;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import mods.octarinecore.client.resource.ParameterList;
import mods.octarinecore.client.resource.ResourceType;
import mods.octarinecore.client.resource.TextureGenerator;
import mods.octarinecore.client.resource.Utils;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0012\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\n\u00a8\u0006\u0010"}, d2={"Lmods/octarinecore/client/resource/CenteringTextureGenerator;", "Lmods/octarinecore/client/resource/TextureGenerator;", "domain", "", "aspectWidth", "", "aspectHeight", "<init>", "(Ljava/lang/String;II)V", "getAspectWidth", "()I", "getAspectHeight", "generate", "Ljava/awt/image/BufferedImage;", "params", "Lmods/octarinecore/client/resource/ParameterList;", "BetterFoliage-LegacyEdition"})
public final class CenteringTextureGenerator
extends TextureGenerator {
    private final int aspectWidth;
    private final int aspectHeight;

    public CenteringTextureGenerator(@NotNull String domain, int aspectWidth, int aspectHeight) {
        Intrinsics.checkNotNullParameter((Object)domain, (String)"domain");
        super(domain);
        this.aspectWidth = aspectWidth;
        this.aspectHeight = aspectHeight;
    }

    public final int getAspectWidth() {
        return this.aspectWidth;
    }

    public final int getAspectHeight() {
        return this.aspectHeight;
    }

    @Override
    @Nullable
    public BufferedImage generate(@NotNull ParameterList params) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        Pair<ResourceType, ResourceLocation> pair = this.targetResource(params);
        Intrinsics.checkNotNull(pair);
        Pair<ResourceType, ResourceLocation> target = pair;
        Object object = Utils.get((IResourceManager)Utils.getResourceManager(), (ResourceLocation)target.getSecond());
        if (object == null || (object = Utils.loadImage((IResource)object)) == null) {
            return null;
        }
        Object baseTexture = object;
        int frameWidth = ((BufferedImage)baseTexture).getWidth();
        int frameHeight = ((BufferedImage)baseTexture).getWidth() * this.aspectHeight / this.aspectWidth;
        int frames = ((BufferedImage)baseTexture).getHeight() / frameHeight;
        int size = Math.max(frameWidth, frameHeight);
        BufferedImage resultTexture = new BufferedImage(size, size * frames, 6);
        Graphics2D graphics = resultTexture.createGraphics();
        for (int frame = 0; frame < frames; ++frame) {
            Graphics2D graphics2D;
            BufferedImage baseFrame = ((BufferedImage)baseTexture).getSubimage(0, size * frame, frameWidth, frameHeight);
            BufferedImage resultFrame = new BufferedImage(size, size, 6);
            Graphics2D $this$generate_u24lambda_u240 = graphics2D = resultFrame.createGraphics();
            boolean bl = false;
            $this$generate_u24lambda_u240.drawImage((Image)baseFrame, (size - frameWidth) / 2, (size - frameHeight) / 2, null);
            graphics.drawImage((Image)resultFrame, 0, size * frame, null);
        }
        return resultTexture;
    }
}

