/*
 * Decompiled with CFR 0.152.
 */
package mods.octarinecore.client.render;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import mods.octarinecore.client.render.Double3;
import mods.octarinecore.client.render.Rotation;
import mods.octarinecore.client.render.Vertex;
import net.minecraft.util.IIcon;
import net.minecraftforge.common.util.ForgeDirection;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0011\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010(\u001a\u00020\u00002\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.J\u000e\u0010(\u001a\u00020\u00002\u0006\u0010)\u001a\u00020*J\u000e\u0010/\u001a\u00020\u00002\u0006\u0010-\u001a\u00020.J\u000e\u00100\u001a\u00020\u00002\u0006\u0010+\u001a\u00020,J\u0011\u00101\u001a\u00020\u00002\u0006\u00102\u001a\u00020\u0017H\u0086\bJ\u0011\u00103\u001a\u00020\u00002\u0006\u00104\u001a\u000205H\u0086\bJ\u0011\u00106\u001a\u0002072\u0006\u00108\u001a\u00020\u001dH\u0086\bJ\u0011\u00109\u001a\u0002072\u0006\u0010:\u001a\u00020\u0017H\u0086\bJ\u0011\u0010;\u001a\u0002072\u0006\u0010:\u001a\u00020\u0017H\u0086\bR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\u0007\"\u0004\b\f\u0010\tR\u001a\u0010\r\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u0007\"\u0004\b\u000f\u0010\tR\u001a\u0010\u0010\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0007\"\u0004\b\u0012\u0010\tR\u001a\u0010\u0013\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0007\"\u0004\b\u0015\u0010\tR\u001a\u0010\u0016\u001a\u00020\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u001a\u0010\u001c\u001a\u00020\u001dX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u001a\u0010\"\u001a\u00020\u001dX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010\u001f\"\u0004\b$\u0010!R\u001a\u0010%\u001a\u00020\u001dX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010\u001f\"\u0004\b'\u0010!\u00a8\u0006<"}, d2={"Lmods/octarinecore/client/render/RenderVertex;", "", "<init>", "()V", "x", "", "getX", "()D", "setX", "(D)V", "y", "getY", "setY", "z", "getZ", "setZ", "u", "getU", "setU", "v", "getV", "setV", "brightness", "", "getBrightness", "()I", "setBrightness", "(I)V", "red", "", "getRed", "()F", "setRed", "(F)V", "green", "getGreen", "setGreen", "blue", "getBlue", "setBlue", "init", "vertex", "Lmods/octarinecore/client/render/Vertex;", "rot", "Lmods/octarinecore/client/render/Rotation;", "trans", "Lmods/octarinecore/client/render/Double3;", "translate", "rotate", "rotateUV", "n", "setIcon", "icon", "Lnet/minecraft/util/IIcon;", "setGrey", "", "level", "multiplyColor", "color", "setColor", "BetterFoliage-LegacyEdition"})
@SourceDebugExtension(value={"SMAP\nModelRenderer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ModelRenderer.kt\nmods/octarinecore/client/render/RenderVertex\n+ 2 Geometry.kt\nmods/octarinecore/client/render/Rotation\n*L\n1#1,174:1\n302#2,9:175\n302#2,9:184\n302#2,9:193\n*S KotlinDebug\n*F\n+ 1 ModelRenderer.kt\nmods/octarinecore/client/render/RenderVertex\n*L\n116#1:175,9\n117#1:184,9\n118#1:193,9\n*E\n"})
public final class RenderVertex {
    private double x;
    private double y;
    private double z;
    private double u;
    private double v;
    private int brightness;
    private float red;
    private float green;
    private float blue;

    public final double getX() {
        return this.x;
    }

    public final void setX(double d) {
        this.x = d;
    }

    public final double getY() {
        return this.y;
    }

    public final void setY(double d) {
        this.y = d;
    }

    public final double getZ() {
        return this.z;
    }

    public final void setZ(double d) {
        this.z = d;
    }

    public final double getU() {
        return this.u;
    }

    public final void setU(double d) {
        this.u = d;
    }

    public final double getV() {
        return this.v;
    }

    public final void setV(double d) {
        this.v = d;
    }

    public final int getBrightness() {
        return this.brightness;
    }

    public final void setBrightness(int n) {
        this.brightness = n;
    }

    public final float getRed() {
        return this.red;
    }

    public final void setRed(float f) {
        this.red = f;
    }

    public final float getGreen() {
        return this.green;
    }

    public final void setGreen(float f) {
        this.green = f;
    }

    public final float getBlue() {
        return this.blue;
    }

    public final void setBlue(float f) {
        this.blue = f;
    }

    @NotNull
    public final RenderVertex init(@NotNull Vertex vertex, @NotNull Rotation rot, @NotNull Double3 trans) {
        Intrinsics.checkNotNullParameter((Object)vertex, (String)"vertex");
        Intrinsics.checkNotNullParameter((Object)rot, (String)"rot");
        Intrinsics.checkNotNullParameter((Object)trans, (String)"trans");
        Double3 result = vertex.getXyz().rotate(rot).plus(trans);
        this.x = result.getX();
        this.y = result.getY();
        this.z = result.getZ();
        return this;
    }

    @NotNull
    public final RenderVertex init(@NotNull Vertex vertex) {
        Intrinsics.checkNotNullParameter((Object)vertex, (String)"vertex");
        this.x = vertex.getXyz().getX();
        this.y = vertex.getXyz().getY();
        this.z = vertex.getXyz().getZ();
        this.u = vertex.getUv().getU();
        this.v = vertex.getUv().getV();
        return this;
    }

    @NotNull
    public final RenderVertex translate(@NotNull Double3 trans) {
        Intrinsics.checkNotNullParameter((Object)trans, (String)"trans");
        this.x += trans.getX();
        this.y += trans.getY();
        this.z += trans.getZ();
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final RenderVertex rotate(@NotNull Rotation rot) {
        double d;
        void dir$iv;
        void this_$iv;
        double y$iv;
        double d2;
        void dir$iv2;
        void this_$iv2;
        double y$iv2;
        double d3;
        void dir$iv3;
        void this_$iv3;
        Intrinsics.checkNotNullParameter((Object)rot, (String)"rot");
        if (rot == Rotation.Companion.getIdentity()) {
            return this;
        }
        Rotation rotation = rot;
        ForgeDirection forgeDirection = ForgeDirection.EAST;
        double d4 = this.x;
        double d5 = this.y;
        double z$iv = this.z;
        boolean $i$f$rotatedComponent = false;
        switch (Rotation.WhenMappings.$EnumSwitchMapping$0[this_$iv3.getReverse()[dir$iv3.ordinal()].ordinal()]) {
            case 1: {
                void x$iv;
                d3 = x$iv;
                break;
            }
            case 2: {
                void x$iv;
                d3 = -x$iv;
                break;
            }
            case 3: {
                d3 = y$iv2;
                break;
            }
            case 4: {
                d3 = -y$iv2;
                break;
            }
            case 5: {
                d3 = z$iv;
                break;
            }
            case 6: {
                d3 = -z$iv;
                break;
            }
            default: {
                d3 = 0.0;
            }
        }
        double rotX = d3;
        Rotation x$iv = rot;
        ForgeDirection forgeDirection2 = ForgeDirection.UP;
        y$iv2 = this.x;
        z$iv = this.y;
        double z$iv2 = this.z;
        boolean $i$f$rotatedComponent2 = false;
        switch (Rotation.WhenMappings.$EnumSwitchMapping$0[this_$iv2.getReverse()[dir$iv2.ordinal()].ordinal()]) {
            case 1: {
                void x$iv2;
                d2 = x$iv2;
                break;
            }
            case 2: {
                void x$iv2;
                d2 = -x$iv2;
                break;
            }
            case 3: {
                d2 = y$iv;
                break;
            }
            case 4: {
                d2 = -y$iv;
                break;
            }
            case 5: {
                d2 = z$iv2;
                break;
            }
            case 6: {
                d2 = -z$iv2;
                break;
            }
            default: {
                d2 = 0.0;
            }
        }
        double rotY = d2;
        Rotation x$iv2 = rot;
        ForgeDirection forgeDirection3 = ForgeDirection.SOUTH;
        y$iv = this.x;
        z$iv2 = this.y;
        double z$iv3 = this.z;
        boolean $i$f$rotatedComponent3 = false;
        switch (Rotation.WhenMappings.$EnumSwitchMapping$0[this_$iv.getReverse()[dir$iv.ordinal()].ordinal()]) {
            case 1: {
                void x$iv3;
                d = x$iv3;
                break;
            }
            case 2: {
                void x$iv3;
                d = -x$iv3;
                break;
            }
            case 3: {
                void y$iv3;
                d = y$iv3;
                break;
            }
            case 4: {
                void y$iv3;
                d = -y$iv3;
                break;
            }
            case 5: {
                d = z$iv3;
                break;
            }
            case 6: {
                d = -z$iv3;
                break;
            }
            default: {
                d = 0.0;
            }
        }
        double rotZ = d;
        this.x = rotX;
        this.y = rotY;
        this.z = rotZ;
        return this;
    }

    @NotNull
    public final RenderVertex rotateUV(int n) {
        boolean $i$f$rotateUV = false;
        switch (n % 4) {
            case 1: {
                double t = this.getV();
                this.setV(-this.getU());
                this.setU(t);
                return this;
            }
            case 2: {
                this.setU(-this.getU());
                this.setV(-this.getV());
                return this;
            }
            case 3: {
                double t = -this.getV();
                this.setV(this.getU());
                this.setU(t);
                return this;
            }
        }
        return this;
    }

    @NotNull
    public final RenderVertex setIcon(@NotNull IIcon icon) {
        Intrinsics.checkNotNullParameter((Object)icon, (String)"icon");
        boolean $i$f$setIcon = false;
        this.setU((double)(icon.func_94212_f() - icon.func_94209_e()) * (this.getU() + 0.5) + (double)icon.func_94209_e());
        this.setV((double)(icon.func_94210_h() - icon.func_94206_g()) * (this.getV() + 0.5) + (double)icon.func_94206_g());
        return this;
    }

    public final void setGrey(float level) {
        boolean $i$f$setGrey = false;
        float grey = Math.min((this.getRed() + this.getGreen() + this.getBlue()) * 0.333f * level, 1.0f);
        this.setRed(grey);
        this.setGreen(grey);
        this.setBlue(grey);
    }

    public final void multiplyColor(int color) {
        boolean $i$f$multiplyColor = false;
        this.setRed(this.getRed() * ((float)(color >> 16 & 0xFF) / 256.0f));
        this.setGreen(this.getGreen() * ((float)(color >> 8 & 0xFF) / 256.0f));
        this.setBlue(this.getBlue() * ((float)(color & 0xFF) / 256.0f));
    }

    public final void setColor(int color) {
        boolean $i$f$setColor = false;
        this.setRed((float)(color >> 16 & 0xFF) / 256.0f);
        this.setGreen((float)(color >> 8 & 0xFF) / 256.0f);
        this.setBlue((float)(color & 0xFF) / 256.0f);
    }
}

