/*
 * Decompiled with CFR 0.152.
 */
package mods.octarinecore.client.render;

import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import mods.octarinecore.client.render.AoData;
import mods.octarinecore.client.render.Axis;
import mods.octarinecore.client.render.Dir;
import mods.octarinecore.client.render.GeometryKt;
import mods.octarinecore.client.render.Int3;
import mods.octarinecore.client.render.PixelFormat;
import mods.octarinecore.client.render.RenderVertex;
import mods.octarinecore.client.render.Rotation;
import mods.octarinecore.client.render.Shader;
import mods.octarinecore.client.render.ShadingContext;
import net.minecraftforge.common.util.ForgeDirection;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0007\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0018\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0016J\u0010\u0010$\u001a\u00020\u00002\u0006\u0010%\u001a\u00020&H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0016\u001a\u00020\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u001a\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0011R\u0011\u0010\u001c\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u0011\u00a8\u0006'"}, d2={"Lmods/octarinecore/client/render/EdgeInterpolateFallback;", "Lmods/octarinecore/client/render/Shader;", "face", "Lnet/minecraftforge/common/util/ForgeDirection;", "edgeDir", "pos", "", "fallbackDimming", "", "<init>", "(Lnet/minecraftforge/common/util/ForgeDirection;Lnet/minecraftforge/common/util/ForgeDirection;DF)V", "getFace", "()Lnet/minecraftforge/common/util/ForgeDirection;", "getEdgeDir", "getPos", "()D", "getFallbackDimming", "()F", "offset", "Lmods/octarinecore/client/render/Int3;", "getOffset", "()Lmods/octarinecore/client/render/Int3;", "edgeAxis", "Lmods/octarinecore/client/render/Axis;", "getEdgeAxis", "()Lmods/octarinecore/client/render/Axis;", "weightN", "getWeightN", "weightP", "getWeightP", "shade", "", "context", "Lmods/octarinecore/client/render/ShadingContext;", "vertex", "Lmods/octarinecore/client/render/RenderVertex;", "rotate", "rot", "Lmods/octarinecore/client/render/Rotation;", "BetterFoliage-LegacyEdition"})
@SourceDebugExtension(value={"SMAP\nShaders.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Shaders.kt\nmods/octarinecore/client/render/EdgeInterpolateFallback\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,208:1\n1#2:209\n*E\n"})
public final class EdgeInterpolateFallback
implements Shader {
    @NotNull
    private final ForgeDirection face;
    @NotNull
    private final ForgeDirection edgeDir;
    private final double pos;
    private final float fallbackDimming;
    @NotNull
    private final Int3 offset;
    @NotNull
    private final Axis edgeAxis;
    private final float weightN;
    private final float weightP;

    public EdgeInterpolateFallback(@NotNull ForgeDirection face, @NotNull ForgeDirection edgeDir, double pos, float fallbackDimming) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter((Object)face, (String)"face");
            Intrinsics.checkNotNullParameter((Object)edgeDir, (String)"edgeDir");
            this.face = face;
            this.edgeDir = edgeDir;
            this.pos = pos;
            this.fallbackDimming = fallbackDimming;
            this.offset = new Int3(this.edgeDir);
            Iterable iterable = GeometryKt.getAxes();
            EdgeInterpolateFallback edgeInterpolateFallback = this;
            Iterable iterable2 = iterable;
            for (Object t : iterable2) {
                Axis it = (Axis)((Object)t);
                boolean bl = false;
                if (!(it != GeometryKt.getAxis(this.face) && it != GeometryKt.getAxis(this.edgeDir))) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        Intrinsics.checkNotNull(v0);
        edgeInterpolateFallback.edgeAxis = v0;
        this.weightN = (float)(0.5 - this.pos);
        this.weightP = (float)(0.5 + this.pos);
    }

    public /* synthetic */ EdgeInterpolateFallback(ForgeDirection forgeDirection, ForgeDirection forgeDirection2, double d, float f, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            f = 0.8f;
        }
        this(forgeDirection, forgeDirection2, d, f);
    }

    @NotNull
    public final ForgeDirection getFace() {
        return this.face;
    }

    @NotNull
    public final ForgeDirection getEdgeDir() {
        return this.edgeDir;
    }

    public final double getPos() {
        return this.pos;
    }

    public final float getFallbackDimming() {
        return this.fallbackDimming;
    }

    @NotNull
    public final Int3 getOffset() {
        return this.offset;
    }

    @NotNull
    public final Axis getEdgeAxis() {
        return this.edgeAxis;
    }

    public final float getWeightN() {
        return this.weightN;
    }

    public final float getWeightP() {
        return this.weightP;
    }

    @Override
    public void shade(@NotNull ShadingContext context, @NotNull RenderVertex vertex) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)vertex, (String)"vertex");
        AoData shadingP = context.aoShading(this.face, this.edgeDir, GeometryKt.getFace((Pair<? extends Axis, ? extends Dir>)TuplesKt.to((Object)((Object)this.edgeAxis), (Object)((Object)Dir.P))));
        AoData shadingN = context.aoShading(this.face, this.edgeDir, GeometryKt.getFace((Pair<? extends Axis, ? extends Dir>)TuplesKt.to((Object)((Object)this.edgeAxis), (Object)((Object)Dir.N))));
        if (!shadingP.getValid() && !shadingN.getValid()) {
            this.shade(vertex, PixelFormat.brMul(context.blockBrightness(this.offset), this.fallbackDimming), PixelFormat.colorMul(context.blockColor(this.offset), this.fallbackDimming));
            return;
        }
        if (!shadingP.getValid()) {
            this.shade(vertex, shadingN);
            return;
        }
        if (!shadingN.getValid()) {
            this.shade(vertex, shadingP);
            return;
        }
        this.shade(vertex, shadingP, shadingN, this.weightP, this.weightN);
    }

    @Override
    @NotNull
    public EdgeInterpolateFallback rotate(@NotNull Rotation rot) {
        Intrinsics.checkNotNullParameter((Object)rot, (String)"rot");
        return new EdgeInterpolateFallback(GeometryKt.rotate(this.face, rot), GeometryKt.rotate(this.edgeDir, rot), this.pos, 0.0f, 8, null);
    }

    @Override
    public void shade(@NotNull RenderVertex $this$shade, @NotNull AoData shading) {
        Shader.DefaultImpls.shade(this, $this$shade, shading);
    }

    @Override
    public void shade(@NotNull RenderVertex $this$shade, @NotNull AoData shading1, @NotNull AoData shading2, float weight1, float weight2) {
        Shader.DefaultImpls.shade(this, $this$shade, shading1, shading2, weight1, weight2);
    }

    @Override
    public void shade(@NotNull RenderVertex $this$shade, int brightness, int color) {
        Shader.DefaultImpls.shade(this, $this$shade, brightness, color);
    }
}

