/*
 * Decompiled with CFR 0.152.
 */
package mods.octarinecore.client.render;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import mods.octarinecore.client.render.AoData;
import mods.octarinecore.client.render.GeometryKt;
import mods.octarinecore.client.render.Int3;
import mods.octarinecore.client.render.PixelFormat;
import mods.octarinecore.client.render.RenderVertex;
import mods.octarinecore.client.render.Rotation;
import mods.octarinecore.client.render.Shader;
import mods.octarinecore.client.render.ShadingContext;
import net.minecraftforge.common.util.ForgeDirection;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B9\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\b\b\u0002\u0010\t\u001a\u00020\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0010\u0010\u001e\u001a\u00020\u00002\u0006\u0010\u001f\u001a\u00020 H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0011R\u0011\u0010\t\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0011R\u0011\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006!"}, d2={"Lmods/octarinecore/client/render/CornerInterpolateDimming;", "Lmods/octarinecore/client/render/Shader;", "face1", "Lnet/minecraftforge/common/util/ForgeDirection;", "face2", "edgeDir", "weight", "", "dimming", "fallbackDimming", "<init>", "(Lnet/minecraftforge/common/util/ForgeDirection;Lnet/minecraftforge/common/util/ForgeDirection;Lnet/minecraftforge/common/util/ForgeDirection;FFF)V", "getFace1", "()Lnet/minecraftforge/common/util/ForgeDirection;", "getFace2", "getEdgeDir", "getWeight", "()F", "getDimming", "getFallbackDimming", "offset", "Lmods/octarinecore/client/render/Int3;", "getOffset", "()Lmods/octarinecore/client/render/Int3;", "shade", "", "context", "Lmods/octarinecore/client/render/ShadingContext;", "vertex", "Lmods/octarinecore/client/render/RenderVertex;", "rotate", "rot", "Lmods/octarinecore/client/render/Rotation;", "BetterFoliage-LegacyEdition"})
public final class CornerInterpolateDimming
implements Shader {
    @NotNull
    private final ForgeDirection face1;
    @NotNull
    private final ForgeDirection face2;
    @NotNull
    private final ForgeDirection edgeDir;
    private final float weight;
    private final float dimming;
    private final float fallbackDimming;
    @NotNull
    private final Int3 offset;

    public CornerInterpolateDimming(@NotNull ForgeDirection face1, @NotNull ForgeDirection face2, @NotNull ForgeDirection edgeDir, float weight, float dimming, float fallbackDimming) {
        Intrinsics.checkNotNullParameter((Object)face1, (String)"face1");
        Intrinsics.checkNotNullParameter((Object)face2, (String)"face2");
        Intrinsics.checkNotNullParameter((Object)edgeDir, (String)"edgeDir");
        this.face1 = face1;
        this.face2 = face2;
        this.edgeDir = edgeDir;
        this.weight = weight;
        this.dimming = dimming;
        this.fallbackDimming = fallbackDimming;
        this.offset = new Int3(this.edgeDir);
    }

    public /* synthetic */ CornerInterpolateDimming(ForgeDirection forgeDirection, ForgeDirection forgeDirection2, ForgeDirection forgeDirection3, float f, float f2, float f3, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x20) != 0) {
            f3 = 0.5f;
        }
        this(forgeDirection, forgeDirection2, forgeDirection3, f, f2, f3);
    }

    @NotNull
    public final ForgeDirection getFace1() {
        return this.face1;
    }

    @NotNull
    public final ForgeDirection getFace2() {
        return this.face2;
    }

    @NotNull
    public final ForgeDirection getEdgeDir() {
        return this.edgeDir;
    }

    public final float getWeight() {
        return this.weight;
    }

    public final float getDimming() {
        return this.dimming;
    }

    public final float getFallbackDimming() {
        return this.fallbackDimming;
    }

    @NotNull
    public final Int3 getOffset() {
        return this.offset;
    }

    @Override
    public void shade(@NotNull ShadingContext context, @NotNull RenderVertex vertex) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)vertex, (String)"vertex");
        AoData shading1 = context.aoShading(this.face1, this.edgeDir, this.face2);
        AoData shading2 = context.aoShading(this.face2, this.edgeDir, this.face1);
        float weight1 = this.weight;
        float weight2 = 1.0f - this.weight;
        if (!shading1.getValid() && !shading2.getValid()) {
            this.shade(vertex, PixelFormat.brMul(context.blockBrightness(this.offset), this.fallbackDimming), PixelFormat.colorMul(context.blockColor(this.offset), this.fallbackDimming));
            return;
        }
        if (!shading1.getValid()) {
            shading1 = shading2;
            weight1 *= this.dimming;
        }
        if (!shading2.getValid()) {
            shading2 = shading1;
            weight2 *= this.dimming;
        }
        this.shade(vertex, shading1, shading2, weight1, weight2);
    }

    @Override
    @NotNull
    public CornerInterpolateDimming rotate(@NotNull Rotation rot) {
        Intrinsics.checkNotNullParameter((Object)rot, (String)"rot");
        return new CornerInterpolateDimming(GeometryKt.rotate(this.face1, rot), GeometryKt.rotate(this.face2, rot), GeometryKt.rotate(this.edgeDir, rot), this.weight, this.dimming, this.fallbackDimming);
    }

    @Override
    public void shade(@NotNull RenderVertex $this$shade, @NotNull AoData shading) {
        Shader.DefaultImpls.shade(this, $this$shade, shading);
    }

    @Override
    public void shade(@NotNull RenderVertex $this$shade, @NotNull AoData shading1, @NotNull AoData shading2, float weight1, float weight2) {
        Shader.DefaultImpls.shade(this, $this$shade, shading1, shading2, weight1, weight2);
    }

    @Override
    public void shade(@NotNull RenderVertex $this$shade, int brightness, int color) {
        Shader.DefaultImpls.shade(this, $this$shade, brightness, color);
    }
}

