/*
 * Decompiled with CFR 0.152.
 */
package mods.betterfoliage.client.texture;

import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import mods.betterfoliage.client.Client;
import mods.betterfoliage.client.config.BlockMatcher;
import mods.betterfoliage.client.config.Config;
import mods.betterfoliage.client.integration.ForestryIntegration;
import mods.betterfoliage.client.integration.GT6Integration;
import mods.betterfoliage.client.integration.OptifineCTM;
import mods.betterfoliage.client.texture.LeafGenerator;
import mods.betterfoliage.client.texture.LeafInfo;
import mods.betterfoliage.client.texture.TextureMatcher;
import mods.octarinecore.client.resource.IconSet;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.util.IIcon;
import net.minecraft.util.RegistryNamespaced;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.common.MinecraftForge;
import org.apache.logging.log4j.Level;
import org.jetbrains.annotations.NotNull;

@SideOnly(value=Side.CLIENT)
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0007J\u0016\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aJ\u0016\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u001c\u001a\u00020\u000bR\u001d\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001d\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\tR\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001d"}, d2={"Lmods/betterfoliage/client/texture/LeafRegistry;", "", "<init>", "()V", "leaves", "", "Lnet/minecraft/util/IIcon;", "Lmods/betterfoliage/client/texture/LeafInfo;", "getLeaves", "()Ljava/util/Map;", "particles", "", "Lmods/octarinecore/client/resource/IconSet;", "getParticles", "typeMappings", "Lmods/betterfoliage/client/texture/TextureMatcher;", "getTypeMappings", "()Lmods/betterfoliage/client/texture/TextureMatcher;", "handleTextureReload", "", "event", "Lnet/minecraftforge/client/event/TextureStitchEvent$Pre;", "registerLeaf", "atlas", "Lnet/minecraft/client/renderer/texture/TextureMap;", "icon", "Lnet/minecraft/client/renderer/texture/TextureAtlasSprite;", "registerParticle", "leafType", "BetterFoliage-LegacyEdition"})
@SourceDebugExtension(value={"SMAP\nLeafRegistry.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LeafRegistry.kt\nmods/betterfoliage/client/texture/LeafRegistry\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,126:1\n1863#2:127\n1863#2,2:128\n1864#2:130\n1863#2,2:131\n*S KotlinDebug\n*F\n+ 1 LeafRegistry.kt\nmods/betterfoliage/client/texture/LeafRegistry\n*L\n68#1:127\n93#1:128,2\n68#1:130\n79#1:131,2\n*E\n"})
public final class LeafRegistry {
    @NotNull
    public static final LeafRegistry INSTANCE = new LeafRegistry();
    @NotNull
    private static final Map<IIcon, LeafInfo> leaves = new HashMap();
    @NotNull
    private static final Map<String, IconSet> particles = new HashMap();
    @NotNull
    private static final TextureMatcher typeMappings = new TextureMatcher();

    private LeafRegistry() {
    }

    @NotNull
    public final Map<IIcon, LeafInfo> getLeaves() {
        return leaves;
    }

    @NotNull
    public final Map<String, IconSet> getParticles() {
        return particles;
    }

    @NotNull
    public final TextureMatcher getTypeMappings() {
        return typeMappings;
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public final void handleTextureReload(@NotNull TextureStitchEvent.Pre event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event.map.func_130086_a() != 0) {
            return;
        }
        leaves.clear();
        particles.clear();
        typeMappings.loadMappings(new ResourceLocation("betterfoliage", "leafTextureMappings.cfg"));
        Client.INSTANCE.log(Level.INFO, "Generating leaf textures");
        IconSet it = new IconSet("betterfoliage", "falling_leaf_default_%d");
        boolean bl = false;
        TextureMap textureMap = event.map;
        Intrinsics.checkNotNullExpressionValue((Object)textureMap, (String)"map");
        it.onStitch((IIconRegister)textureMap);
        particles.put("default", it);
        RegistryNamespaced registryNamespaced = Block.field_149771_c;
        Intrinsics.checkNotNullExpressionValue((Object)registryNamespaced, (String)"blockRegistry");
        Iterable $this$forEach$iv = (Iterable)registryNamespaced;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            Object element$iv;
            Object block = element$iv = iterator.next();
            boolean bl2 = false;
            BlockMatcher blockMatcher = Config.blocks.INSTANCE.getLeaves();
            Intrinsics.checkNotNull(block, (String)"null cannot be cast to non-null type net.minecraft.block.Block");
            if (!blockMatcher.matchesClass((Block)block)) continue;
            ((Block)block).func_149651_a(arg_0 -> LeafRegistry.handleTextureReload$lambda$6$lambda$3(event, arg_0));
            if (!OptifineCTM.INSTANCE.isAvailable()) continue;
            Collection<IIcon> ctmIcons = OptifineCTM.INSTANCE.getAllCTM((Block)block);
            boolean bl3 = false;
            if (!(!ctmIcons.isEmpty())) continue;
            Client.INSTANCE.log(Level.INFO, "Found " + ctmIcons.size() + " CTM variants for block " + Block.func_149682_b((Block)((Block)block)));
            Iterable $this$forEach$iv2 = ctmIcons;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                IIcon it2 = (IIcon)element$iv2;
                boolean bl4 = false;
                TextureMap textureMap2 = event.map;
                Intrinsics.checkNotNullExpressionValue((Object)textureMap2, (String)"map");
                Intrinsics.checkNotNull((Object)it2, (String)"null cannot be cast to non-null type net.minecraft.client.renderer.texture.TextureAtlasSprite");
                INSTANCE.registerLeaf(textureMap2, (TextureAtlasSprite)it2);
            }
        }
        ForestryIntegration.INSTANCE.registerLeafTextures(event);
        GT6Integration.INSTANCE.registerLeafTextures(event);
    }

    public final void registerLeaf(@NotNull TextureMap atlas, @NotNull TextureAtlasSprite icon) {
        Intrinsics.checkNotNullParameter((Object)atlas, (String)"atlas");
        Intrinsics.checkNotNullParameter((Object)icon, (String)"icon");
        String string = typeMappings.getType(icon);
        if (string == null) {
            string = "default";
        }
        String leafType = string;
        LeafGenerator leafGenerator = Client.INSTANCE.getGenLeaves();
        String string2 = icon.func_94215_i();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getIconName(...)");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"type", (Object)leafType)};
        IIcon generated = atlas.func_94245_a(leafGenerator.generatedResource(string2, pairArray).toString());
        leafType = this.registerParticle(atlas, leafType);
        Intrinsics.checkNotNull((Object)generated, (String)"null cannot be cast to non-null type net.minecraft.client.renderer.texture.TextureAtlasSprite");
        leaves.put((IIcon)icon, new LeafInfo((TextureAtlasSprite)generated, leafType, 0, 4, null));
    }

    @NotNull
    public final String registerParticle(@NotNull TextureMap atlas, @NotNull String leafType) {
        Intrinsics.checkNotNullParameter((Object)atlas, (String)"atlas");
        Intrinsics.checkNotNullParameter((Object)leafType, (String)"leafType");
        if (!particles.keySet().contains(leafType)) {
            IconSet particleSet = new IconSet("betterfoliage", "falling_leaf_" + leafType + "_%d");
            particleSet.onStitch((IIconRegister)atlas);
            if (particleSet.getNum() == 0) {
                Client.INSTANCE.log(Level.WARN, "Leaf particle textures not found for leaf type: " + leafType);
                return "default";
            }
            particles.put(leafType, particleSet);
        }
        return leafType;
    }

    private static final IIcon handleTextureReload$lambda$6$lambda$3(TextureStitchEvent.Pre $event, String location) {
        TextureAtlasSprite original = $event.map.getTextureExtry(location);
        Client.INSTANCE.log(Level.INFO, "Registering leaf texture: " + location);
        TextureMap textureMap = $event.map;
        Intrinsics.checkNotNullExpressionValue((Object)textureMap, (String)"map");
        Intrinsics.checkNotNull((Object)original);
        INSTANCE.registerLeaf(textureMap, original);
        if (OptifineCTM.INSTANCE.isAvailable()) {
            Collection<IIcon> ctmIcons = OptifineCTM.INSTANCE.getAllCTM((IIcon)original);
            boolean bl = false;
            if (!ctmIcons.isEmpty()) {
                Client.INSTANCE.log(Level.INFO, "Registering " + ctmIcons.size() + " CTM variants for texture " + original.func_94215_i());
                Iterable $this$forEach$iv = ctmIcons;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    IIcon it = (IIcon)element$iv;
                    boolean bl2 = false;
                    TextureMap textureMap2 = $event.map;
                    Intrinsics.checkNotNullExpressionValue((Object)textureMap2, (String)"map");
                    Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type net.minecraft.client.renderer.texture.TextureAtlasSprite");
                    INSTANCE.registerLeaf(textureMap2, (TextureAtlasSprite)it);
                }
            }
        }
        return (IIcon)original;
    }

    static {
        MinecraftForge.EVENT_BUS.register((Object)INSTANCE);
    }
}

